/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;

public class TreeUtils {
    private TreeUtils() {
    }

    @CheckForNull
    public static Tree firstAncestor(Tree tree, Predicate<Tree> predicate) {
        for (Tree currentParent = tree.parent(); currentParent != null; currentParent = currentParent.parent()) {
            if (!predicate.test(currentParent)) continue;
            return currentParent;
        }
        return null;
    }

    @CheckForNull
    public static Tree firstAncestorOfKind(Tree tree, Tree.Kind ... kinds) {
        return TreeUtils.firstAncestor(tree, t -> t.is(kinds));
    }

    public static List<Token> tokens(Tree tree) {
        if (tree.is(Tree.Kind.TOKEN)) {
            return Collections.singletonList((Token)tree);
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Tree child : tree.children()) {
            if (child.is(Tree.Kind.TOKEN)) {
                tokens.add((Token)child);
                continue;
            }
            tokens.addAll(TreeUtils.tokens(child));
        }
        return tokens;
    }

    public static boolean hasDescendant(Tree tree, Predicate<Tree> predicate) {
        return tree.children().stream().anyMatch(child -> predicate.test((Tree)child) || TreeUtils.hasDescendant(child, predicate));
    }
}

