/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.UsageVisitor;
import org.sonar.python.semantic.Symbol;

public abstract class CfgBlockState {
    protected final CfgBlock block;
    protected final Map<Tree, Map<Symbol, UsageVisitor.SymbolUsage>> variableUsagesPerElement;
    protected final Set<Symbol> gen = new HashSet<Symbol>();
    protected final Set<Symbol> kill = new HashSet<Symbol>();

    CfgBlockState(CfgBlock block) {
        this.block = block;
        this.variableUsagesPerElement = new HashMap<Tree, Map<Symbol, UsageVisitor.SymbolUsage>>();
    }

    public Map<Symbol, UsageVisitor.SymbolUsage> getVariableUsages(Tree tree) {
        return this.variableUsagesPerElement.get(tree);
    }

    protected void init(CfgBlock block) {
        HashSet<Symbol> writtenOnly = new HashSet<Symbol>();
        for (Tree element : block.elements()) {
            UsageVisitor usageVisitor = new UsageVisitor();
            element.accept(usageVisitor);
            this.variableUsagesPerElement.put(element, usageVisitor.symbolToUsages());
            this.computeGenAndKill(writtenOnly, usageVisitor.symbolToUsages());
        }
    }

    private void computeGenAndKill(Set<Symbol> writtenOnly, Map<Symbol, UsageVisitor.SymbolUsage> symbolToUsages) {
        for (Map.Entry<Symbol, UsageVisitor.SymbolUsage> symbolListEntry : symbolToUsages.entrySet()) {
            Symbol symbol = symbolListEntry.getKey();
            UsageVisitor.SymbolUsage usage = symbolListEntry.getValue();
            if (usage.isRead() && !writtenOnly.contains(symbol)) {
                this.gen.add(symbol);
            }
            if (!usage.isWrite()) continue;
            this.kill.add(symbol);
            if (usage.isRead()) continue;
            writtenOnly.add(symbol);
        }
    }

    public Set<Symbol> getGen() {
        return this.gen;
    }

    public Set<Symbol> getKill() {
        return this.kill;
    }

    public boolean isSymbolUsedInBlock(Symbol symbol) {
        return this.variableUsagesPerElement.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(s -> s == symbol);
    }
}

