/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;

public class UsageVisitor
extends BaseTreeVisitor {
    private Map<Symbol, SymbolUsage> symbolToUsages = new HashMap<Symbol, SymbolUsage>();

    public Map<Symbol, SymbolUsage> symbolToUsages() {
        return this.symbolToUsages;
    }

    @Override
    public void visitFunctionDef(FunctionDef functionDef) {
        Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> this.symbolToUsages.computeIfAbsent((Symbol)symbol, s -> new SymbolUsage()).isWrite = true);
    }

    @Override
    public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
    }

    @Override
    public void visitName(Name name) {
        Optional.ofNullable(name.usage()).ifPresent(usage -> this.addToSymbolToUsageMap((Usage)usage, name.symbol()));
        super.visitName(name);
    }

    private void addToSymbolToUsageMap(Usage usage, Symbol symbol) {
        SymbolUsage symbolUsage = this.symbolToUsages.getOrDefault(symbol, new SymbolUsage());
        if (!usage.isBindingUsage()) {
            symbolUsage.isRead = true;
        } else if (usage.kind() == Usage.Kind.COMPOUND_ASSIGNMENT_LHS) {
            symbolUsage.isRead = true;
            symbolUsage.isWrite = true;
        } else {
            symbolUsage.isWrite = true;
        }
        this.symbolToUsages.put(symbol, symbolUsage);
    }

    public static final class SymbolUsage {
        private boolean isRead = false;
        private boolean isWrite = false;

        public boolean isWrite() {
            return this.isWrite;
        }

        public boolean isRead() {
            return this.isRead;
        }
    }
}

