/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import java.nio.charset.Charset;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.IndentationChannel;
import org.sonar.python.lexer.LexerState;
import org.sonar.python.lexer.NewLineChannel;
import org.sonar.python.lexer.StringLiteralsChannel;
import org.sonar.sslr.channel.Channel;

public final class PythonLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BYTES_PREFIX = "([bB][Rr]?|[rR][bB]?)";
    private static final String IMAGINARY_SUFFIX = "(j|J)";
    private static final String LONG_INTEGER_SUFFIX = "(l|L)";
    private static final String FORMATTED_STRING_PREFIX = "([fF][rR]?|[rR][fF]?)";

    private PythonLexer() {
    }

    public static Lexer create(Charset charset, LexerState lexerState) {
        return Lexer.builder().withCharset(charset).withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)new NewLineChannel(lexerState)).withChannel((Channel)new IndentationChannel(lexerState)).withChannel((Channel)new BlackHoleChannel("\\s")).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"#[^\\n\\r]*+"})).withChannel((Channel)new StringLiteralsChannel()).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.STRING, (String[])new String[]{"([bB][Rr]?|[rR][bB]?)'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.STRING, (String[])new String[]{"([bB][Rr]?|[rR][bB]?)\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\""})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.STRING, (String[])new String[]{"([fF][rR]?|[rR][fF]?)'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.STRING, (String[])new String[]{"([fF][rR]?|[rR][fF]?)\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\""})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"[0-9]++(_?[0-9])*+\\.[0-9]*+(_?[0-9])*+([Ee][+-]?+[0-9_]++)?+(j|J)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"\\.[0-9]++(_?[0-9])*+([Ee][+-]?+[0-9_]++)?+(j|J)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"[0-9]++(_?[0-9])*+([Ee][+-]?+[0-9_]++)(j|J)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"[0-9]++(_?[0-9])*+(j|J)"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"0[oO]?+(_?[0-7])++(l|L)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"0[xX](_?[0-9a-fA-F])++(l|L)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"0[bB](_?[01])++(l|L)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"[1-9](_?[0-9])*+(l|L)?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)PythonTokenType.NUMBER, (String[])new String[]{"0(_?0)*+(l|L)?+"})).withChannel((Channel)new IdentifierAndKeywordChannel(RegexpChannelBuilder.and((String[])new String[]{"[a-zA-Z_]", RegexpChannelBuilder.o2n((String)"\\w")}), true, (TokenType[][])new TokenType[][]{PythonKeyword.values()})).withChannel((Channel)new PunctuatorChannel((TokenType[])PythonPunctuator.values())).withChannel((Channel)new UnknownCharacterChannel()).build();
    }
}

