/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;
import org.sonar.python.semantic.UsageImpl;
import org.sonar.python.tree.ClassDefImpl;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.LambdaExpressionImpl;
import org.sonar.python.tree.NameImpl;

public class SymbolTableBuilder
extends BaseTreeVisitor {
    private Map<Tree, Scope> scopesByRootTree;
    private Set<Tree> assignmentLeftHandSides = new HashSet<Tree>();

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.scopesByRootTree = new HashMap<Tree, Scope>();
        fileInput.accept(new FirstPhaseVisitor());
        fileInput.accept(new SecondPhaseVisitor());
        for (Scope scope : this.scopesByRootTree.values()) {
            if (scope.rootTree instanceof FunctionLike) {
                FunctionLike funcDef = (FunctionLike)scope.rootTree;
                for (Symbol symbol : scope.symbols()) {
                    if (funcDef.is(Tree.Kind.LAMBDA)) {
                        ((LambdaExpressionImpl)funcDef).addLocalVariableSymbol(symbol);
                        continue;
                    }
                    ((FunctionDefImpl)funcDef).addLocalVariableSymbol(symbol);
                }
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.CLASSDEF)) {
                ClassDefImpl classDef = (ClassDefImpl)scope.rootTree;
                scope.symbols.forEach(classDef::addClassField);
                scope.instanceAttributesByName.values().forEach(classDef::addInstanceField);
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.FILE_INPUT)) {
                scope.symbols.stream().filter(s -> !scope.builtinSymbols.contains(s)).forEach(((FileInputImpl)fileInput)::addGlobalVariables);
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.DICT_COMPREHENSION)) {
                scope.symbols.forEach(((DictCompExpressionImpl)scope.rootTree)::addLocalVariableSymbol);
                continue;
            }
            if (!(scope.rootTree instanceof ComprehensionExpression)) continue;
            scope.symbols.forEach(((ComprehensionExpressionImpl)scope.rootTree)::addLocalVariableSymbol);
        }
    }

    private static List<Name> boundNamesFromExpression(@CheckForNull Tree tree) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (tree == null) {
            return names;
        }
        if (tree.is(Tree.Kind.NAME)) {
            names.add((Name)tree);
        } else if (tree.is(Tree.Kind.TUPLE)) {
            ((Tuple)tree).elements().forEach(t -> names.addAll(SymbolTableBuilder.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.LIST_LITERAL)) {
            ((ListLiteral)tree).elements().expressions().forEach(t -> names.addAll(SymbolTableBuilder.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.PARENTHESIZED)) {
            names.addAll(SymbolTableBuilder.boundNamesFromExpression(((ParenthesizedExpression)tree).expression()));
        } else if (tree.is(Tree.Kind.UNPACKING_EXPR)) {
            names.addAll(SymbolTableBuilder.boundNamesFromExpression(((UnpackingExpression)tree).expression()));
        }
        return names;
    }

    private class SecondPhaseVisitor
    extends ScopeVisitor {
        private SecondPhaseVisitor() {
        }

        @Override
        public void visitFileInput(FileInput tree) {
            this.enterScope(tree);
            super.visitFileInput(tree);
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.enterScope(pyFunctionDefTree);
            super.visitFunctionDef(pyFunctionDefTree);
            this.leaveScope();
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
            this.enterScope(pyLambdaExpressionTree);
            super.visitLambda(pyLambdaExpressionTree);
            this.leaveScope();
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.enterScope(tree);
            this.scan(tree.resultExpression());
            ComprehensionFor comprehensionFor = tree.comprehensionFor();
            this.scan(comprehensionFor.loopExpression());
            this.leaveScope();
            this.scan(comprehensionFor.iterable());
            this.enterScope(tree);
            this.scan(comprehensionFor.nestedClause());
            this.leaveScope();
        }

        @Override
        public void visitDictCompExpression(DictCompExpressionImpl tree) {
            this.enterScope(tree);
            this.scan(tree.keyExpression());
            this.scan(tree.valueExpression());
            ComprehensionFor comprehensionFor = tree.comprehensionFor();
            this.scan(comprehensionFor.loopExpression());
            this.leaveScope();
            this.scan(comprehensionFor.iterable());
            this.enterScope(tree);
            this.scan(comprehensionFor.nestedClause());
            this.leaveScope();
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
            this.enterScope(pyClassDefTree);
            super.visitClassDef(pyClassDefTree);
            this.leaveScope();
        }

        @Override
        public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
            Symbol qualifierSymbol;
            super.visitQualifiedExpression(qualifiedExpression);
            if (qualifiedExpression.qualifier() instanceof HasSymbol && (qualifierSymbol = ((HasSymbol)((Object)qualifiedExpression.qualifier())).symbol()) != null) {
                Usage.Kind usageKind = SymbolTableBuilder.this.assignmentLeftHandSides.contains(qualifiedExpression) ? Usage.Kind.ASSIGNMENT_LHS : Usage.Kind.OTHER;
                ((SymbolImpl)qualifierSymbol).addOrCreateChildUsage(qualifiedExpression.name(), usageKind);
            }
        }

        @Override
        public void visitDecorator(Decorator decorator) {
            Name nameTree = decorator.name().names().get(0);
            this.addSymbolUsage(nameTree);
            super.visitDecorator(decorator);
        }

        @Override
        public void visitName(Name pyNameTree) {
            if (!pyNameTree.isVariable()) {
                return;
            }
            this.addSymbolUsage(pyNameTree);
            super.visitName(pyNameTree);
        }

        private void addSymbolUsage(Name nameTree) {
            Scope scope = (Scope)SymbolTableBuilder.this.scopesByRootTree.get(this.currentScopeRootTree());
            SymbolImpl symbol = scope.resolve(nameTree.name());
            if (symbol != null && symbol.usages().stream().noneMatch(usage -> usage.tree().equals(nameTree))) {
                symbol.addUsage(nameTree, Usage.Kind.OTHER);
            }
        }
    }

    private static class SelfSymbolImpl
    extends SymbolImpl {
        private final Scope classScope;

        SelfSymbolImpl(String name, Scope classScope) {
            super(name, null);
            this.classScope = classScope;
        }

        @Override
        void addOrCreateChildUsage(Name nameTree, Usage.Kind kind) {
            SymbolImpl symbol = this.classScope.instanceAttributesByName.computeIfAbsent(nameTree.name(), name -> new SymbolImpl((String)name, null));
            symbol.addUsage(nameTree, kind);
        }
    }

    private static class SymbolImpl
    implements Symbol {
        private final String name;
        @Nullable
        private String fullyQualifiedName;
        private final List<Usage> usages = new ArrayList<Usage>();
        private Map<String, Symbol> childrenSymbolByName = new HashMap<String, Symbol>();

        public SymbolImpl(String name, @Nullable String fullyQualifiedName) {
            this.name = name;
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<Usage> usages() {
            return Collections.unmodifiableList(this.usages);
        }

        @Override
        @CheckForNull
        public String fullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        void addUsage(Tree tree, Usage.Kind kind) {
            UsageImpl usage = new UsageImpl(tree, kind);
            this.usages.add(usage);
            if (tree.is(Tree.Kind.NAME)) {
                ((NameImpl)tree).setSymbol(this);
                ((NameImpl)tree).setUsage(usage);
            }
        }

        void addOrCreateChildUsage(Name name, Usage.Kind kind) {
            String childSymbolName = name.name();
            if (!this.childrenSymbolByName.containsKey(childSymbolName)) {
                String childFullyQualifiedName = this.fullyQualifiedName != null ? this.fullyQualifiedName + "." + childSymbolName : null;
                SymbolImpl symbol = new SymbolImpl(childSymbolName, childFullyQualifiedName);
                this.childrenSymbolByName.put(childSymbolName, symbol);
            }
            Symbol symbol = this.childrenSymbolByName.get(childSymbolName);
            ((SymbolImpl)symbol).addUsage(name, kind);
        }
    }

    static class Scope {
        private final Tree rootTree;
        private final Scope parent;
        private final Map<String, Symbol> symbolsByName = new HashMap<String, Symbol>();
        private final Set<Symbol> symbols = new HashSet<Symbol>();
        private final Set<Symbol> builtinSymbols = new HashSet<Symbol>();
        private final Set<String> globalNames = new HashSet<String>();
        private final Set<String> nonlocalNames = new HashSet<String>();
        private final Map<String, SymbolImpl> instanceAttributesByName = new HashMap<String, SymbolImpl>();

        private Scope(@Nullable Scope parent, Tree rootTree) {
            this.parent = parent;
            this.rootTree = rootTree;
        }

        private Set<Symbol> symbols() {
            return Collections.unmodifiableSet(this.symbols);
        }

        void createBuiltinSymbol(String name) {
            SymbolImpl symbol = new SymbolImpl(name, name);
            this.symbols.add(symbol);
            this.builtinSymbols.add(symbol);
            this.symbolsByName.put(name, symbol);
        }

        private void createSelfParameter(Parameter parameter) {
            Name nameTree = parameter.name();
            if (nameTree != null) {
                String symbolName = nameTree.name();
                SelfSymbolImpl symbol = new SelfSymbolImpl(symbolName, this.parent);
                this.symbols.add(symbol);
                this.symbolsByName.put(symbolName, symbol);
                symbol.addUsage(nameTree, Usage.Kind.PARAMETER);
            }
        }

        void addBindingUsage(Name nameTree, Usage.Kind kind, @Nullable String fullyQualifiedName) {
            SymbolImpl symbol;
            String symbolName = nameTree.name();
            if (!(this.symbolsByName.containsKey(symbolName) || this.globalNames.contains(symbolName) || this.nonlocalNames.contains(symbolName))) {
                symbol = new SymbolImpl(symbolName, fullyQualifiedName);
                this.symbols.add(symbol);
                this.symbolsByName.put(symbolName, symbol);
            }
            if ((symbol = this.resolve(symbolName)) != null) {
                if (fullyQualifiedName != null && !fullyQualifiedName.equals(symbol.fullyQualifiedName)) {
                    symbol.fullyQualifiedName = null;
                }
                if (fullyQualifiedName == null && symbol.fullyQualifiedName != null) {
                    symbol.fullyQualifiedName = null;
                }
                symbol.addUsage(nameTree, kind);
            }
        }

        @CheckForNull
        SymbolImpl resolve(String symbolName) {
            Symbol symbol = this.symbolsByName.get(symbolName);
            if (this.parent == null || symbol != null) {
                return (SymbolImpl)symbol;
            }
            return this.parent.resolve(symbolName);
        }

        void addGlobalName(String name) {
            this.globalNames.add(name);
        }

        void addNonLocalName(String name) {
            this.nonlocalNames.add(name);
        }
    }

    private class FirstPhaseVisitor
    extends ScopeVisitor {
        private FirstPhaseVisitor() {
        }

        @Override
        public void visitFileInput(FileInput tree) {
            this.createScope(tree, null);
            this.enterScope(tree);
            this.moduleScope = this.currentScope();
            BuiltinSymbols.all().forEach(this.currentScope()::createBuiltinSymbol);
            super.visitFileInput(tree);
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
            this.createScope(pyLambdaExpressionTree, this.currentScope());
            this.enterScope(pyLambdaExpressionTree);
            this.createParameters(pyLambdaExpressionTree);
            super.visitLambda(pyLambdaExpressionTree);
            this.leaveScope();
        }

        @Override
        public void visitDictCompExpression(DictCompExpressionImpl tree) {
            this.createScope(tree, this.currentScope());
            this.enterScope(tree);
            super.visitDictCompExpression(tree);
            this.leaveScope();
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.createScope(tree, this.currentScope());
            this.enterScope(tree);
            super.visitPyListOrSetCompExpression(tree);
            this.leaveScope();
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.addBindingUsage(pyFunctionDefTree.name(), Usage.Kind.FUNC_DECLARATION);
            this.createScope(pyFunctionDefTree, this.currentScope());
            this.enterScope(pyFunctionDefTree);
            this.createParameters(pyFunctionDefTree);
            super.visitFunctionDef(pyFunctionDefTree);
            this.leaveScope();
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
            this.addBindingUsage(pyClassDefTree.name(), Usage.Kind.CLASS_DECLARATION);
            this.createScope(pyClassDefTree, this.currentScope());
            this.enterScope(pyClassDefTree);
            super.visitClassDef(pyClassDefTree);
            this.leaveScope();
        }

        @Override
        public void visitImportName(ImportName pyImportNameTree) {
            this.createImportedNames(pyImportNameTree.modules(), null, false);
            super.visitImportName(pyImportNameTree);
        }

        @Override
        public void visitImportFrom(ImportFrom pyImportFromTree) {
            DottedName moduleTree = pyImportFromTree.module();
            String moduleName = moduleTree != null ? moduleTree.names().stream().map(Name::name).collect(Collectors.joining(".")) : null;
            this.createImportedNames(pyImportFromTree.importedNames(), moduleName, !pyImportFromTree.dottedPrefixForModule().isEmpty());
            super.visitImportFrom(pyImportFromTree);
        }

        private void createImportedNames(List<AliasedName> importedNames, @Nullable String fromModuleName, boolean isRelativeImport) {
            importedNames.forEach(module -> {
                String fullyQualifiedName;
                Name nameTree = module.dottedName().names().get(0);
                String string = fullyQualifiedName = fromModuleName != null ? fromModuleName + "." + nameTree.name() : nameTree.name();
                if (isRelativeImport) {
                    fullyQualifiedName = null;
                }
                if (module.alias() != null) {
                    this.addBindingUsage(module.alias(), Usage.Kind.IMPORT, fullyQualifiedName);
                } else {
                    this.addBindingUsage(nameTree, Usage.Kind.IMPORT, fullyQualifiedName);
                }
            });
        }

        @Override
        public void visitForStatement(ForStatement pyForStatementTree) {
            this.createLoopVariables(pyForStatementTree);
            super.visitForStatement(pyForStatementTree);
        }

        @Override
        public void visitComprehensionFor(ComprehensionFor tree) {
            this.addCompDeclarationParam(tree.loopExpression());
            super.visitComprehensionFor(tree);
        }

        private void addCompDeclarationParam(Tree tree) {
            SymbolTableBuilder.boundNamesFromExpression(tree).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.COMP_DECLARATION));
        }

        private void createLoopVariables(ForStatement loopTree) {
            loopTree.expressions().forEach(expr -> SymbolTableBuilder.boundNamesFromExpression(expr).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.LOOP_DECLARATION)));
        }

        private void createParameters(FunctionLike function) {
            AnyParameter first;
            ParameterList parameterList = function.parameters();
            if (parameterList == null || parameterList.all().isEmpty()) {
                return;
            }
            boolean hasSelf = false;
            if (function.isMethodDefinition() && (first = parameterList.all().get(0)).is(Tree.Kind.PARAMETER)) {
                this.currentScope().createSelfParameter((Parameter)first);
                hasSelf = true;
            }
            parameterList.nonTuple().stream().skip(hasSelf ? 1L : 0L).map(Parameter::name).filter(Objects::nonNull).forEach(param -> this.addBindingUsage((Name)param, Usage.Kind.PARAMETER));
            parameterList.all().stream().filter(param -> param.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
        }

        private void addTupleParamElementsToBindingUsage(TupleParameter param) {
            param.parameters().stream().filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).name()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.PARAMETER));
            param.parameters().stream().filter(p -> p.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
            List<Expression> lhs = pyAssignmentStatementTree.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).flatMap(this::flattenTuples).collect(Collectors.toList());
            SymbolTableBuilder.this.assignmentLeftHandSides.addAll(lhs);
            lhs.forEach(expression -> SymbolTableBuilder.boundNamesFromExpression(expression).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.ASSIGNMENT_LHS)));
            super.visitAssignmentStatement(pyAssignmentStatementTree);
        }

        private Stream<Expression> flattenTuples(Expression expression) {
            if (expression.is(Tree.Kind.TUPLE)) {
                Tuple tuple = (Tuple)expression;
                return tuple.elements().stream().flatMap(this::flattenTuples);
            }
            return Stream.of(expression);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                this.addBindingUsage((Name)annotatedAssignment.variable(), Usage.Kind.ASSIGNMENT_LHS);
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }

        @Override
        public void visitCompoundAssignment(CompoundAssignmentStatement pyCompoundAssignmentStatementTree) {
            if (pyCompoundAssignmentStatementTree.lhsExpression().is(Tree.Kind.NAME)) {
                this.addBindingUsage((Name)pyCompoundAssignmentStatementTree.lhsExpression(), Usage.Kind.COMPOUND_ASSIGNMENT_LHS);
            }
            super.visitCompoundAssignment(pyCompoundAssignmentStatementTree);
        }

        @Override
        public void visitGlobalStatement(GlobalStatement pyGlobalStatementTree) {
            pyGlobalStatementTree.variables().forEach(name -> {
                this.currentScope().addGlobalName(name.name());
                this.moduleScope.addBindingUsage((Name)name, Usage.Kind.GLOBAL_DECLARATION, null);
            });
            super.visitGlobalStatement(pyGlobalStatementTree);
        }

        @Override
        public void visitNonlocalStatement(NonlocalStatement pyNonlocalStatementTree) {
            pyNonlocalStatementTree.variables().stream().map(Name::name).forEach(name -> this.currentScope().addNonLocalName((String)name));
            super.visitNonlocalStatement(pyNonlocalStatementTree);
        }

        @Override
        public void visitExceptClause(ExceptClause exceptClause) {
            SymbolTableBuilder.boundNamesFromExpression(exceptClause.exceptionInstance()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.EXCEPTION_INSTANCE));
            super.visitExceptClause(exceptClause);
        }

        @Override
        public void visitWithItem(WithItem withItem) {
            SymbolTableBuilder.boundNamesFromExpression(withItem.expression()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.WITH_INSTANCE));
            super.visitWithItem(withItem);
        }

        private void createScope(Tree tree, @Nullable Scope parent) {
            SymbolTableBuilder.this.scopesByRootTree.put(tree, new Scope(parent, tree));
        }

        private void addBindingUsage(Name nameTree, Usage.Kind usage, @Nullable String fullyQualifiedName) {
            this.currentScope().addBindingUsage(nameTree, usage, fullyQualifiedName);
        }

        private void addBindingUsage(Name nameTree, Usage.Kind usage) {
            this.currentScope().addBindingUsage(nameTree, usage, null);
        }

        private Scope currentScope() {
            return (Scope)SymbolTableBuilder.this.scopesByRootTree.get(this.currentScopeRootTree());
        }
    }

    private static class ScopeVisitor
    extends BaseTreeVisitor {
        private Deque<Tree> scopeRootTrees = new LinkedList<Tree>();
        protected Scope moduleScope;

        private ScopeVisitor() {
        }

        Tree currentScopeRootTree() {
            return this.scopeRootTrees.peek();
        }

        void enterScope(Tree tree) {
            this.scopeRootTrees.push(tree);
        }

        void leaveScope() {
            this.scopeRootTrees.pop();
        }
    }
}

