/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class BinaryExpressionImpl
extends PyTree
implements BinaryExpression {
    private static final Map<String, Tree.Kind> KINDS_BY_OPERATOR = BinaryExpressionImpl.kindsByOperator();
    private final Tree.Kind kind;
    private final Expression leftOperand;
    private final Token operator;
    private final Expression rightOperand;

    private static Map<String, Tree.Kind> kindsByOperator() {
        HashMap<String, Tree.Kind> map = new HashMap<String, Tree.Kind>();
        map.put("+", Tree.Kind.PLUS);
        map.put("-", Tree.Kind.MINUS);
        map.put("*", Tree.Kind.MULTIPLICATION);
        map.put("/", Tree.Kind.DIVISION);
        map.put("//", Tree.Kind.FLOOR_DIVISION);
        map.put("%", Tree.Kind.MODULO);
        map.put("**", Tree.Kind.POWER);
        map.put("@", Tree.Kind.MATRIX_MULTIPLICATION);
        map.put(">>", Tree.Kind.SHIFT_EXPR);
        map.put("<<", Tree.Kind.SHIFT_EXPR);
        map.put("&", Tree.Kind.BITWISE_AND);
        map.put("|", Tree.Kind.BITWISE_OR);
        map.put("^", Tree.Kind.BITWISE_XOR);
        map.put("and", Tree.Kind.AND);
        map.put("or", Tree.Kind.OR);
        map.put("==", Tree.Kind.COMPARISON);
        map.put("<=", Tree.Kind.COMPARISON);
        map.put(">=", Tree.Kind.COMPARISON);
        map.put("<", Tree.Kind.COMPARISON);
        map.put(">", Tree.Kind.COMPARISON);
        map.put("!=", Tree.Kind.COMPARISON);
        map.put("<>", Tree.Kind.COMPARISON);
        return map;
    }

    public BinaryExpressionImpl(Expression leftOperand, Token operator, Expression rightOperand) {
        this.kind = KINDS_BY_OPERATOR.get(operator.value());
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @Override
    public Expression leftOperand() {
        return this.leftOperand;
    }

    @Override
    public Token operator() {
        return this.operator;
    }

    @Override
    public Expression rightOperand() {
        return this.rightOperand;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.leftOperand, this.operator, this.rightOperand).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

