/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.tree.PyTree;

public class DictCompExpressionImpl
extends PyTree
implements DictCompExpression {
    private final Token openingBrace;
    private final Expression keyExpression;
    private final Token colon;
    private final Expression valueExpression;
    private final ComprehensionFor comprehensionFor;
    private final Token closingBrace;
    private Set<Symbol> symbols = new HashSet<Symbol>();

    public DictCompExpressionImpl(Token openingBrace, Expression keyExpression, Token colon, Expression valueExpression, ComprehensionFor compFor, Token closingBrace) {
        this.openingBrace = openingBrace;
        this.keyExpression = keyExpression;
        this.colon = colon;
        this.valueExpression = valueExpression;
        this.comprehensionFor = compFor;
        this.closingBrace = closingBrace;
    }

    @Override
    public Expression keyExpression() {
        return this.keyExpression;
    }

    @Override
    public Token colonToken() {
        return this.colon;
    }

    @Override
    public Expression valueExpression() {
        return this.valueExpression;
    }

    @Override
    public ComprehensionFor comprehensionFor() {
        return this.comprehensionFor;
    }

    @Override
    public Set<Symbol> localVariables() {
        return this.symbols;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDictCompExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.openingBrace, this.keyExpression, this.colon, this.valueExpression, this.comprehensionFor, this.closingBrace).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DICT_COMPREHENSION;
    }

    public void addLocalVariableSymbol(Symbol symbol) {
        this.symbols.add(symbol);
    }
}

