/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;
import org.sonar.python.tree.PyTree;

public class NameImpl
extends PyTree
implements Name {
    private final Token token;
    private final String name;
    private final boolean isVariable;
    private Symbol symbol;
    private Usage usage;

    public NameImpl(Token token, boolean isVariable) {
        this.token = token;
        this.name = token.value();
        this.isVariable = isVariable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        boolean isKeyword = false;
        if (this.parent() != null && this.parent().is(Tree.Kind.REGULAR_ARGUMENT)) {
            isKeyword = ((RegularArgument)this.parent()).keywordArgument() == this;
        }
        return this.isVariable && !isKeyword;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NAME;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitName(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.singletonList(this.token);
    }

    @Override
    @CheckForNull
    public Symbol symbol() {
        return this.symbol;
    }

    @Override
    @CheckForNull
    public Usage usage() {
        return this.usage;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
    }
}

