/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

public class ClassSymbolImpl
extends SymbolImpl
implements ClassSymbol {
    private final List<Symbol> superClasses = new ArrayList<Symbol>();
    private Set<Symbol> allSuperClasses = null;
    private Set<Symbol> allSuperClassesIncludingAmbiguousSymbols = null;
    private boolean hasSuperClassWithoutSymbol = false;
    private final Set<Symbol> members = new HashSet<Symbol>();
    private Map<String, Symbol> membersByName = null;
    private boolean hasAlreadyReadSuperClasses = false;
    private boolean hasAlreadyReadMembers = false;
    private final LocationInFile classDefinitionLocation;

    public ClassSymbolImpl(ClassDef classDef, @Nullable String fullyQualifiedName, PythonFile pythonFile) {
        super(classDef.name().name(), fullyQualifiedName);
        this.setKind(Symbol.Kind.CLASS);
        String fileId = null;
        if (!SymbolUtils.isTypeShedFile(pythonFile)) {
            Path path = SymbolUtils.pathOf(pythonFile);
            fileId = path != null ? path.toString() : pythonFile.toString();
        }
        this.classDefinitionLocation = TreeUtils.locationInFile(classDef.name(), fileId);
    }

    public ClassSymbolImpl(String name, @Nullable String fullyQualifiedName) {
        this(name, fullyQualifiedName, null);
    }

    public ClassSymbolImpl(String name, @Nullable String fullyQualifiedName, @Nullable LocationInFile definitionLocation) {
        super(name, fullyQualifiedName);
        this.classDefinitionLocation = definitionLocation;
        this.setKind(Symbol.Kind.CLASS);
    }

    @Override
    ClassSymbolImpl copyWithoutUsages() {
        ClassSymbolImpl copiedClassSymbol = new ClassSymbolImpl(this.name(), this.fullyQualifiedName(), this.definitionLocation());
        for (Symbol superClass : this.superClasses()) {
            if (superClass == this) {
                copiedClassSymbol.superClasses.add(copiedClassSymbol);
                continue;
            }
            if (superClass.kind() == Symbol.Kind.CLASS) {
                copiedClassSymbol.superClasses.add(((ClassSymbolImpl)superClass).copyWithoutUsages());
                continue;
            }
            copiedClassSymbol.superClasses.add(new SymbolImpl(superClass.name(), superClass.fullyQualifiedName()));
        }
        copiedClassSymbol.addMembers(this.members.stream().map(m -> ((SymbolImpl)m).copyWithoutUsages()).collect(Collectors.toList()));
        if (this.hasSuperClassWithoutSymbol) {
            copiedClassSymbol.setHasSuperClassWithoutSymbol();
        }
        return copiedClassSymbol;
    }

    @Override
    public List<Symbol> superClasses() {
        this.hasAlreadyReadSuperClasses = true;
        return Collections.unmodifiableList(this.superClasses);
    }

    public void addSuperClass(Symbol symbol) {
        if (this.hasAlreadyReadSuperClasses) {
            throw new IllegalStateException("Cannot call addSuperClass, super classes were already read");
        }
        this.superClasses.add(symbol);
    }

    @Override
    public boolean hasUnresolvedTypeHierarchy() {
        return this.hasUnresolvedTypeHierarchy(true);
    }

    public boolean hasUnresolvedTypeHierarchy(boolean includeAmbiguousSymbols) {
        for (Symbol superClassSymbol : this.allSuperClasses(includeAmbiguousSymbols)) {
            if (superClassSymbol.kind() != Symbol.Kind.CLASS) {
                return true;
            }
            ClassSymbolImpl superClass = (ClassSymbolImpl)superClassSymbol;
            if (!superClass.hasSuperClassWithoutSymbol) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Symbol> declaredMembers() {
        this.hasAlreadyReadMembers = true;
        return this.members;
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        for (Symbol symbol : this.allSuperClasses(false)) {
            ClassSymbolImpl classSymbol;
            Symbol matchingMember;
            if (symbol.kind() != Symbol.Kind.CLASS || (matchingMember = (classSymbol = (ClassSymbolImpl)symbol).membersByName().get(memberName)) == null) continue;
            return Optional.of(matchingMember);
        }
        return Optional.empty();
    }

    @Override
    public LocationInFile definitionLocation() {
        return this.classDefinitionLocation;
    }

    @Override
    public boolean isOrExtends(String fullyQualifiedClassName) {
        return this.allSuperClasses(false).stream().anyMatch(c -> c.fullyQualifiedName() != null && Objects.equals(fullyQualifiedClassName, c.fullyQualifiedName()));
    }

    @Override
    public boolean isOrExtends(ClassSymbol other) {
        return this.allSuperClasses(false).stream().anyMatch(c -> Objects.equals(c.fullyQualifiedName(), other.fullyQualifiedName()));
    }

    @Override
    public boolean canBeOrExtend(String fullyQualifiedClassName) {
        return this.allSuperClasses(true).stream().anyMatch(c -> c.fullyQualifiedName() != null && Objects.equals(fullyQualifiedClassName, c.fullyQualifiedName())) || this.hasUnresolvedTypeHierarchy();
    }

    private Map<String, Symbol> membersByName() {
        if (this.membersByName == null) {
            this.membersByName = this.declaredMembers().stream().collect(Collectors.toMap(Symbol::name, m -> m, (s1, s2) -> s1));
        }
        return this.membersByName;
    }

    public void addMembers(Collection<Symbol> members) {
        if (this.hasAlreadyReadMembers) {
            throw new IllegalStateException("Cannot call addMembers, members were already read");
        }
        this.members.addAll(members);
        members.stream().filter(m -> m.kind() == Symbol.Kind.FUNCTION).forEach(m -> ((FunctionSymbolImpl)m).setOwner(this));
    }

    public void setHasSuperClassWithoutSymbol() {
        this.hasSuperClassWithoutSymbol = true;
    }

    private Set<Symbol> allSuperClasses(boolean includeAmbiguousSymbols) {
        if (!includeAmbiguousSymbols) {
            if (this.allSuperClasses == null) {
                this.allSuperClasses = new LinkedHashSet<Symbol>();
                ClassSymbolImpl.exploreSuperClasses(this, this.allSuperClasses, false);
            }
            return this.allSuperClasses;
        }
        if (this.allSuperClassesIncludingAmbiguousSymbols == null) {
            this.allSuperClassesIncludingAmbiguousSymbols = new LinkedHashSet<Symbol>();
            ClassSymbolImpl.exploreSuperClasses(this, this.allSuperClassesIncludingAmbiguousSymbols, true);
        }
        return this.allSuperClassesIncludingAmbiguousSymbols;
    }

    private static void exploreSuperClasses(Symbol symbol, Set<Symbol> set, boolean includeAmbiguousSymbols) {
        block3: {
            block2: {
                if (!symbol.is(Symbol.Kind.AMBIGUOUS) || !includeAmbiguousSymbols) break block2;
                AmbiguousSymbol ambiguousSymbol = (AmbiguousSymbol)symbol;
                for (Symbol alternative : ambiguousSymbol.alternatives()) {
                    ClassSymbolImpl.exploreSuperClasses(alternative, set, true);
                }
                break block3;
            }
            if (!set.add(symbol) || !symbol.is(Symbol.Kind.CLASS)) break block3;
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            for (Symbol superClass : classSymbol.superClasses()) {
                ClassSymbolImpl.exploreSuperClasses(superClass, set, includeAmbiguousSymbols);
            }
        }
    }

    @Override
    public void removeUsages() {
        super.removeUsages();
        this.superClasses.forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
        this.members.forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
    }

    boolean hasSuperClassWithoutSymbol() {
        return this.hasSuperClassWithoutSymbol;
    }
}

