/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionClause;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.ExecStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FormatSpecifier;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.ImportStatement;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.PassStatement;
import org.sonar.plugins.python.api.tree.PrintStatement;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.parser.FStringParser;
import org.sonar.python.tree.AliasedNameImpl;
import org.sonar.python.tree.AnnotatedAssignmentImpl;
import org.sonar.python.tree.ArgListImpl;
import org.sonar.python.tree.AssertStatementImpl;
import org.sonar.python.tree.AssignmentExpressionImpl;
import org.sonar.python.tree.AssignmentStatementImpl;
import org.sonar.python.tree.AwaitExpressionImpl;
import org.sonar.python.tree.BinaryExpressionImpl;
import org.sonar.python.tree.BreakStatementImpl;
import org.sonar.python.tree.CallExpressionImpl;
import org.sonar.python.tree.ClassDefImpl;
import org.sonar.python.tree.CompoundAssignmentStatementImpl;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.ComprehensionForImpl;
import org.sonar.python.tree.ComprehensionIfImpl;
import org.sonar.python.tree.ConditionalExpressionImpl;
import org.sonar.python.tree.ContinueStatementImpl;
import org.sonar.python.tree.DecoratorImpl;
import org.sonar.python.tree.DelStatementImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.DictionaryLiteralImpl;
import org.sonar.python.tree.DottedNameImpl;
import org.sonar.python.tree.EllipsisExpressionImpl;
import org.sonar.python.tree.ElseClauseImpl;
import org.sonar.python.tree.ExceptClauseImpl;
import org.sonar.python.tree.ExecStatementImpl;
import org.sonar.python.tree.ExpressionListImpl;
import org.sonar.python.tree.ExpressionStatementImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.FinallyClauseImpl;
import org.sonar.python.tree.ForStatementImpl;
import org.sonar.python.tree.FormatSpecifierImpl;
import org.sonar.python.tree.FormattedExpressionImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.GlobalStatementImpl;
import org.sonar.python.tree.IfStatementImpl;
import org.sonar.python.tree.ImportFromImpl;
import org.sonar.python.tree.ImportNameImpl;
import org.sonar.python.tree.InExpressionImpl;
import org.sonar.python.tree.IsExpressionImpl;
import org.sonar.python.tree.KeyValuePairImpl;
import org.sonar.python.tree.LambdaExpressionImpl;
import org.sonar.python.tree.ListLiteralImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.NoneExpressionImpl;
import org.sonar.python.tree.NonlocalStatementImpl;
import org.sonar.python.tree.NumericLiteralImpl;
import org.sonar.python.tree.ParameterImpl;
import org.sonar.python.tree.ParameterListImpl;
import org.sonar.python.tree.ParenthesizedExpressionImpl;
import org.sonar.python.tree.PassStatementImpl;
import org.sonar.python.tree.PrintStatementImpl;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.QualifiedExpressionImpl;
import org.sonar.python.tree.RaiseStatementImpl;
import org.sonar.python.tree.RegularArgumentImpl;
import org.sonar.python.tree.ReprExpressionImpl;
import org.sonar.python.tree.ReturnStatementImpl;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SetLiteralImpl;
import org.sonar.python.tree.SliceExpressionImpl;
import org.sonar.python.tree.SliceItemImpl;
import org.sonar.python.tree.SliceListImpl;
import org.sonar.python.tree.StatementListImpl;
import org.sonar.python.tree.StatementWithSeparator;
import org.sonar.python.tree.StringElementImpl;
import org.sonar.python.tree.StringLiteralImpl;
import org.sonar.python.tree.SubscriptionExpressionImpl;
import org.sonar.python.tree.TokenImpl;
import org.sonar.python.tree.TryStatementImpl;
import org.sonar.python.tree.TupleImpl;
import org.sonar.python.tree.TupleParameterImpl;
import org.sonar.python.tree.TypeAnnotationImpl;
import org.sonar.python.tree.UnaryExpressionImpl;
import org.sonar.python.tree.UnpackingExpressionImpl;
import org.sonar.python.tree.WhileStatementImpl;
import org.sonar.python.tree.WithStatementImpl;
import org.sonar.python.tree.YieldExpressionImpl;
import org.sonar.python.tree.YieldStatementImpl;

public class PythonTreeMaker {
    private static final FStringParser F_STRING_PARSER = new FStringParser();

    public FileInput fileInput(AstNode astNode) {
        List<Statement> statements = PythonTreeMaker.getStatements(astNode).stream().map(this::statement).collect(Collectors.toList());
        StatementListImpl statementList = statements.isEmpty() ? null : new StatementListImpl(statements);
        Token endOfFile = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{GenericTokenType.EOF}).getToken());
        FileInputImpl pyFileInputTree = new FileInputImpl(statementList, endOfFile, DocstringExtractor.extractDocstring(statementList));
        this.setParents(pyFileInputTree);
        return pyFileInputTree;
    }

    private static Token toPyToken(@Nullable com.sonar.sslr.api.Token token) {
        if (token == null) {
            return null;
        }
        return new TokenImpl(token);
    }

    private static List<Token> toPyToken(List<com.sonar.sslr.api.Token> tokens) {
        return tokens.stream().map(TokenImpl::new).collect(Collectors.toList());
    }

    public void setParents(Tree root) {
        for (Tree child : root.children()) {
            if (child == null) continue;
            ((PyTree)child).setParent(root);
            this.setParents(child);
        }
    }

    private Statement statement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        if (astNode.is(new AstNodeType[]{PythonGrammar.IF_STMT})) {
            return this.ifStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.PASS_STMT})) {
            return this.passStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.PRINT_STMT})) {
            return this.printStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXEC_STMT})) {
            return this.execStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASSERT_STMT})) {
            return this.assertStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.DEL_STMT})) {
            return this.delStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.RETURN_STMT})) {
            return this.returnStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.YIELD_STMT})) {
            return this.yieldStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.RAISE_STMT})) {
            return this.raiseStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.BREAK_STMT})) {
            return this.breakStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CONTINUE_STMT})) {
            return this.continueStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            return this.funcDefStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
            return this.classDefStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.IMPORT_STMT})) {
            return this.importStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            return this.forStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.WHILE_STMT})) {
            return this.whileStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.GLOBAL_STMT})) {
            return this.globalStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NONLOCAL_STMT})) {
            return this.nonlocalStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.ANNASSIGN})) {
            return this.annotatedAssignment(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
            return this.assignment(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.AUGASSIGN})) {
            return this.compoundAssignment(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT})) {
            return this.expressionStatement(statementWithSeparator);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TRY_STMT})) {
            return this.tryStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            return this.forStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.WITH_STMT})) {
            return this.withStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.WITH_STMT})) {
            return this.withStatement(astNode);
        }
        throw new IllegalStateException("Statement " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    public AnnotatedAssignment annotatedAssignment(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode annAssign = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ANNASSIGN});
        AstNode colonTokenNode = annAssign.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
        Expression variable = this.exprListOrTestList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}));
        Expression annotation = this.expression(annAssign.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
        AstNode equalTokenNode = annAssign.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        Token equalToken = null;
        Expression assignedValue = null;
        if (equalTokenNode != null) {
            equalToken = PythonTreeMaker.toPyToken(equalTokenNode.getToken());
            assignedValue = this.expression(equalTokenNode.getNextSibling());
        }
        TypeAnnotationImpl typeAnnotation = new TypeAnnotationImpl(PythonTreeMaker.toPyToken(colonTokenNode.getToken()), annotation, Tree.Kind.VARIABLE_TYPE_ANNOTATION);
        return new AnnotatedAssignmentImpl(variable, typeAnnotation, equalToken, assignedValue, separators);
    }

    private StatementList getStatementListFromSuite(AstNode suite) {
        return new StatementListImpl(this.getStatementsFromSuite(suite));
    }

    private List<Statement> getStatementsFromSuite(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE})) {
            List<StatementWithSeparator> statements = PythonTreeMaker.getStatements(astNode);
            if (statements.isEmpty()) {
                List<StatementWithSeparator> statementsWithSeparators = PythonTreeMaker.getStatementsWithSeparators(astNode);
                return statementsWithSeparators.stream().map(this::statement).collect(Collectors.toList());
            }
            return statements.stream().map(this::statement).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<StatementWithSeparator> getStatements(AstNode astNode) {
        List statements = astNode.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        ArrayList<StatementWithSeparator> statementsWithSeparators = new ArrayList<StatementWithSeparator>();
        for (AstNode stmt : statements) {
            if (stmt.hasDirectChildren(new AstNodeType[]{PythonGrammar.STMT_LIST})) {
                List<StatementWithSeparator> statementList = PythonTreeMaker.getStatementsWithSeparators(stmt);
                statementsWithSeparators.addAll(statementList);
                continue;
            }
            StatementWithSeparator compoundStmt = new StatementWithSeparator(stmt.getFirstChild(new AstNodeType[]{PythonGrammar.COMPOUND_STMT}).getFirstChild(), null);
            statementsWithSeparators.add(compoundStmt);
        }
        return statementsWithSeparators;
    }

    private static List<StatementWithSeparator> getStatementsWithSeparators(AstNode stmt) {
        ArrayList<StatementWithSeparator> statementsWithSeparators = new ArrayList<StatementWithSeparator>();
        AstNode stmtListNode = stmt.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        AstNode newLine = stmt.getFirstChild(new AstNodeType[]{PythonTokenType.NEWLINE});
        List children = stmtListNode.getChildren();
        int nbChildren = children.size();
        for (int i = 0; i < nbChildren; i += 2) {
            boolean isLastStmt;
            AstNode current = (AstNode)children.get(i);
            AstNode separator = current.getNextSibling();
            AstNode newLineForSeparator = null;
            boolean bl = isLastStmt = nbChildren - i <= 2;
            if (isLastStmt) {
                newLineForSeparator = newLine;
            }
            statementsWithSeparators.add(new StatementWithSeparator(current.getFirstChild(), new Separators(separator, newLineForSeparator)));
        }
        return statementsWithSeparators;
    }

    public PrintStatement printStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        List<Expression> expressions = this.expressionsFromTest(astNode);
        Separators separators = statementWithSeparator.separator();
        return new PrintStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressions, separators);
    }

    public ExecStatement execStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Expression expression = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        List<Expression> expressions = this.expressionsFromTest(astNode);
        Separators separators = statementWithSeparator.separator();
        if (expressions.isEmpty()) {
            return new ExecStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expression, separators);
        }
        Token inToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken());
        Expression globalsExpression = expressions.get(0);
        Token commaToken = null;
        Expression localsExpression = null;
        if (expressions.size() == 2) {
            commaToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COMMA}).getToken());
            localsExpression = expressions.get(1);
        }
        return new ExecStatementImpl(PythonTreeMaker.toPyToken((com.sonar.sslr.api.Token)astNode.getTokens().get(0)), expression, inToken, globalsExpression, commaToken, localsExpression, separators);
    }

    public AssertStatement assertStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        List<Expression> expressions = this.expressionsFromTest(stmt);
        Expression condition = expressions.get(0);
        Expression message = null;
        if (expressions.size() > 1) {
            message = expressions.get(1);
        }
        return new AssertStatementImpl(PythonTreeMaker.toPyToken(stmt.getTokens()).get(0), condition, message, separators);
    }

    public PassStatement passStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new PassStatementImpl(PythonTreeMaker.toPyToken(stmt.getTokens()).get(0), separators);
    }

    public DelStatement delStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        List<Expression> expressionTrees = this.expressionsFromExprList(stmt.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        return new DelStatementImpl(PythonTreeMaker.toPyToken(stmt.getTokens()).get(0), expressionTrees, separators);
    }

    public ReturnStatement returnStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode testListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR});
        List<Expression> expressionTrees = Collections.emptyList();
        if (testListNode != null) {
            expressionTrees = this.expressionsFromTestListStarExpr(testListNode);
        }
        return new ReturnStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressionTrees, separators);
    }

    public YieldStatement yieldStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new YieldStatementImpl(this.yieldExpression(stmt.getFirstChild(new AstNodeType[]{PythonGrammar.YIELD_EXPR})), separators);
    }

    public YieldExpression yieldExpression(AstNode astNode) {
        Token yieldKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.YIELD}).getToken());
        AstNode nodeContainingExpression = astNode;
        AstNode fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM});
        if (fromKeyword == null) {
            nodeContainingExpression = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR});
        }
        List<Expression> expressionTrees = Collections.emptyList();
        if (nodeContainingExpression != null) {
            expressionTrees = this.expressionsFromTestListStarExpr(nodeContainingExpression);
        }
        return new YieldExpressionImpl(yieldKeyword, fromKeyword == null ? null : PythonTreeMaker.toPyToken(fromKeyword.getToken()), expressionTrees);
    }

    public RaiseStatement raiseStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM});
        List expressions = new ArrayList<AstNode>();
        AstNode fromExpression = null;
        if (fromKeyword != null) {
            expressions.add(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
            fromExpression = astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST});
        } else {
            expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST});
        }
        List<Expression> expressionTrees = expressions.stream().map(this::expression).collect(Collectors.toList());
        return new RaiseStatementImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.RAISE}).getToken()), expressionTrees, fromKeyword == null ? null : PythonTreeMaker.toPyToken(fromKeyword.getToken()), fromExpression == null ? null : this.expression(fromExpression), separators);
    }

    public BreakStatement breakStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new BreakStatementImpl(PythonTreeMaker.toPyToken(astNode.getToken()), separators);
    }

    public ContinueStatement continueStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new ContinueStatementImpl(PythonTreeMaker.toPyToken(astNode.getToken()), separators);
    }

    public ImportStatement importStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode importStmt = astNode.getFirstChild();
        if (importStmt.is(new AstNodeType[]{PythonGrammar.IMPORT_NAME})) {
            return PythonTreeMaker.importName(importStmt, separators);
        }
        return PythonTreeMaker.importFromStatement(importStmt, separators);
    }

    private static ImportName importName(AstNode astNode, Separators separators) {
        Token importKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IMPORT}).getToken());
        List<AliasedName> aliasedNames = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAMES}).getChildren(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAME}).stream().map(PythonTreeMaker::aliasedName).collect(Collectors.toList());
        return new ImportNameImpl(importKeyword, aliasedNames, separators);
    }

    private static ImportFrom importFromStatement(AstNode astNode, Separators separators) {
        Token importKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IMPORT}).getToken());
        Token fromKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM}).getToken());
        List<Token> dottedPrefixForModule = PythonTreeMaker.punctuators(astNode, PythonPunctuator.DOT);
        AstNode moduleNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME});
        DottedName moduleName = null;
        if (moduleNode != null) {
            moduleName = PythonTreeMaker.dottedName(moduleNode);
        }
        AstNode importAsnames = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAMES});
        List aliasedImportNames = null;
        boolean isWildcardImport = true;
        if (importAsnames != null) {
            aliasedImportNames = importAsnames.getChildren(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAME}).stream().map(PythonTreeMaker::aliasedName).collect(Collectors.toList());
            isWildcardImport = false;
        }
        Token wildcard = null;
        if (isWildcardImport) {
            wildcard = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}).getToken());
        }
        return new ImportFromImpl(fromKeyword, dottedPrefixForModule, moduleName, importKeyword, aliasedImportNames, wildcard, separators);
    }

    private static AliasedName aliasedName(AstNode astNode) {
        DottedName dottedName;
        AstNode asKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        if (astNode.is(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAME})) {
            dottedName = PythonTreeMaker.dottedName(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME}));
        } else {
            AstNode importedName = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            dottedName = new DottedNameImpl(Collections.singletonList(PythonTreeMaker.name(importedName)));
        }
        if (asKeyword == null) {
            return new AliasedNameImpl(dottedName);
        }
        return new AliasedNameImpl(PythonTreeMaker.toPyToken(asKeyword.getToken()), dottedName, PythonTreeMaker.name(astNode.getLastChild(new AstNodeType[]{PythonGrammar.NAME})));
    }

    private static DottedName dottedName(AstNode astNode) {
        List<Name> names = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new DottedNameImpl(names);
    }

    public GlobalStatement globalStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        Token globalKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.GLOBAL}).getToken());
        List<Name> variables = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::variable).collect(Collectors.toList());
        return new GlobalStatementImpl(globalKeyword, variables, separators);
    }

    public NonlocalStatement nonlocalStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        Token nonlocalKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.NONLOCAL}).getToken());
        List<Name> variables = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::variable).collect(Collectors.toList());
        return new NonlocalStatementImpl(nonlocalKeyword, variables, separators);
    }

    public IfStatement ifStatement(AstNode astNode) {
        Token ifToken = PythonTreeMaker.toPyToken((com.sonar.sslr.api.Token)astNode.getTokens().get(0));
        AstNode condition = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.NAMED_EXPR_TEST});
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(suite);
        AstNode elseSuite = astNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        ElseClause elseClause = null;
        if (elseSuite.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonKeyword.ELSE})) {
            elseClause = this.elseClause(elseSuite);
        }
        List<IfStatement> elifBranches = astNode.getChildren(new AstNodeType[]{PythonKeyword.ELIF}).stream().map(this::elifStatement).collect(Collectors.toList());
        return new IfStatementImpl(ifToken, this.expression(condition), colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), elifBranches, elseClause);
    }

    private IfStatement elifStatement(AstNode astNode) {
        Token elifToken = PythonTreeMaker.toPyToken(astNode.getToken());
        AstNode condition = astNode.getNextSibling();
        AstNode colon = condition.getNextSibling();
        AstNode suite = colon.getNextSibling();
        StatementList body = this.getStatementListFromSuite(suite);
        Token colonToken = PythonTreeMaker.toPyToken(colon.getToken());
        return new IfStatementImpl(elifToken, this.expression(condition), colonToken, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite));
    }

    private ElseClause elseClause(AstNode astNode) {
        Token elseToken = PythonTreeMaker.toPyToken(astNode.getPreviousSibling().getPreviousSibling().getToken());
        Token colon = PythonTreeMaker.toPyToken(astNode.getPreviousSibling().getToken());
        StatementList body = this.getStatementListFromSuite(astNode);
        return new ElseClauseImpl(elseToken, colon, PythonTreeMaker.suiteNewLine(astNode), PythonTreeMaker.suiteIndent(astNode), body, PythonTreeMaker.suiteDedent(astNode));
    }

    public FunctionDef funcDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        List<Decorator> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR}).stream().map(this::decorator).collect(Collectors.toList());
        }
        Name name = PythonTreeMaker.name(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        ParameterListImpl parameterList = null;
        AstNode typedArgListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (typedArgListNode != null) {
            List<AnyParameter> arguments = typedArgListNode.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF, PythonPunctuator.MUL, PythonPunctuator.DIV}).stream().map(this::parameter).filter(Objects::nonNull).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(typedArgListNode, PythonPunctuator.COMMA);
            parameterList = new ParameterListImpl(arguments, commas);
        }
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(suite);
        AstNode defNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.DEF});
        Token asyncToken = null;
        AstNode defPreviousSibling = defNode.getPreviousSibling();
        if (defPreviousSibling != null && defPreviousSibling.getToken().getValue().equals("async")) {
            asyncToken = PythonTreeMaker.toPyToken(defPreviousSibling.getToken());
        }
        Token lPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken());
        Token rPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
        TypeAnnotationImpl returnType = null;
        AstNode returnTypeNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUN_RETURN_ANNOTATION});
        if (returnTypeNode != null) {
            List children = returnTypeNode.getChildren();
            returnType = new TypeAnnotationImpl(PythonTreeMaker.toPyToken(((AstNode)children.get(0)).getToken()), PythonTreeMaker.toPyToken(((AstNode)children.get(1)).getToken()), this.expression((AstNode)children.get(2)));
        }
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        return new FunctionDefImpl(decorators, asyncToken, PythonTreeMaker.toPyToken(defNode.getToken()), name, lPar, parameterList, rPar, returnType, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), PythonTreeMaker.isMethodDefinition(astNode), DocstringExtractor.extractDocstring(body));
    }

    private Decorator decorator(AstNode astNode) {
        Token atToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.AT}).getToken());
        DottedName dottedName = PythonTreeMaker.dottedName(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME}));
        Token lPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken());
        Token rPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
        ArgList argListTree = this.argList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST}));
        Token newLineToken = astNode.getFirstChild(new AstNodeType[]{PythonTokenType.NEWLINE}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonTokenType.NEWLINE}).getToken());
        return new DecoratorImpl(atToken, dottedName, lPar, argListTree, rPar, newLineToken);
    }

    private static boolean isMethodDefinition(AstNode node) {
        AstNode parent;
        for (parent = node.getParent(); parent != null && !parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF, PythonGrammar.FUNCDEF}); parent = parent.getParent()) {
        }
        return parent != null && parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public ClassDef classDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        List<Decorator> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR}).stream().map(this::decorator).collect(Collectors.toList());
        }
        Name name = PythonTreeMaker.name(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        ArgList args = null;
        AstNode leftPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS});
        if (leftPar != null) {
            args = this.argList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST}));
        }
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(suite);
        Token classToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.CLASS}).getToken());
        AstNode rightPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS});
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        return new ClassDefImpl(decorators, classToken, name, leftPar != null ? PythonTreeMaker.toPyToken(leftPar.getToken()) : null, args, rightPar != null ? PythonTreeMaker.toPyToken(rightPar.getToken()) : null, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), DocstringExtractor.extractDocstring(body));
    }

    private static Name name(AstNode astNode) {
        return new NameImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER}).getToken()), astNode.getParent().is(new AstNodeType[]{PythonGrammar.ATOM}));
    }

    private static Name variable(AstNode astNode) {
        return new NameImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER}).getToken()), true);
    }

    public ForStatement forStatement(AstNode astNode) {
        AstNode forStatementNode = astNode;
        Token asyncToken = null;
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT})) {
            asyncToken = PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
            forStatementNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FOR_STMT});
        }
        Token forKeyword = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.FOR}).getToken());
        Token inKeyword = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken());
        Token colon = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        List<Expression> expressions = this.expressionsFromExprList(forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        List<Expression> testExpressions = this.expressionsFromTest(forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}));
        AstNode firstSuite = forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = forStatementNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        ElseClause elseClause = firstSuite == lastSuite ? null : this.elseClause(lastSuite);
        return new ForStatementImpl(forKeyword, expressions, inKeyword, testExpressions, colon, PythonTreeMaker.suiteNewLine(firstSuite), PythonTreeMaker.suiteIndent(firstSuite), body, PythonTreeMaker.suiteDedent(firstSuite), elseClause, asyncToken);
    }

    public WhileStatementImpl whileStatement(AstNode astNode) {
        Token whileKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.WHILE}).getToken());
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        Expression condition = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.NAMED_EXPR_TEST}));
        AstNode firstSuite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = astNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        ElseClause elseClause = firstSuite == lastSuite ? null : this.elseClause(lastSuite);
        return new WhileStatementImpl(whileKeyword, condition, colon, PythonTreeMaker.suiteNewLine(firstSuite), PythonTreeMaker.suiteIndent(firstSuite), body, PythonTreeMaker.suiteDedent(firstSuite), elseClause);
    }

    public ExpressionStatement expressionStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        List<Expression> expressions = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}).getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
        return new ExpressionStatementImpl(expressions, separators);
    }

    public AssignmentStatement assignment(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        ArrayList<Token> assignTokens = new ArrayList<Token>();
        ArrayList<ExpressionList> lhsExpressions = new ArrayList<ExpressionList>();
        List assignNodes = astNode.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN});
        for (AstNode assignNode : assignNodes) {
            assignTokens.add(PythonTreeMaker.toPyToken(assignNode.getToken()));
            lhsExpressions.add(this.expressionList(assignNode.getPreviousSibling()));
        }
        AstNode assignedValueNode = ((AstNode)assignNodes.get(assignNodes.size() - 1)).getNextSibling();
        Expression assignedValue = assignedValueNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR}) ? this.yieldExpression(assignedValueNode) : this.exprListOrTestList(assignedValueNode);
        return new AssignmentStatementImpl(assignTokens, lhsExpressions, assignedValue, separators);
    }

    public CompoundAssignmentStatement compoundAssignment(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode augAssignNodes = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.AUGASSIGN});
        Expression lhsExpression = this.exprListOrTestList(augAssignNodes.getPreviousSibling());
        AstNode rhsAstNode = augAssignNodes.getNextSibling();
        Expression rhsExpression = rhsAstNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR}) ? this.yieldExpression(rhsAstNode) : this.exprListOrTestList(rhsAstNode);
        return new CompoundAssignmentStatementImpl(lhsExpression, PythonTreeMaker.toPyToken(augAssignNodes.getToken()), rhsExpression, separators);
    }

    private ExpressionList expressionList(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR, PythonGrammar.TESTLIST_COMP})) {
            List<Expression> expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(astNode, PythonPunctuator.COMMA);
            return new ExpressionListImpl(expressions, commas);
        }
        return new ExpressionListImpl(Collections.singletonList(this.expression(astNode)), Collections.emptyList());
    }

    public TryStatement tryStatement(AstNode astNode) {
        Token tryKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.TRY}).getToken());
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        AstNode firstSuite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(firstSuite);
        List<ExceptClause> exceptClauseTrees = astNode.getChildren(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE}).stream().map(except -> {
            AstNode suite = except.getNextSibling().getNextSibling();
            return this.exceptClause((AstNode)except, this.getStatementListFromSuite(suite));
        }).collect(Collectors.toList());
        FinallyClauseImpl finallyClause = null;
        AstNode finallyNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FINALLY});
        if (finallyNode != null) {
            Token finallyColon = PythonTreeMaker.toPyToken(finallyNode.getNextSibling().getToken());
            AstNode finallySuite = finallyNode.getNextSibling().getNextSibling();
            StatementList finallyBody = this.getStatementListFromSuite(finallySuite);
            finallyClause = new FinallyClauseImpl(PythonTreeMaker.toPyToken(finallyNode.getToken()), finallyColon, PythonTreeMaker.suiteNewLine(finallySuite), PythonTreeMaker.suiteIndent(finallySuite), finallyBody, PythonTreeMaker.suiteDedent(finallySuite));
        }
        ElseClause elseClauseTree = null;
        AstNode elseNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (elseNode != null) {
            elseClauseTree = this.elseClause(elseNode.getNextSibling().getNextSibling());
        }
        return new TryStatementImpl(tryKeyword, colon, PythonTreeMaker.suiteNewLine(firstSuite), PythonTreeMaker.suiteIndent(firstSuite), body, PythonTreeMaker.suiteDedent(firstSuite), exceptClauseTrees, finallyClause, elseClauseTree);
    }

    public WithStatement withStatement(AstNode astNode) {
        AstNode withStmtNode = astNode;
        Token asyncKeyword = null;
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT})) {
            withStmtNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.WITH_STMT});
            asyncKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
        }
        List<WithItem> withItems = this.withItems(withStmtNode.getChildren(new AstNodeType[]{PythonGrammar.WITH_ITEM}));
        List<Token> commas = PythonTreeMaker.punctuators(withStmtNode, PythonPunctuator.COMMA);
        AstNode suite = withStmtNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        Token withKeyword = PythonTreeMaker.toPyToken(withStmtNode.getToken());
        Token colon = PythonTreeMaker.toPyToken(suite.getPreviousSibling().getToken());
        StatementList body = this.getStatementListFromSuite(suite);
        return new WithStatementImpl(withKeyword, withItems, commas, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), asyncKeyword);
    }

    private List<WithItem> withItems(List<AstNode> withItems) {
        return withItems.stream().map(this::withItem).collect(Collectors.toList());
    }

    private WithItem withItem(AstNode withItem) {
        AstNode testNode = withItem.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        Expression test = this.expression(testNode);
        AstNode asNode = testNode.getNextSibling();
        Expression expr = null;
        Token as = null;
        if (asNode != null) {
            as = PythonTreeMaker.toPyToken(asNode.getToken());
            expr = this.expression(withItem.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        }
        return new WithStatementImpl.WithItemImpl(test, as, expr);
    }

    private ExceptClause exceptClause(AstNode except, StatementList body) {
        Token colon = PythonTreeMaker.toPyToken(except.getNextSibling().getToken());
        AstNode suite = except.getNextSibling().getNextSibling();
        Token exceptKeyword = PythonTreeMaker.toPyToken(except.getFirstChild(new AstNodeType[]{PythonKeyword.EXCEPT}).getToken());
        Token indent = suite.getFirstChild(new AstNodeType[]{PythonTokenType.INDENT}) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(new AstNodeType[]{PythonTokenType.INDENT}).getToken());
        Token newLine = suite.getFirstChild(new AstNodeType[]{PythonTokenType.INDENT}) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(new AstNodeType[]{PythonTokenType.NEWLINE}).getToken());
        Token dedent = suite.getFirstChild(new AstNodeType[]{PythonTokenType.DEDENT}) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(new AstNodeType[]{PythonTokenType.DEDENT}).getToken());
        AstNode exceptionNode = except.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        if (exceptionNode == null) {
            return new ExceptClauseImpl(exceptKeyword, colon, newLine, indent, body, dedent);
        }
        AstNode asNode = except.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        AstNode commaNode = except.getFirstChild(new AstNodeType[]{PythonPunctuator.COMMA});
        if (asNode != null || commaNode != null) {
            Expression exceptionInstance = this.expression(except.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
            Token asNodeToken = asNode != null ? PythonTreeMaker.toPyToken(asNode.getToken()) : null;
            Token commaNodeToken = commaNode != null ? PythonTreeMaker.toPyToken(commaNode.getToken()) : null;
            return new ExceptClauseImpl(exceptKeyword, colon, newLine, indent, body, dedent, this.expression(exceptionNode), asNodeToken, commaNodeToken, exceptionInstance);
        }
        return new ExceptClauseImpl(exceptKeyword, colon, newLine, indent, body, dedent, this.expression(exceptionNode));
    }

    private List<Expression> expressionsFromTest(AstNode astNode) {
        return astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
    }

    private List<Expression> expressionsFromTestListStarExpr(AstNode astNode) {
        return astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
    }

    private List<Expression> expressionsFromExprList(AstNode firstChild) {
        return firstChild.getChildren(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
    }

    private Expression exprListOrTestList(AstNode exprListOrTestList) {
        List<Expression> expressions = exprListOrTestList.getChildren(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.STAR_EXPR, PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
        List commas = exprListOrTestList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA});
        if (commas.isEmpty()) {
            return (Expression)expressions.get(0);
        }
        List<Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
        return new TupleImpl(null, expressions, commaTokens, null);
    }

    public Expression expression(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LBRACKET})) {
            return this.listLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            return this.parenthesized(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LCURLYBRACE})) {
            return this.dictOrSetLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.BACKTICK})) {
            return this.repr(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonTokenType.STRING})) {
            return this.stringLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getChildren().size() == 1) {
            return this.expression(astNode.getFirstChild());
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TEST}) && astNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.IF})) {
            return this.conditionalExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonTokenType.NUMBER})) {
            return PythonTreeMaker.numericLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR})) {
            return this.yieldExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NAME})) {
            return PythonTreeMaker.name(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NAMED_EXPR_TEST}) && astNode.hasDirectChildren(new AstNodeType[]{PythonPunctuator.WALRUS_OPERATOR})) {
            return this.assignmentExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.TEST, PythonGrammar.TEST_NOCOND})) {
            if (astNode.getChildren().size() == 1) {
                return this.expression(astNode.getFirstChild());
            }
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.A_EXPR, PythonGrammar.M_EXPR, PythonGrammar.SHIFT_EXPR, PythonGrammar.AND_EXPR, PythonGrammar.OR_EXPR, PythonGrammar.XOR_EXPR, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.COMPARISON})) {
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.POWER})) {
            return this.powerExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND})) {
            return this.lambdaExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FACTOR, PythonGrammar.NOT_TEST})) {
            return new UnaryExpressionImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken()), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.STAR_EXPR})) {
            return new UnpackingExpressionImpl(PythonTreeMaker.toPyToken(astNode.getToken()), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(new AstNodeType[]{PythonKeyword.NONE})) {
            return new NoneExpressionImpl(PythonTreeMaker.toPyToken(astNode.getToken()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ELLIPSIS})) {
            return new EllipsisExpressionImpl(PythonTreeMaker.toPyToken(astNode.getTokens()));
        }
        throw new IllegalStateException("Expression " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    private Expression assignmentExpression(AstNode astNode) {
        AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        Expression nameExpression = this.expression(nameNode);
        if (!nameExpression.is(Tree.Kind.NAME)) {
            int line = nameNode.getTokenLine();
            throw new RecognitionException(line, "Parse error at line " + line + ": The left-hand side of an assignment expression must be a name.");
        }
        Name name = (Name)nameExpression;
        AstNode operatorNode = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.WALRUS_OPERATOR});
        Token operatorToken = PythonTreeMaker.toPyToken(operatorNode.getToken());
        Expression expression = this.expression(astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
        return new AssignmentExpressionImpl(name, operatorToken, expression);
    }

    private Expression repr(AstNode astNode) {
        Token openingBacktick = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.BACKTICK}).getToken());
        Token closingBacktick = PythonTreeMaker.toPyToken(astNode.getLastChild(new AstNodeType[]{PythonPunctuator.BACKTICK}).getToken());
        List<Expression> expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
        List<Token> commas = PythonTreeMaker.punctuators(astNode, PythonPunctuator.COMMA);
        ExpressionListImpl expressionListTree = new ExpressionListImpl(expressions, commas);
        return new ReprExpressionImpl(openingBacktick, expressionListTree, closingBacktick);
    }

    private static List<Token> punctuators(AstNode astNode, PythonPunctuator punctuator) {
        return PythonTreeMaker.toPyToken(astNode.getChildren(new AstNodeType[]{punctuator}).stream().map(AstNode::getToken).collect(Collectors.toList()));
    }

    private Expression dictOrSetLiteral(AstNode astNode) {
        Token lCurlyBrace = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LCURLYBRACE}).getToken());
        Token rCurlyBrace = PythonTreeMaker.toPyToken(astNode.getLastChild(new AstNodeType[]{PythonPunctuator.RCURLYBRACE}).getToken());
        AstNode dictOrSetMaker = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DICTORSETMAKER});
        if (dictOrSetMaker == null) {
            return new DictionaryLiteralImpl(lCurlyBrace, Collections.emptyList(), Collections.emptyList(), rCurlyBrace);
        }
        AstNode compForNode = dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compForNode != null) {
            ComprehensionFor compFor = this.compFor(compForNode);
            AstNode colon = dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
            if (colon != null) {
                Expression keyExpression = this.expression(dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
                Expression valueExpression = this.expression(dictOrSetMaker.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
                return new DictCompExpressionImpl(lCurlyBrace, keyExpression, PythonTreeMaker.toPyToken(colon.getToken()), valueExpression, compFor, rCurlyBrace);
            }
            Expression resultExpression = this.expression(dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}));
            return new ComprehensionExpressionImpl(Tree.Kind.SET_COMPREHENSION, lCurlyBrace, resultExpression, compFor, rCurlyBrace);
        }
        List<Token> commas = PythonTreeMaker.punctuators(dictOrSetMaker, PythonPunctuator.COMMA);
        if (dictOrSetMaker.hasDirectChildren(new AstNodeType[]{PythonPunctuator.COLON}) || dictOrSetMaker.hasDirectChildren(new AstNodeType[]{PythonPunctuator.MUL_MUL})) {
            ArrayList<DictionaryLiteralElement> dictionaryLiteralElements = new ArrayList<DictionaryLiteralElement>();
            List children = dictOrSetMaker.getChildren();
            int index = 0;
            while (index < children.size()) {
                AstNode currentChild = (AstNode)children.get(index);
                if (currentChild.is(new AstNodeType[]{PythonPunctuator.MUL_MUL})) {
                    dictionaryLiteralElements.add(new UnpackingExpressionImpl(PythonTreeMaker.toPyToken(currentChild.getToken()), this.expression((AstNode)children.get(index + 1))));
                    index += 3;
                    continue;
                }
                dictionaryLiteralElements.add(new KeyValuePairImpl(this.expression(currentChild), PythonTreeMaker.toPyToken(((AstNode)children.get(index + 1)).getToken()), this.expression((AstNode)children.get(index + 2))));
                index += 4;
            }
            return new DictionaryLiteralImpl(lCurlyBrace, commas, (List<DictionaryLiteralElement>)dictionaryLiteralElements, rCurlyBrace);
        }
        List<Expression> expressions = dictOrSetMaker.getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
        return new SetLiteralImpl(lCurlyBrace, expressions, commas, rCurlyBrace);
    }

    private Expression parenthesized(AstNode atom) {
        Token lPar = PythonTreeMaker.toPyToken(atom.getFirstChild().getToken());
        Token rPar = PythonTreeMaker.toPyToken(atom.getLastChild().getToken());
        AstNode yieldNode = atom.getFirstChild(new AstNodeType[]{PythonGrammar.YIELD_EXPR});
        if (yieldNode != null) {
            return new ParenthesizedExpressionImpl(lPar, this.expression(yieldNode), rPar);
        }
        AstNode testListComp = atom.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_COMP});
        if (testListComp == null) {
            return new TupleImpl(lPar, Collections.emptyList(), Collections.emptyList(), rPar);
        }
        AstNode compFor = testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compFor != null) {
            return new ComprehensionExpressionImpl(Tree.Kind.GENERATOR_EXPR, lPar, this.expression(testListComp.getFirstChild()), this.compFor(compFor), rPar);
        }
        ExpressionList expressionList = this.expressionList(testListComp);
        List commas = testListComp.getChildren(new AstNodeType[]{PythonPunctuator.COMMA});
        if (commas.isEmpty()) {
            Expression expression = expressionList.expressions().get(0);
            return new ParenthesizedExpressionImpl(lPar, expression, rPar);
        }
        List<Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
        return new TupleImpl(lPar, expressionList.expressions(), commaTokens, rPar);
    }

    private ConditionalExpression conditionalExpression(AstNode astNode) {
        List children = astNode.getChildren();
        Expression trueExpression = this.expression((AstNode)children.get(0));
        Token ifToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IF}).getToken());
        Expression condition = this.expression((AstNode)children.get(2));
        Token elseToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE}).getToken());
        Expression falseExpression = this.expression((AstNode)children.get(4));
        return new ConditionalExpressionImpl(trueExpression, ifToken, condition, elseToken, falseExpression);
    }

    private Expression powerExpression(AstNode astNode) {
        AstNode powerOperator;
        Expression expr = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}));
        for (AstNode trailer : astNode.getChildren(new AstNodeType[]{PythonGrammar.TRAILER})) {
            expr = this.withTrailer(expr, trailer);
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{GenericTokenType.IDENTIFIER})) {
            expr = new AwaitExpressionImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken()), expr);
        }
        if ((powerOperator = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL})) != null) {
            expr = new BinaryExpressionImpl(expr, PythonTreeMaker.toPyToken(powerOperator.getToken()), this.expression(powerOperator.getNextSibling()));
        }
        return expr;
    }

    private Expression withTrailer(Expression expr, AstNode trailer) {
        AstNode firstChild = trailer.getFirstChild();
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            AstNode argListNode = trailer.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
            ArgList argumentList = this.argList(argListNode);
            if (argumentList != null) {
                PythonTreeMaker.checkGeneratorExpressionInArgument(argumentList.arguments());
            }
            Token leftPar = PythonTreeMaker.toPyToken(firstChild.getToken());
            Token rightPar = PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
            return new CallExpressionImpl(expr, argumentList, leftPar, rightPar);
        }
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.LBRACKET})) {
            Token leftBracket = PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken());
            Token rightBracket = PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken());
            return this.subscriptionOrSlicing(expr, leftBracket, trailer.getFirstChild(new AstNodeType[]{PythonGrammar.SUBSCRIPTLIST}), rightBracket);
        }
        Name name = PythonTreeMaker.name(trailer.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        return new QualifiedExpressionImpl(name, expr, PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.DOT}).getToken()));
    }

    private Expression subscriptionOrSlicing(Expression expr, Token leftBracket, AstNode subscriptList, Token rightBracket) {
        ArrayList<Tree> slices = new ArrayList<Tree>();
        for (AstNode subscript : subscriptList.getChildren(new AstNodeType[]{PythonGrammar.SUBSCRIPT})) {
            AstNode colon = subscript.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
            if (colon == null) {
                slices.add(this.expression(subscript.getFirstChild(new AstNodeType[]{PythonGrammar.TEST})));
                continue;
            }
            slices.add(this.sliceItem(subscript));
        }
        if (slices.stream().anyMatch(s -> Tree.Kind.SLICE_ITEM.equals((Object)s.getKind()))) {
            List<Token> separators = PythonTreeMaker.punctuators(subscriptList, PythonPunctuator.COMMA);
            SliceListImpl sliceList = new SliceListImpl(slices, separators);
            return new SliceExpressionImpl(expr, leftBracket, sliceList, rightBracket);
        }
        List<Expression> expressions = slices.stream().map(Expression.class::cast).collect(Collectors.toList());
        List<Token> commas = PythonTreeMaker.punctuators(subscriptList, PythonPunctuator.COMMA);
        ExpressionListImpl subscripts = new ExpressionListImpl(expressions, commas);
        return new SubscriptionExpressionImpl(expr, leftBracket, subscripts, rightBracket);
    }

    SliceItem sliceItem(AstNode subscript) {
        AstNode boundSeparator = subscript.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
        Expression lowerBound = this.sliceBound(boundSeparator.getPreviousSibling());
        Expression upperBound = this.sliceBound(boundSeparator.getNextSibling());
        AstNode strideNode = subscript.getFirstChild(new AstNodeType[]{PythonGrammar.SLICEOP});
        Token strideSeparator = strideNode == null ? null : PythonTreeMaker.toPyToken(strideNode.getToken());
        Expression stride = null;
        if (strideNode != null && strideNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.TEST})) {
            stride = this.expression(strideNode.getLastChild());
        }
        return new SliceItemImpl(lowerBound, PythonTreeMaker.toPyToken(boundSeparator.getToken()), upperBound, strideSeparator, stride);
    }

    @CheckForNull
    private Expression sliceBound(@Nullable AstNode node) {
        if (node == null || !node.is(new AstNodeType[]{PythonGrammar.TEST})) {
            return null;
        }
        return this.expression(node);
    }

    private Expression listLiteral(AstNode astNode) {
        ExpressionList elements;
        Token leftBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken());
        Token rightBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken());
        AstNode testListComp = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_COMP});
        if (testListComp != null) {
            AstNode compForNode = testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
            if (compForNode != null) {
                Expression resultExpression = this.expression(testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.STAR_EXPR}));
                return new ComprehensionExpressionImpl(Tree.Kind.LIST_COMPREHENSION, leftBracket, resultExpression, this.compFor(compForNode), rightBracket);
            }
            elements = this.expressionList(testListComp);
        } else {
            elements = new ExpressionListImpl(Collections.emptyList(), Collections.emptyList());
        }
        return new ListLiteralImpl(leftBracket, elements, rightBracket);
    }

    private ComprehensionFor compFor(AstNode compFor) {
        Expression expression = this.exprListOrTestList(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        AstNode forSSLRToken = compFor.getFirstChild(new AstNodeType[]{PythonKeyword.FOR});
        Token asyncToken = null;
        AstNode previousSibling = forSSLRToken.getPreviousSibling();
        if (previousSibling != null) {
            asyncToken = PythonTreeMaker.toPyToken(previousSibling.getToken());
        }
        Token forToken = PythonTreeMaker.toPyToken(forSSLRToken.getToken());
        Token inToken = PythonTreeMaker.toPyToken(compFor.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken());
        Expression iterable = this.exprListOrTestList(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}));
        ComprehensionClause nested = this.compClause(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_ITER}));
        return new ComprehensionForImpl(asyncToken, forToken, expression, inToken, iterable, nested);
    }

    @CheckForNull
    private ComprehensionClause compClause(@Nullable AstNode node) {
        if (node == null) {
            return null;
        }
        AstNode child = node.getFirstChild();
        if (child.is(new AstNodeType[]{PythonGrammar.COMP_FOR})) {
            return this.compFor(child);
        }
        Expression condition = this.expression(child.getFirstChild(new AstNodeType[]{PythonGrammar.TEST_NOCOND}));
        ComprehensionClause nestedClause = this.compClause(child.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_ITER}));
        Token ifToken = PythonTreeMaker.toPyToken(child.getFirstChild(new AstNodeType[]{PythonKeyword.IF}).getToken());
        return new ComprehensionIfImpl(ifToken, condition, nestedClause);
    }

    @CheckForNull
    private ArgList argList(@Nullable AstNode argList) {
        if (argList != null) {
            List<Argument> arguments = argList.getChildren(new AstNodeType[]{PythonGrammar.ARGUMENT}).stream().map(this::argument).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(argList, PythonPunctuator.COMMA);
            return new ArgListImpl(arguments, commas);
        }
        return null;
    }

    private static void checkGeneratorExpressionInArgument(List<Argument> arguments) {
        List nonParenthesizedGeneratorExpressions = arguments.stream().filter(arg -> arg.is(Tree.Kind.REGULAR_ARGUMENT)).map(RegularArgument.class::cast).filter(arg -> arg.expression().is(Tree.Kind.GENERATOR_EXPR) && !arg.expression().firstToken().value().equals("(")).collect(Collectors.toList());
        if (!nonParenthesizedGeneratorExpressions.isEmpty() && arguments.size() > 1) {
            int line = ((Argument)nonParenthesizedGeneratorExpressions.get(0)).firstToken().line();
            throw new RecognitionException(line, "Parse error at line " + line + ": Generator expression must be parenthesized if not sole argument.");
        }
    }

    public Argument argument(AstNode astNode) {
        Token star;
        AstNode compFor = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compFor != null) {
            Expression expression = this.expression(astNode.getFirstChild());
            ComprehensionExpressionImpl comprehension = new ComprehensionExpressionImpl(Tree.Kind.GENERATOR_EXPR, null, expression, this.compFor(compFor), null);
            return new RegularArgumentImpl(comprehension);
        }
        AstNode walrusOperator = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.WALRUS_OPERATOR});
        if (walrusOperator != null) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)this.assignmentExpression(astNode);
            return new RegularArgumentImpl(assignmentExpression);
        }
        AstNode assign = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        Token token = star = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}).getToken());
        if (star == null) {
            star = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL}).getToken());
        }
        Expression arg = this.expression(astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
        if (assign != null) {
            AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}).getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            return new RegularArgumentImpl(PythonTreeMaker.name(nameNode), PythonTreeMaker.toPyToken(assign.getToken()), arg);
        }
        return star == null ? new RegularArgumentImpl(arg) : new UnpackingExpressionImpl(star, arg);
    }

    private Expression binaryExpression(AstNode astNode) {
        List children = astNode.getChildren();
        Expression result = this.expression((AstNode)children.get(0));
        for (int i = 1; i < astNode.getNumberOfChildren(); i += 2) {
            Token notToken;
            AstNode operator = (AstNode)children.get(i);
            Expression rightOperand = this.expression(operator.getNextSibling());
            AstNode not = operator.getFirstChild(new AstNodeType[]{PythonKeyword.NOT});
            Token token = notToken = not == null ? null : PythonTreeMaker.toPyToken(not.getToken());
            result = PythonKeyword.IN.equals(operator.getLastToken().getType()) ? new InExpressionImpl(result, notToken, PythonTreeMaker.toPyToken(operator.getLastToken()), rightOperand) : (PythonKeyword.IS.equals(operator.getToken().getType()) ? new IsExpressionImpl(result, PythonTreeMaker.toPyToken(operator.getToken()), notToken, rightOperand) : new BinaryExpressionImpl(result, PythonTreeMaker.toPyToken(operator.getToken()), rightOperand));
        }
        return result;
    }

    public LambdaExpression lambdaExpression(AstNode astNode) {
        Token lambdaKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.LAMBDA}).getToken());
        Token colonToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        Expression body = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.TEST_NOCOND}));
        AstNode varArgsListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.VARARGSLIST});
        ParameterListImpl argListTree = null;
        if (varArgsListNode != null) {
            List<AnyParameter> parameters = varArgsListNode.getChildren(new AstNodeType[]{PythonGrammar.FPDEF, PythonGrammar.NAME, PythonPunctuator.MUL, PythonPunctuator.DIV}).stream().map(this::parameter).filter(Objects::nonNull).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(varArgsListNode, PythonPunctuator.COMMA);
            argListTree = new ParameterListImpl(parameters, commas);
        }
        return new LambdaExpressionImpl(lambdaKeyword, colonToken, body, argListTree);
    }

    private AnyParameter parameter(AstNode parameter) {
        if (parameter.is(new AstNodeType[]{PythonPunctuator.DIV})) {
            return new ParameterImpl(PythonTreeMaker.toPyToken(parameter.getToken()));
        }
        if (parameter.is(new AstNodeType[]{PythonPunctuator.MUL})) {
            if (parameter.getNextSibling() == null || parameter.getNextSibling().is(new AstNodeType[]{PythonPunctuator.COMMA})) {
                return new ParameterImpl(PythonTreeMaker.toPyToken(parameter.getToken()));
            }
            return null;
        }
        AstNode prevSibling = parameter.getPreviousSibling();
        if (parameter.is(new AstNodeType[]{PythonGrammar.NAME})) {
            return new ParameterImpl(PythonTreeMaker.toPyToken(prevSibling.getToken()), PythonTreeMaker.name(parameter), null, null, null);
        }
        AstNode paramList = parameter.getFirstChild(new AstNodeType[]{PythonGrammar.TFPLIST, PythonGrammar.FPLIST});
        if (paramList != null) {
            List<AnyParameter> params = paramList.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF, PythonGrammar.FPDEF}).stream().map(this::parameter).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(paramList, PythonPunctuator.COMMA);
            return new TupleParameterImpl(PythonTreeMaker.toPyToken(parameter.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken()), params, commas, PythonTreeMaker.toPyToken(parameter.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken()));
        }
        Token starOrStarStar = null;
        if (prevSibling != null && prevSibling.is(new AstNodeType[]{PythonPunctuator.MUL, PythonPunctuator.MUL_MUL})) {
            starOrStarStar = PythonTreeMaker.toPyToken(prevSibling.getToken());
        }
        Name name = PythonTreeMaker.name(parameter.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        AstNode nextSibling = parameter.getNextSibling();
        Token assignToken = null;
        Expression defaultValue = null;
        if (nextSibling != null && nextSibling.is(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
            assignToken = PythonTreeMaker.toPyToken(nextSibling.getToken());
            defaultValue = this.expression(nextSibling.getNextSibling());
        }
        TypeAnnotationImpl typeAnnotation = null;
        AstNode testNode = parameter.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        if (testNode != null) {
            Token colonToken = PythonTreeMaker.toPyToken(parameter.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
            typeAnnotation = new TypeAnnotationImpl(colonToken, this.expression(testNode), Tree.Kind.PARAMETER_TYPE_ANNOTATION);
        }
        return new ParameterImpl(starOrStarStar, name, typeAnnotation, assignToken, defaultValue);
    }

    private static Expression numericLiteral(AstNode astNode) {
        return new NumericLiteralImpl(PythonTreeMaker.toPyToken(astNode.getToken()));
    }

    private Expression stringLiteral(AstNode astNode) {
        ArrayList<StringElement> elements = new ArrayList<StringElement>();
        for (AstNode elementNode : astNode.getChildren(new AstNodeType[]{PythonTokenType.STRING})) {
            com.sonar.sslr.api.Token token = elementNode.getToken();
            StringElementImpl element = new StringElementImpl(PythonTreeMaker.toPyToken(token));
            if (element.isInterpolated()) {
                F_STRING_PARSER.fStringExpressions(token).forEach(expressionNode -> element.addFormattedExpression(this.formattedExpression((AstNode)expressionNode)));
            }
            elements.add(element);
        }
        return new StringLiteralImpl(elements);
    }

    private FormatSpecifier formatSpecifier(AstNode expressionNode) {
        AstNode formatSpecifierNode = expressionNode.getFirstChild(new AstNodeType[]{PythonGrammar.FORMAT_SPECIFIER});
        if (formatSpecifierNode == null) {
            return null;
        }
        Token columnToken = PythonTreeMaker.toPyToken(formatSpecifierNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        List<FormattedExpression> nestedExpressions = formatSpecifierNode.getChildren(new AstNodeType[]{PythonGrammar.FORMATTED_EXPR}).stream().map(this::formattedExpression).collect(Collectors.toList());
        return new FormatSpecifierImpl(columnToken, nestedExpressions);
    }

    private FormattedExpression formattedExpression(AstNode expressionNode) {
        Expression exp = this.expression(expressionNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        AstNode equalNode = expressionNode.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        Token equalToken = equalNode == null ? null : PythonTreeMaker.toPyToken(equalNode.getToken());
        FormatSpecifier formatSpecifier = this.formatSpecifier(expressionNode);
        return new FormattedExpressionImpl(exp, equalToken, formatSpecifier);
    }

    private static Token suiteIndent(AstNode suite) {
        return suite.getFirstChild(new AstNodeType[]{PythonTokenType.INDENT}) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(new AstNodeType[]{PythonTokenType.INDENT}).getToken());
    }

    private static Token suiteNewLine(AstNode suite) {
        return suite.getFirstChild(new AstNodeType[]{PythonTokenType.INDENT}) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(new AstNodeType[]{PythonTokenType.NEWLINE}).getToken());
    }

    private static Token suiteDedent(AstNode suite) {
        return suite.getFirstChild(new AstNodeType[]{PythonTokenType.DEDENT}) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(new AstNodeType[]{PythonTokenType.DEDENT}).getToken());
    }
}

