/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.types.HasTypeDependencies;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;

public class TypeInference
extends BaseTreeVisitor {
    private static final InferredType TYPE_OF_SUPER = InferredTypes.runtimeType(TypeShed.typeShedClass("super"));
    private final FunctionLike functionDef;
    private final Map<Symbol, Set<Assignment>> assignmentsByLhs = new HashMap<Symbol, Set<Assignment>>();
    private final Map<QualifiedExpression, MemberAccess> memberAccessesByQualifiedExpr = new HashMap<QualifiedExpression, MemberAccess>();

    public static void inferTypes(FileInput fileInput) {
        fileInput.accept(new BaseTreeVisitor(){

            @Override
            public void visitFunctionDef(FunctionDef funcDef) {
                super.visitFunctionDef(funcDef);
                TypeInference.inferTypesAndMemberAccessSymbols(funcDef);
            }
        });
        fileInput.accept(new BaseTreeVisitor(){

            @Override
            public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
                super.visitQualifiedExpression(qualifiedExpression);
                Name name = qualifiedExpression.name();
                InferredType type = qualifiedExpression.qualifier().type();
                if (!type.equals(TYPE_OF_SUPER)) {
                    Optional<Symbol> resolvedMember = type.resolveMember(name.name());
                    resolvedMember.ifPresent(((NameImpl)name)::setSymbol);
                }
            }
        });
    }

    private static void inferTypesAndMemberAccessSymbols(FunctionLike functionDef) {
        TypeInference visitor = new TypeInference(functionDef);
        functionDef.accept(visitor);
        visitor.processPropagations();
    }

    private TypeInference(FunctionLike functionDef) {
        this.functionDef = functionDef;
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        super.visitAssignmentStatement(assignmentStatement);
        if (assignmentStatement.lhsExpressions().stream().anyMatch(expressionList -> !expressionList.commas().isEmpty())) {
            return;
        }
        List lhsExpressions = assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).collect(Collectors.toList());
        if (lhsExpressions.size() != 1) {
            return;
        }
        Expression lhsExpression = (Expression)lhsExpressions.get(0);
        if (!lhsExpression.is(Tree.Kind.NAME)) {
            return;
        }
        Name lhs = (Name)lhsExpression;
        SymbolImpl symbol = (SymbolImpl)lhs.symbol();
        if (symbol == null) {
            return;
        }
        Expression rhs = assignmentStatement.assignedValue();
        Assignment assignment = new Assignment(symbol, lhs, rhs);
        this.assignmentsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(assignment);
    }

    @Override
    public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
        super.visitQualifiedExpression(qualifiedExpression);
        this.memberAccessesByQualifiedExpr.put(qualifiedExpression, new MemberAccess(qualifiedExpression));
    }

    private void processPropagations() {
        HashSet<Symbol> trackedVars = new HashSet<Symbol>();
        Set assignedNames = this.assignmentsByLhs.values().stream().flatMap(Collection::stream).map(a -> ((Assignment)a).lhsName).collect(Collectors.toSet());
        for (Symbol variable : this.functionDef.localVariables()) {
            boolean hasMissingBindingUsage = variable.usages().stream().filter(Usage::isBindingUsage).anyMatch(u -> !assignedNames.contains(u.tree()));
            if (hasMissingBindingUsage) continue;
            trackedVars.add(variable);
        }
        HashSet<Propagation> propagations = new HashSet<Propagation>();
        HashSet<Symbol> initializedVars = new HashSet<Symbol>();
        for (MemberAccess memberAccess : this.memberAccessesByQualifiedExpr.values()) {
            memberAccess.computeDependencies(memberAccess.qualifiedExpression.qualifier(), trackedVars);
            propagations.add(memberAccess);
        }
        this.assignmentsByLhs.forEach((lhs, as) -> {
            if (trackedVars.contains(lhs)) {
                as.forEach(a -> a.computeDependencies(((Assignment)a).rhs, trackedVars));
                propagations.addAll((Collection<Propagation>)as);
            }
        });
        this.applyPropagations(propagations, initializedVars, true);
        this.applyPropagations(propagations, initializedVars, false);
    }

    private void applyPropagations(Set<Propagation> propagations, Set<Symbol> initializedVars, boolean checkDependenciesReadiness) {
        HashSet<Propagation> workSet = new HashSet<Propagation>(propagations);
        while (!workSet.isEmpty()) {
            boolean learnt;
            Iterator iterator = workSet.iterator();
            Propagation propagation = (Propagation)iterator.next();
            iterator.remove();
            if (checkDependenciesReadiness && !propagation.areDependenciesReady(initializedVars) || !(learnt = propagation.propagate(initializedVars))) continue;
            workSet.addAll(propagation.dependents());
        }
    }

    private class MemberAccess
    extends Propagation {
        private final QualifiedExpression qualifiedExpression;
        private final Symbol symbolWithoutTypeInference;

        private MemberAccess(QualifiedExpression qualifiedExpression) {
            this.qualifiedExpression = qualifiedExpression;
            this.symbolWithoutTypeInference = qualifiedExpression.symbol();
        }

        @Override
        public boolean propagate(Set<Symbol> initializedVars) {
            NameImpl name = (NameImpl)this.qualifiedExpression.name();
            InferredType type = this.qualifiedExpression.qualifier().type();
            if (!type.equals(TYPE_OF_SUPER)) {
                Optional<Symbol> resolvedMember = type.resolveMember(name.name());
                Symbol previous = name.symbol();
                if (resolvedMember.isPresent()) {
                    name.setSymbol(resolvedMember.get());
                    return previous != resolvedMember.get();
                }
                if (name.symbol() != this.symbolWithoutTypeInference) {
                    name.setSymbol(this.symbolWithoutTypeInference);
                    return true;
                }
            }
            return false;
        }
    }

    private class Assignment
    extends Propagation {
        private final SymbolImpl lhs;
        private final Name lhsName;
        private final Expression rhs;

        private Assignment(SymbolImpl lhs, Name lhsName, Expression rhs) {
            this.lhs = lhs;
            this.lhsName = lhsName;
            this.rhs = rhs;
        }

        @Override
        public boolean propagate(Set<Symbol> initializedVars) {
            InferredType rhsType = this.rhs.type();
            if (initializedVars.add(this.lhs)) {
                this.lhs.setInferredType(rhsType);
                return true;
            }
            InferredType currentType = this.lhs.inferredType();
            InferredType newType = InferredTypes.or(rhsType, currentType);
            this.lhs.setInferredType(newType);
            return !newType.equals(currentType);
        }
    }

    private abstract class Propagation {
        private final Set<Symbol> variableDependencies = new HashSet<Symbol>();
        private final Set<QualifiedExpression> memberAccessDependencies = new HashSet<QualifiedExpression>();
        private final Set<Propagation> dependents = new HashSet<Propagation>();

        private Propagation() {
        }

        abstract boolean propagate(Set<Symbol> var1);

        void computeDependencies(Expression expression, Set<Symbol> trackedVars) {
            ArrayDeque<Expression> workList = new ArrayDeque<Expression>();
            workList.push(expression);
            while (!workList.isEmpty()) {
                Expression e = (Expression)workList.pop();
                if (e.is(Tree.Kind.NAME)) {
                    Name name = (Name)e;
                    Symbol symbol = name.symbol();
                    if (symbol == null || !trackedVars.contains(symbol)) continue;
                    this.variableDependencies.add(symbol);
                    ((Set)TypeInference.this.assignmentsByLhs.get(symbol)).forEach(a -> a.dependents().add(this));
                    continue;
                }
                if (e.is(Tree.Kind.QUALIFIED_EXPR)) {
                    QualifiedExpression qualifiedExpression = (QualifiedExpression)e;
                    this.memberAccessDependencies.add(qualifiedExpression);
                    ((MemberAccess)TypeInference.this.memberAccessesByQualifiedExpr.get(qualifiedExpression)).dependents().add(this);
                    continue;
                }
                if (!(e instanceof HasTypeDependencies)) continue;
                workList.addAll(((HasTypeDependencies)((Object)e)).typeDependencies());
            }
        }

        private boolean areDependenciesReady(Set<Symbol> initializedVars) {
            return initializedVars.containsAll(this.variableDependencies) && this.memberAccessDependencies.stream().map(QualifiedExpression::symbol).allMatch(s -> s != null && s.kind() == Symbol.Kind.FUNCTION);
        }

        Set<Propagation> dependents() {
            return this.dependents;
        }
    }
}

