/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;

public interface PythonCheck {
    public void scanFile(PythonVisitorContext var1);

    public static class PreciseIssue {
        private final PythonCheck check;
        private final IssueLocation primaryLocation;
        private Integer cost;
        private final List<IssueLocation> secondaryLocations;

        public PreciseIssue(PythonCheck check, IssueLocation primaryLocation) {
            this.check = check;
            this.primaryLocation = primaryLocation;
            this.secondaryLocations = new ArrayList<IssueLocation>();
        }

        @Nullable
        public Integer cost() {
            return this.cost;
        }

        public PreciseIssue withCost(int cost) {
            this.cost = cost;
            return this;
        }

        public IssueLocation primaryLocation() {
            return this.primaryLocation;
        }

        public PreciseIssue secondary(Tree tree, @Nullable String message) {
            this.secondaryLocations.add(IssueLocation.preciseLocation(tree, message));
            return this;
        }

        public PreciseIssue secondary(Token token, @Nullable String message) {
            this.secondaryLocations.add(IssueLocation.preciseLocation(token, message));
            return this;
        }

        public PreciseIssue secondary(IssueLocation issueLocation) {
            this.secondaryLocations.add(issueLocation);
            return this;
        }

        public List<IssueLocation> secondaryLocations() {
            return this.secondaryLocations;
        }

        public PythonCheck check() {
            return this.check;
        }
    }
}

