/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class BreakStatementImpl
extends SimpleStatement
implements BreakStatement {
    private final Token breakKeyword;
    private final Separators separators;

    public BreakStatementImpl(Token breakKeyword, Separators separators) {
        this.breakKeyword = breakKeyword;
        this.separators = separators;
    }

    @Override
    public Token breakKeyword() {
        return this.breakKeyword;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BREAK_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBreakStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.breakKeyword), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

