/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class StringElementImpl
extends PyTree
implements StringElement {
    private final String value;
    private final Token token;
    private List<Expression> interpolatedExpressions = new ArrayList<Expression>();

    public StringElementImpl(Token token) {
        this.value = token.value();
        this.token = token;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_ELEMENT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStringElement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.singletonList(this.token);
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String trimmedQuotesValue() {
        String trimmed = StringElementImpl.removePrefix(this.value);
        int startIndex = 1;
        if (StringElementImpl.isTripleQuote(trimmed)) {
            startIndex = 3;
        }
        return trimmed.substring(startIndex, trimmed.length() - startIndex);
    }

    @Override
    public String prefix() {
        return this.value.substring(0, this.value.length() - StringElementImpl.removePrefix(this.value).length());
    }

    @Override
    public boolean isTripleQuoted() {
        return StringElementImpl.isTripleQuote(StringElementImpl.removePrefix(this.value));
    }

    @Override
    public boolean isInterpolated() {
        return this.prefix().equalsIgnoreCase("F");
    }

    @Override
    public List<Expression> interpolatedExpressions() {
        return this.interpolatedExpressions;
    }

    void addInterpolatedExpression(Expression expression) {
        this.interpolatedExpressions.add(expression);
    }

    private static boolean isTripleQuote(String trimmed) {
        if (trimmed.length() >= 6) {
            char startChar = trimmed.charAt(0);
            return startChar == trimmed.charAt(1) && startChar == trimmed.charAt(2);
        }
        return false;
    }

    private static String removePrefix(String value) {
        if (StringElementImpl.isCharQuote(value.charAt(0))) {
            return value;
        }
        return StringElementImpl.removePrefix(value.substring(1));
    }

    private static boolean isCharQuote(char character) {
        return character == '\'' || character == '\"';
    }
}

