/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.io.File;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;

public class SymbolUtils {
    private SymbolUtils() {
    }

    public static String fullyQualifiedModuleName(String packageName, String fileName) {
        String moduleName;
        int extensionIndex = fileName.lastIndexOf(46);
        String string = moduleName = extensionIndex > 0 ? fileName.substring(0, extensionIndex) : fileName;
        if (moduleName.equals("__init__")) {
            return packageName;
        }
        return packageName.isEmpty() ? moduleName : packageName + "." + moduleName;
    }

    public static Set<Symbol> globalSymbols(FileInput fileInput, String fullyQualifiedModuleName, PythonFile pythonFile) {
        GlobalSymbolsBindingVisitor globalSymbolsBindingVisitor = new GlobalSymbolsBindingVisitor(fullyQualifiedModuleName, pythonFile);
        fileInput.accept(globalSymbolsBindingVisitor);
        BuiltinSymbols.all().forEach(b -> globalSymbolsBindingVisitor.symbolsByName.putIfAbsent(b, new SymbolImpl((String)b, (String)b)));
        GlobalSymbolsReadVisitor globalSymbolsReadVisitor = new GlobalSymbolsReadVisitor(globalSymbolsBindingVisitor.symbolsByName);
        fileInput.accept(globalSymbolsReadVisitor);
        return globalSymbolsReadVisitor.symbolsByName.values().stream().filter(v -> !BuiltinSymbols.all().contains(v.fullyQualifiedName())).collect(Collectors.toSet());
    }

    static void resolveTypeHierarchy(ClassDef classDef, @Nullable Symbol symbol) {
        SymbolUtils.resolveTypeHierarchy(classDef, symbol, Collections.emptyMap());
    }

    private static void resolveTypeHierarchy(ClassDef classDef, @Nullable Symbol symbol, Map<String, Symbol> symbolsByName) {
        if (symbol == null || !Symbol.Kind.CLASS.equals((Object)symbol.kind())) {
            return;
        }
        ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
        ArgList argList = classDef.args();
        classSymbol.setHasUnresolvedTypeHierarchy(false);
        if (argList == null) {
            return;
        }
        for (Argument argument : argList.arguments()) {
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT) || !(((RegularArgument)argument).expression() instanceof HasSymbol)) {
                classSymbol.setHasUnresolvedTypeHierarchy(true);
                return;
            }
            Expression expression = ((RegularArgument)argument).expression();
            Symbol argumentSymbol = ((HasSymbol)((Object)expression)).symbol();
            if (argumentSymbol == null && expression.is(Tree.Kind.NAME)) {
                argumentSymbol = symbolsByName.get(((Name)expression).name());
            }
            if (argumentSymbol == null) {
                classSymbol.setHasUnresolvedTypeHierarchy(true);
                return;
            }
            if (BuiltinSymbols.all().contains(argumentSymbol.fullyQualifiedName())) {
                classSymbol.addSuperClass(argumentSymbol);
                continue;
            }
            if (!Symbol.Kind.CLASS.equals((Object)argumentSymbol.kind())) {
                classSymbol.setHasUnresolvedTypeHierarchy(true);
                return;
            }
            classSymbol.addSuperClass(argumentSymbol);
        }
    }

    static List<Expression> assignmentsLhs(AssignmentStatement assignmentStatement) {
        return assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).flatMap(SymbolUtils::flattenTuples).collect(Collectors.toList());
    }

    private static Stream<Expression> flattenTuples(Expression expression) {
        if (expression.is(Tree.Kind.TUPLE)) {
            Tuple tuple = (Tuple)expression;
            return tuple.elements().stream().flatMap(SymbolUtils::flattenTuples);
        }
        return Stream.of(expression);
    }

    static List<Name> boundNamesFromExpression(@CheckForNull Tree tree) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (tree == null) {
            return names;
        }
        if (tree.is(Tree.Kind.NAME)) {
            names.add((Name)tree);
        } else if (tree.is(Tree.Kind.TUPLE)) {
            ((Tuple)tree).elements().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.LIST_LITERAL)) {
            ((ListLiteral)tree).elements().expressions().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.PARENTHESIZED)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((ParenthesizedExpression)tree).expression()));
        } else if (tree.is(Tree.Kind.UNPACKING_EXPR)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((UnpackingExpression)tree).expression()));
        }
        return names;
    }

    public static String pythonPackageName(File file, File projectBaseDir) {
        File initFile;
        File currentDirectory = file.getParentFile();
        ArrayDeque<String> packages = new ArrayDeque<String>();
        while (!currentDirectory.getAbsolutePath().equals(projectBaseDir.getAbsolutePath()) && (initFile = new File(currentDirectory, "__init__.py")).exists()) {
            packages.push(currentDirectory.getName());
            currentDirectory = currentDirectory.getParentFile();
        }
        return String.join((CharSequence)".", packages);
    }

    @CheckForNull
    static Path pathOf(PythonFile pythonFile) {
        try {
            URI uri = pythonFile.uri();
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return Paths.get(uri);
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private static class GlobalSymbolsReadVisitor
    extends BaseTreeVisitor {
        private Map<String, Symbol> symbolsByName;

        GlobalSymbolsReadVisitor(Map<String, Symbol> symbolsByName) {
            this.symbolsByName = symbolsByName;
        }

        @Override
        public void visitClassDef(ClassDef classDef) {
            SymbolUtils.resolveTypeHierarchy(classDef, this.symbolsByName.get(classDef.name().name()), this.symbolsByName);
        }
    }

    private static class GlobalSymbolsBindingVisitor
    extends BaseTreeVisitor {
        private Map<String, Symbol> symbolsByName = new HashMap<String, Symbol>();
        private String fullyQualifiedModuleName;
        private final PythonFile pythonFile;

        GlobalSymbolsBindingVisitor(String fullyQualifiedModuleName, PythonFile pythonFile) {
            this.fullyQualifiedModuleName = fullyQualifiedModuleName;
            this.pythonFile = pythonFile;
        }

        private Symbol symbol(Tree tree) {
            if (tree.is(Tree.Kind.FUNCDEF)) {
                FunctionDef functionDef = (FunctionDef)tree;
                return new FunctionSymbolImpl(functionDef, this.fullyQualifiedModuleName + "." + functionDef.name().name(), this.pythonFile);
            }
            if (tree.is(Tree.Kind.CLASSDEF)) {
                String className = ((ClassDef)tree).name().name();
                return new ClassSymbolImpl(className, this.fullyQualifiedModuleName + "." + className);
            }
            Name name = (Name)tree;
            return new SymbolImpl(name.name(), this.fullyQualifiedModuleName + "." + name.name());
        }

        private void addSymbol(Tree tree, String name) {
            SymbolImpl symbol = (SymbolImpl)this.symbolsByName.get(name);
            if (symbol != null) {
                symbol.setKind(Symbol.Kind.OTHER);
            } else {
                this.symbolsByName.put(name, this.symbol(tree));
            }
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            this.addSymbol(functionDef, functionDef.name().name());
        }

        @Override
        public void visitClassDef(ClassDef classDef) {
            this.addSymbol(classDef, classDef.name().name());
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
            SymbolUtils.assignmentsLhs(assignmentStatement).stream().map(SymbolUtils::boundNamesFromExpression).flatMap(Collection::stream).forEach(name -> this.addSymbol((Tree)name, name.name()));
            super.visitAssignmentStatement(assignmentStatement);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                Name variable = (Name)annotatedAssignment.variable();
                this.addSymbol(variable, variable.name());
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }
    }
}

