/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class RegularArgumentImpl
extends PyTree
implements RegularArgument {
    private final Name keywordArgument;
    private final Expression expression;
    private final Token equalToken;

    public RegularArgumentImpl(Name keywordArgument, Token equalToken, Expression expression) {
        this.keywordArgument = keywordArgument;
        this.equalToken = equalToken;
        this.expression = expression;
    }

    public RegularArgumentImpl(Expression expression) {
        this.keywordArgument = null;
        this.equalToken = null;
        this.expression = expression;
    }

    @Override
    @CheckForNull
    public Name keywordArgument() {
        return this.keywordArgument;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitRegularArgument(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.REGULAR_ARGUMENT;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.keywordArgument, this.equalToken, this.expression).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

