/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.tree.PyTree;

public class UnaryExpressionImpl
extends PyTree
implements UnaryExpression {
    private static final Map<String, Tree.Kind> KINDS_BY_OPERATOR = UnaryExpressionImpl.kindsByOperator();
    private final Tree.Kind kind;
    private final Token operator;
    private final Expression expression;

    private static Map<String, Tree.Kind> kindsByOperator() {
        HashMap<String, Tree.Kind> map = new HashMap<String, Tree.Kind>();
        map.put("+", Tree.Kind.UNARY_PLUS);
        map.put("-", Tree.Kind.UNARY_MINUS);
        map.put("~", Tree.Kind.BITWISE_COMPLEMENT);
        map.put("not", Tree.Kind.NOT);
        return map;
    }

    public UnaryExpressionImpl(Token operator, Expression expression) {
        this.kind = KINDS_BY_OPERATOR.get(operator.value());
        this.operator = operator;
        this.expression = expression;
    }

    @Override
    public Token operator() {
        return this.operator;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.operator, this.expression).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }
}

