/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.SimpleStatement;

public class DecoratorImpl
extends SimpleStatement
implements Decorator {
    private final Token atToken;
    private final DottedName dottedName;
    private final Token lPar;
    private final ArgList argListTree;
    private final Token rPar;
    private final Token newLineToken;

    public DecoratorImpl(Token atToken, DottedName dottedName, @Nullable Token lPar, @Nullable ArgList argListTree, @Nullable Token rPar, @Nullable Token newLineToken) {
        this.atToken = atToken;
        this.dottedName = dottedName;
        this.lPar = lPar != null ? lPar : null;
        this.argListTree = argListTree;
        this.rPar = rPar != null ? rPar : null;
        this.newLineToken = newLineToken != null ? newLineToken : null;
    }

    @Override
    public Token atToken() {
        return this.atToken;
    }

    @Override
    public DottedName name() {
        return this.dottedName;
    }

    @Override
    @CheckForNull
    public Token leftPar() {
        return this.lPar;
    }

    @Override
    @CheckForNull
    public ArgList arguments() {
        return this.argListTree;
    }

    @Override
    @CheckForNull
    public Token rightPar() {
        return this.rPar;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDecorator(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.atToken, this.dottedName, this.lPar, this.argListTree, this.rPar, this.newLineToken).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DECORATOR;
    }
}

