/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;

public class ClassSymbolImpl
extends SymbolImpl
implements ClassSymbol {
    private List<Symbol> superClasses = new ArrayList<Symbol>();
    private boolean hasUnresolvedTypeHierarchy = false;
    private final Set<Symbol> members = new HashSet<Symbol>();

    public ClassSymbolImpl(String name, @Nullable String fullyQualifiedName) {
        super(name, fullyQualifiedName);
        this.setKind(Symbol.Kind.CLASS);
    }

    @Override
    ClassSymbolImpl copyWithoutUsages() {
        ClassSymbolImpl copiedClassSymbol = new ClassSymbolImpl(this.name(), this.fullyQualifiedName());
        for (Symbol superClass : this.superClasses()) {
            if (superClass.kind() == Symbol.Kind.CLASS) {
                copiedClassSymbol.superClasses.add(((ClassSymbolImpl)superClass).copyWithoutUsages());
                continue;
            }
            copiedClassSymbol.superClasses.add(new SymbolImpl(superClass.name(), superClass.fullyQualifiedName()));
        }
        copiedClassSymbol.addMembers(this.members.stream().map(m -> ((SymbolImpl)m).copyWithoutUsages()).collect(Collectors.toList()));
        copiedClassSymbol.setHasUnresolvedTypeHierarchy(this.hasUnresolvedTypeHierarchy);
        return copiedClassSymbol;
    }

    @Override
    public List<Symbol> superClasses() {
        return Collections.unmodifiableList(this.superClasses);
    }

    public void addSuperClass(Symbol symbol) {
        this.superClasses.add(symbol);
    }

    @Override
    public boolean hasUnresolvedTypeHierarchy() {
        return this.hasUnresolvedTypeHierarchy;
    }

    @Override
    public Set<Symbol> declaredMembers() {
        return this.members;
    }

    public void setHasUnresolvedTypeHierarchy(boolean hasUnresolvedTypeHierarchy) {
        this.hasUnresolvedTypeHierarchy = hasUnresolvedTypeHierarchy;
    }

    public void addMembers(Collection<Symbol> members) {
        this.members.addAll(members);
        members.stream().filter(m -> m.kind() == Symbol.Kind.FUNCTION).forEach(m -> ((FunctionSymbolImpl)m).setOwner(this));
    }
}

