/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.TokenLocation;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.Type;
import org.sonar.python.types.InferredTypes;

public class FunctionSymbolImpl
extends SymbolImpl
implements FunctionSymbol {
    private final List<FunctionSymbol.Parameter> parameters = new ArrayList<FunctionSymbol.Parameter>();
    private final LocationInFile functionDefinitionLocation;
    private boolean hasVariadicParameter = false;
    private final boolean isInstanceMethod;
    private final boolean hasDecorators;
    private Type returnType = null;
    private InferredType declaredReturnType = InferredTypes.anyType();
    private boolean isStub = false;
    private Symbol owner;

    FunctionSymbolImpl(FunctionDef functionDef, @Nullable String fullyQualifiedName, PythonFile pythonFile) {
        super(functionDef.name().name(), fullyQualifiedName);
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = FunctionSymbolImpl.isInstanceMethod(functionDef);
        this.hasDecorators = !functionDef.decorators().isEmpty();
        ParameterList parametersList = functionDef.parameters();
        if (parametersList != null) {
            this.createParameterNames(parametersList.all());
        }
        if (SymbolUtils.isTypeShedFile(pythonFile)) {
            this.functionDefinitionLocation = null;
        } else {
            TokenLocation functionName = new TokenLocation(functionDef.name().firstToken());
            Path path = SymbolUtils.pathOf(pythonFile);
            String fileId = path != null ? path.toString() : pythonFile.toString();
            this.functionDefinitionLocation = new LocationInFile(fileId, functionName.startLine(), functionName.startLineOffset(), functionName.endLine(), functionName.endLineOffset());
        }
    }

    FunctionSymbolImpl(String name, FunctionSymbol functionSymbol) {
        super(name, functionSymbol.fullyQualifiedName());
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = functionSymbol.isInstanceMethod();
        this.hasDecorators = functionSymbol.hasDecorators();
        this.hasVariadicParameter = functionSymbol.hasVariadicParameter();
        this.parameters.addAll(functionSymbol.parameters());
        this.functionDefinitionLocation = functionSymbol.definitionLocation();
        this.returnType = ((FunctionSymbolImpl)functionSymbol).returnType();
        this.declaredReturnType = ((FunctionSymbolImpl)functionSymbol).declaredReturnType();
        this.isStub = functionSymbol.isStub();
    }

    public FunctionSymbolImpl(String name, @Nullable String fullyQualifiedName, boolean hasVariadicParameter, boolean isInstanceMethod, boolean hasDecorators, List<FunctionSymbol.Parameter> parameters, @Nullable Type returnType) {
        super(name, fullyQualifiedName);
        this.setKind(Symbol.Kind.FUNCTION);
        this.hasVariadicParameter = hasVariadicParameter;
        this.isInstanceMethod = isInstanceMethod;
        this.hasDecorators = hasDecorators;
        this.parameters.addAll(parameters);
        this.returnType = returnType;
        this.functionDefinitionLocation = null;
        this.isStub = true;
    }

    @Override
    FunctionSymbolImpl copyWithoutUsages() {
        return new FunctionSymbolImpl(this.name(), this);
    }

    private static boolean isInstanceMethod(FunctionDef functionDef) {
        return functionDef.isMethodDefinition() && functionDef.decorators().stream().map(decorator -> {
            List<Name> names = decorator.name().names();
            return names.get(names.size() - 1).name();
        }).noneMatch(decorator -> decorator.equals("staticmethod") || decorator.equals("classmethod"));
    }

    private void createParameterNames(List<AnyParameter> parameterTrees) {
        boolean keywordOnly = false;
        for (AnyParameter anyParameter : parameterTrees) {
            if (anyParameter.is(Tree.Kind.PARAMETER)) {
                Parameter parameter = (Parameter)anyParameter;
                Name parameterName = parameter.name();
                if (parameterName != null) {
                    this.parameters.add(new ParameterImpl(parameterName.name(), parameter.defaultValue() != null, keywordOnly));
                    if (parameter.starToken() == null) continue;
                    this.hasVariadicParameter = true;
                    continue;
                }
                keywordOnly = true;
                continue;
            }
            this.parameters.add(new ParameterImpl(null, false, false));
        }
    }

    @Override
    public List<FunctionSymbol.Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    @Override
    public boolean hasVariadicParameter() {
        return this.hasVariadicParameter;
    }

    @Override
    public boolean isInstanceMethod() {
        return this.isInstanceMethod;
    }

    @Override
    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    @Override
    public LocationInFile definitionLocation() {
        return this.functionDefinitionLocation;
    }

    @CheckForNull
    Type returnType() {
        return this.returnType;
    }

    public InferredType declaredReturnType() {
        return this.declaredReturnType;
    }

    public void setDeclaredReturnType(InferredType declaredReturnType) {
        this.declaredReturnType = declaredReturnType;
    }

    public Symbol owner() {
        return this.owner;
    }

    public void setOwner(Symbol owner) {
        this.owner = owner;
    }

    private static class ParameterImpl
    implements FunctionSymbol.Parameter {
        private final String name;
        private final boolean hasDefaultValue;
        private final boolean isKeywordOnly;

        ParameterImpl(@Nullable String name, boolean hasDefaultValue, boolean isKeywordOnly) {
            this.name = name;
            this.hasDefaultValue = hasDefaultValue;
            this.isKeywordOnly = isKeywordOnly;
        }

        @Override
        @CheckForNull
        public String name() {
            return this.name;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.hasDefaultValue;
        }

        @Override
        public boolean isKeywordOnly() {
            return this.isKeywordOnly;
        }
    }
}

