/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.TriviaImpl;

public class TokenImpl
extends PyTree
implements org.sonar.plugins.python.api.tree.Token {
    private Token token;
    private List<Trivia> trivia;
    private int line;
    private int column;

    public TokenImpl(Token token) {
        this.token = token;
        this.trivia = token.getTrivia().stream().map(tr -> new TriviaImpl(new TokenImpl(tr.getToken()))).collect(Collectors.toList());
        this.line = token.getLine();
        this.column = token.getColumn();
    }

    @Override
    public String value() {
        return this.token.getValue();
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public List<Trivia> trivia() {
        return this.trivia;
    }

    @Override
    public TokenType type() {
        return this.token.getType();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitToken(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.emptyList();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TOKEN;
    }

    @Override
    public org.sonar.plugins.python.api.tree.Token firstToken() {
        return this;
    }

    @Override
    public org.sonar.plugins.python.api.tree.Token lastToken() {
        return this;
    }

    void setLineColumn(int line, int col) {
        this.line = line;
        this.column = col;
    }
}

