/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.RuntimeType;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.UnionType;

public class InferredTypes {
    public static final InferredType INT = InferredTypes.runtimeBuiltinType("int");
    public static final InferredType FLOAT = InferredTypes.runtimeBuiltinType("float");
    public static final InferredType COMPLEX = InferredTypes.runtimeBuiltinType("complex");
    public static final InferredType STR = InferredTypes.runtimeBuiltinType("str");
    public static final InferredType SET = InferredTypes.runtimeBuiltinType("set");
    public static final InferredType DICT = InferredTypes.runtimeBuiltinType("dict");
    public static final InferredType LIST = InferredTypes.runtimeBuiltinType("list");
    public static final InferredType TUPLE = InferredTypes.runtimeBuiltinType("tuple");
    public static final InferredType NONE = InferredTypes.runtimeBuiltinType("NoneType");
    public static final InferredType BOOL = InferredTypes.runtimeBuiltinType("bool");

    private InferredTypes() {
    }

    public static InferredType anyType() {
        return AnyType.ANY;
    }

    private static InferredType runtimeBuiltinType(String fullyQualifiedName) {
        return new RuntimeType(TypeShed.typeShedClass(fullyQualifiedName));
    }

    public static InferredType runtimeType(@Nullable Symbol typeClass) {
        if (typeClass instanceof ClassSymbol) {
            return new RuntimeType((ClassSymbol)typeClass);
        }
        return InferredTypes.anyType();
    }

    public static InferredType or(InferredType t1, InferredType t2) {
        return UnionType.or(t1, t2);
    }

    public static InferredType declaredType(TypeAnnotation typeAnnotation) {
        Expression expression = typeAnnotation.expression();
        if (expression.is(Tree.Kind.NAME) && !((Name)expression).name().equals("Any")) {
            return InferredTypes.runtimeType(((Name)expression).symbol());
        }
        return InferredTypes.anyType();
    }
}

