/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.UnionType;

class RuntimeType
implements InferredType {
    private final ClassSymbol typeClass;

    RuntimeType(ClassSymbol typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        if (other == AnyType.ANY) {
            return true;
        }
        if (other instanceof UnionType) {
            return other.isIdentityComparableWith(this);
        }
        return this.equals(other);
    }

    @Override
    public boolean canHaveMember(String memberName) {
        LinkedHashSet<ClassSymbol> classSymbols = this.classesToExplore();
        if (classSymbols.stream().anyMatch(ClassSymbol::hasUnresolvedTypeHierarchy)) {
            return true;
        }
        for (ClassSymbol classSymbol : classSymbols) {
            for (Symbol member : classSymbol.declaredMembers()) {
                if (!member.name().equals(memberName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        LinkedHashSet<ClassSymbol> classSymbols = this.classesToExplore();
        for (ClassSymbol classSymbol : classSymbols) {
            for (Symbol member : classSymbol.declaredMembers()) {
                if (!member.name().equals(memberName)) continue;
                return Optional.of(member);
            }
        }
        return Optional.empty();
    }

    private LinkedHashSet<ClassSymbol> classesToExplore() {
        LinkedHashSet<ClassSymbol> set = new LinkedHashSet<ClassSymbol>();
        RuntimeType.addClassesToExplore(this.typeClass, set);
        return set;
    }

    private static void addClassesToExplore(ClassSymbol typeClass, LinkedHashSet<ClassSymbol> set) {
        if (set.add(typeClass)) {
            for (Symbol superClass : typeClass.superClasses()) {
                if (!(superClass instanceof ClassSymbol)) continue;
                RuntimeType.addClassesToExplore((ClassSymbol)superClass, set);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeType that = (RuntimeType)o;
        return Objects.equals(this.typeClass.fullyQualifiedName(), that.typeClass.fullyQualifiedName());
    }

    public int hashCode() {
        return Objects.hash(this.typeClass.fullyQualifiedName());
    }

    public String toString() {
        return "RuntimeType(" + this.typeClass.fullyQualifiedName() + ')';
    }
}

