/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import com.sonar.sslr.api.AstNode;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShedPythonFile;

public class TypeShed {
    private static final String NONE_TYPE = "NoneType";
    private static Map<String, Symbol> typeShedSymbols;

    private TypeShed() {
    }

    public static Map<String, Symbol> typeShedSymbols() {
        if (typeShedSymbols == null) {
            HashMap<String, Symbol> typeShedSymbols = new HashMap<String, Symbol>();
            typeShedSymbols.put(NONE_TYPE, new ClassSymbolImpl(NONE_TYPE, NONE_TYPE));
            InputStream resource = TypeShed.class.getResourceAsStream("builtins.pyi");
            TypeShedPythonFile file = new TypeShedPythonFile(resource);
            AstNode astNode = PythonParser.create().parse(file.content());
            FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
            Map<String, Set<Symbol>> globalSymbols = Collections.emptyMap();
            new SymbolTableBuilder("", file, globalSymbols).visitFileInput(fileInput);
            for (Symbol globalVariable : fileInput.globalVariables()) {
                typeShedSymbols.put(globalVariable.fullyQualifiedName(), globalVariable);
            }
            BaseTreeVisitor visitor = new BaseTreeVisitor(){

                @Override
                public void visitFunctionDef(FunctionDef functionDef) {
                    TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
                    Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> {
                        if (symbol.kind() == Symbol.Kind.FUNCTION && returnTypeAnnotation != null) {
                            FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
                            functionSymbol.setDeclaredReturnType(InferredTypes.declaredType(returnTypeAnnotation));
                        }
                    });
                    super.visitFunctionDef(functionDef);
                }
            };
            fileInput.accept(visitor);
            TypeShed.typeShedSymbols = Collections.unmodifiableMap(typeShedSymbols);
        }
        return typeShedSymbols;
    }

    public static ClassSymbol typeShedClass(String fullyQualifiedName) {
        Symbol symbol = TypeShed.typeShedSymbols().get(fullyQualifiedName);
        if (symbol == null) {
            throw new IllegalArgumentException("No TypeShed symbol found for name: " + fullyQualifiedName);
        }
        if (symbol.kind() != Symbol.Kind.CLASS) {
            throw new IllegalArgumentException("TypeShed symbol " + fullyQualifiedName + " is not a class");
        }
        return (ClassSymbol)symbol;
    }
}

