/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.io.File;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShedPythonFile;

public class SymbolUtils {
    private static final String SEND_MESSAGE = "send_message";
    private static final String SET_COOKIE = "set_cookie";
    private static final String SET_SIGNED_COOKIE = "set_signed_cookie";

    private SymbolUtils() {
    }

    public static String fullyQualifiedModuleName(String packageName, String fileName) {
        String moduleName;
        int extensionIndex = fileName.lastIndexOf(46);
        String string = moduleName = extensionIndex > 0 ? fileName.substring(0, extensionIndex) : fileName;
        if (moduleName.equals("__init__")) {
            return packageName;
        }
        return packageName.isEmpty() ? moduleName : packageName + "." + moduleName;
    }

    public static Set<Symbol> globalSymbols(FileInput fileInput, String packageName, PythonFile pythonFile) {
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName, pythonFile);
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
        fileInput.accept(symbolTableBuilder);
        HashSet<Symbol> globalSymbols = new HashSet<Symbol>();
        for (Symbol globalVariable : fileInput.globalVariables()) {
            if (globalVariable.kind() == Symbol.Kind.CLASS) {
                globalSymbols.add(((ClassSymbolImpl)globalVariable).copyWithoutUsages());
                continue;
            }
            if (globalVariable.kind() == Symbol.Kind.FUNCTION) {
                globalSymbols.add(new FunctionSymbolImpl(globalVariable.name(), (FunctionSymbol)globalVariable));
                continue;
            }
            globalSymbols.add(new SymbolImpl(globalVariable.name(), fullyQualifiedModuleName + "." + globalVariable.name()));
        }
        return globalSymbols;
    }

    static void resolveTypeHierarchy(ClassDef classDef, @Nullable Symbol symbol) {
        if (symbol == null || !Symbol.Kind.CLASS.equals((Object)symbol.kind())) {
            return;
        }
        ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
        ArgList argList = classDef.args();
        if (argList == null) {
            return;
        }
        for (Argument argument : argList.arguments()) {
            Expression expression;
            Symbol argumentSymbol;
            if (argument.is(Tree.Kind.REGULAR_ARGUMENT) && ((RegularArgument)argument).expression() instanceof HasSymbol && (argumentSymbol = ((HasSymbol)((Object)(expression = ((RegularArgument)argument).expression()))).symbol()) != null) {
                classSymbol.addSuperClass(argumentSymbol);
                continue;
            }
            classSymbol.setHasSuperClassWithoutSymbol();
        }
    }

    static List<Expression> assignmentsLhs(AssignmentStatement assignmentStatement) {
        return assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).flatMap(TreeUtils::flattenTuples).collect(Collectors.toList());
    }

    static List<Name> boundNamesFromExpression(@CheckForNull Tree tree) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (tree == null) {
            return names;
        }
        if (tree.is(Tree.Kind.NAME)) {
            names.add((Name)tree);
        } else if (tree.is(Tree.Kind.TUPLE)) {
            ((Tuple)tree).elements().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.LIST_LITERAL)) {
            ((ListLiteral)tree).elements().expressions().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.PARENTHESIZED)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((ParenthesizedExpression)tree).expression()));
        } else if (tree.is(Tree.Kind.UNPACKING_EXPR)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((UnpackingExpression)tree).expression()));
        }
        return names;
    }

    public static String pythonPackageName(File file, File projectBaseDir) {
        File initFile;
        File currentDirectory = file.getParentFile();
        ArrayDeque<String> packages = new ArrayDeque<String>();
        while (!currentDirectory.getAbsolutePath().equals(projectBaseDir.getAbsolutePath()) && (initFile = new File(currentDirectory, "__init__.py")).exists()) {
            packages.push(currentDirectory.getName());
            currentDirectory = currentDirectory.getParentFile();
        }
        return String.join((CharSequence)".", packages);
    }

    @CheckForNull
    static Path pathOf(PythonFile pythonFile) {
        try {
            URI uri = pythonFile.uri();
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return Paths.get(uri);
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public static Map<String, Set<Symbol>> externalModulesSymbols() {
        HashMap<String, Set<Symbol>> globalSymbols = new HashMap<String, Set<Symbol>>();
        globalSymbols.put("flask_mail", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("Mail", "flask_mail.Mail", "send", SEND_MESSAGE), SymbolUtils.classSymbol("Connection", "flask_mail.Connection", "send", SEND_MESSAGE))));
        globalSymbols.put("smtplib", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("SMTP", "smtplib.SMTP", "sendmail", SEND_MESSAGE, "starttls"), SymbolUtils.classSymbol("SMTP_SSL", "smtplib.SMTP_SSL", "sendmail", SEND_MESSAGE))));
        globalSymbols.put("zipfile", Collections.singleton(SymbolUtils.classSymbol("ZipFile", "zipfile.ZipFile", "extractall")));
        globalSymbols.put("http.cookies", new HashSet<ClassSymbolImpl>(Collections.singletonList(SymbolUtils.classSymbol("SimpleCookie", "http.cookies.SimpleCookie", new String[0]))));
        globalSymbols.put("django.http", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("HttpResponse", "django.http.HttpResponse", SET_COOKIE, SET_SIGNED_COOKIE, "__setitem__"), SymbolUtils.classSymbol("HttpResponseRedirect", "django.http.HttpResponseRedirect", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponsePermanentRedirect", "django.http.HttpResponsePermanentRedirect", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseNotModified", "django.http.HttpResponseNotModified", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseNotFound", "django.http.HttpResponseNotFound", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseForbidden", "django.http.HttpResponseForbidden", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseNotAllowed", "django.http.HttpResponseNotAllowed", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseGone", "django.http.HttpResponseGone", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseServerError", "django.http.HttpResponseServerError", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseBadRequest", "django.http.HttpResponseBadRequest", SET_COOKIE, SET_SIGNED_COOKIE))));
        globalSymbols.put("django.http.response", new HashSet<ClassSymbolImpl>(Collections.singleton(SymbolUtils.classSymbol("HttpResponse", "django.http.response.HttpResponse", new String[0]))));
        ClassSymbolImpl flaskResponse = SymbolUtils.classSymbol("Response", "flask.Response", SET_COOKIE);
        FunctionSymbolImpl makeResponse = new FunctionSymbolImpl("make_response", "flask.make_response", false, false, false, Collections.emptyList());
        makeResponse.setDeclaredReturnType(InferredTypes.runtimeType(flaskResponse));
        FunctionSymbolImpl redirect = new FunctionSymbolImpl("redirect", "flask.redirect", false, false, false, Collections.emptyList());
        redirect.setDeclaredReturnType(InferredTypes.runtimeType(flaskResponse));
        globalSymbols.put("flask", new HashSet<SymbolImpl>(Arrays.asList(flaskResponse, makeResponse, redirect)));
        globalSymbols.put("werkzeug.datastructures", new HashSet<ClassSymbolImpl>(Collections.singleton(SymbolUtils.classSymbol("Headers", "werkzeug.datastructures.Headers", "set", "setdefault", "__setitem__"))));
        return globalSymbols;
    }

    private static ClassSymbolImpl classSymbol(String name, String fullyQualifiedName, String ... members) {
        ClassSymbolImpl classSymbol = new ClassSymbolImpl(name, fullyQualifiedName);
        classSymbol.addMembers(Arrays.stream(members).map(m -> new SymbolImpl((String)m, fullyQualifiedName + "." + m)).collect(Collectors.toSet()));
        return classSymbol;
    }

    public static boolean isTypeShedFile(PythonFile pythonFile) {
        return pythonFile instanceof TypeShedPythonFile;
    }
}

