/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ReturnStatementImpl
extends SimpleStatement
implements ReturnStatement {
    private final Token returnKeyword;
    private final List<Expression> expressionTrees;
    private final Separators separators;

    public ReturnStatementImpl(Token returnKeyword, List<Expression> expressionTrees, Separators separators) {
        this.returnKeyword = returnKeyword;
        this.expressionTrees = expressionTrees;
        this.separators = separators;
    }

    @Override
    public Token returnKeyword() {
        return this.returnKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressionTrees;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitReturnStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.returnKeyword), this.expressionTrees, this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Token separator() {
        return this.separators.last();
    }
}

