/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Objects;
import java.util.Optional;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.UnionType;

class RuntimeType
implements InferredType {
    private final ClassSymbol typeClass;

    RuntimeType(ClassSymbol typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        if (other == AnyType.ANY) {
            return true;
        }
        if (other instanceof UnionType) {
            return other.isIdentityComparableWith(this);
        }
        return this.equals(other);
    }

    @Override
    public boolean canHaveMember(String memberName) {
        if (this.typeClass.hasUnresolvedTypeHierarchy()) {
            return true;
        }
        return this.typeClass.resolveMember(memberName).isPresent();
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        return this.typeClass.resolveMember(memberName);
    }

    @Override
    public boolean canOnlyBe(String typeName) {
        return typeName.equals(this.typeClass.fullyQualifiedName());
    }

    @Override
    public boolean canBeOrExtend(String typeName) {
        return this.typeClass.isOrExtends(typeName) || this.typeClass.hasUnresolvedTypeHierarchy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeType that = (RuntimeType)o;
        return Objects.equals(this.typeClass.fullyQualifiedName(), that.typeClass.fullyQualifiedName());
    }

    public int hashCode() {
        return Objects.hash(this.typeClass.fullyQualifiedName());
    }

    public String toString() {
        return "RuntimeType(" + this.typeClass.fullyQualifiedName() + ')';
    }
}

