/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.TokenLocation;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.types.InferredTypes;

public class FunctionSymbolImpl
extends SymbolImpl
implements FunctionSymbol {
    private final List<FunctionSymbol.Parameter> parameters = new ArrayList<FunctionSymbol.Parameter>();
    private final LocationInFile functionDefinitionLocation;
    private boolean hasVariadicParameter = false;
    private final boolean isInstanceMethod;
    private final boolean hasDecorators;
    private InferredType declaredReturnType = InferredTypes.anyType();
    private boolean isStub = false;
    private Symbol owner;

    FunctionSymbolImpl(FunctionDef functionDef, @Nullable String fullyQualifiedName, PythonFile pythonFile) {
        super(functionDef.name().name(), fullyQualifiedName);
        ParameterList parametersList;
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = FunctionSymbolImpl.isInstanceMethod(functionDef);
        this.hasDecorators = !functionDef.decorators().isEmpty();
        String fileId = null;
        if (!SymbolUtils.isTypeShedFile(pythonFile)) {
            Path path = SymbolUtils.pathOf(pythonFile);
            String string = fileId = path != null ? path.toString() : pythonFile.toString();
        }
        if ((parametersList = functionDef.parameters()) != null) {
            this.createParameterNames(parametersList.all(), fileId);
        }
        this.functionDefinitionLocation = FunctionSymbolImpl.locationInFile(functionDef.name(), fileId);
    }

    FunctionSymbolImpl(String name, FunctionSymbol functionSymbol) {
        super(name, functionSymbol.fullyQualifiedName());
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = functionSymbol.isInstanceMethod();
        this.hasDecorators = functionSymbol.hasDecorators();
        this.hasVariadicParameter = functionSymbol.hasVariadicParameter();
        this.parameters.addAll(functionSymbol.parameters());
        this.functionDefinitionLocation = functionSymbol.definitionLocation();
        this.declaredReturnType = ((FunctionSymbolImpl)functionSymbol).declaredReturnType();
        this.isStub = functionSymbol.isStub();
    }

    public FunctionSymbolImpl(String name, @Nullable String fullyQualifiedName, boolean hasVariadicParameter, boolean isInstanceMethod, boolean hasDecorators, List<FunctionSymbol.Parameter> parameters) {
        super(name, fullyQualifiedName);
        this.setKind(Symbol.Kind.FUNCTION);
        this.hasVariadicParameter = hasVariadicParameter;
        this.isInstanceMethod = isInstanceMethod;
        this.hasDecorators = hasDecorators;
        this.parameters.addAll(parameters);
        this.functionDefinitionLocation = null;
        this.isStub = true;
    }

    @CheckForNull
    private static LocationInFile locationInFile(Tree tree, @Nullable String fileId) {
        if (fileId == null) {
            return null;
        }
        TokenLocation firstToken = new TokenLocation(tree.firstToken());
        TokenLocation lastToken = new TokenLocation(tree.lastToken());
        return new LocationInFile(fileId, firstToken.startLine(), firstToken.startLineOffset(), lastToken.endLine(), lastToken.endLineOffset());
    }

    @Override
    FunctionSymbolImpl copyWithoutUsages() {
        FunctionSymbolImpl copy = new FunctionSymbolImpl(this.name(), this);
        copy.setKind(this.kind());
        return copy;
    }

    private static boolean isInstanceMethod(FunctionDef functionDef) {
        return !functionDef.name().name().equals("__new__") && functionDef.isMethodDefinition() && functionDef.decorators().stream().map(decorator -> {
            List<Name> names = decorator.name().names();
            return names.get(names.size() - 1).name();
        }).noneMatch(decorator -> decorator.equals("staticmethod") || decorator.equals("classmethod"));
    }

    private void createParameterNames(List<AnyParameter> parameterTrees, @Nullable String fileId) {
        ParameterState parameterState = new ParameterState();
        for (AnyParameter anyParameter : parameterTrees) {
            if (anyParameter.is(Tree.Kind.PARAMETER)) {
                this.addParameter((Parameter)anyParameter, fileId, parameterState);
                continue;
            }
            this.parameters.add(new ParameterImpl(null, false, parameterState, FunctionSymbolImpl.locationInFile(anyParameter, fileId)));
        }
    }

    private void addParameter(Parameter parameter, @Nullable String fileId, ParameterState parameterState) {
        Name parameterName = parameter.name();
        Token starToken = parameter.starToken();
        if (parameterName != null) {
            this.parameters.add(new ParameterImpl(parameterName.name(), parameter.defaultValue() != null, parameterState, FunctionSymbolImpl.locationInFile(parameter, fileId)));
            if (starToken != null) {
                this.hasVariadicParameter = true;
            }
        } else if (starToken != null) {
            if ("*".equals(starToken.value())) {
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
            if ("/".equals(starToken.value())) {
                parameterState.positionalOnly = true;
            }
        }
    }

    @Override
    public List<FunctionSymbol.Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    @Override
    public boolean hasVariadicParameter() {
        return this.hasVariadicParameter;
    }

    @Override
    public boolean isInstanceMethod() {
        return this.isInstanceMethod;
    }

    @Override
    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    @Override
    public LocationInFile definitionLocation() {
        return this.functionDefinitionLocation;
    }

    public InferredType declaredReturnType() {
        return this.declaredReturnType;
    }

    public void setDeclaredReturnType(InferredType declaredReturnType) {
        this.declaredReturnType = declaredReturnType;
    }

    public Symbol owner() {
        return this.owner;
    }

    public void setOwner(Symbol owner) {
        this.owner = owner;
    }

    private static class ParameterImpl
    implements FunctionSymbol.Parameter {
        private final String name;
        private final boolean hasDefaultValue;
        private final boolean isKeywordOnly;
        private final boolean isPositionalOnly;
        private final LocationInFile location;

        ParameterImpl(@Nullable String name, boolean hasDefaultValue, ParameterState parameterState, @Nullable LocationInFile location) {
            this.name = name;
            this.hasDefaultValue = hasDefaultValue;
            this.isKeywordOnly = parameterState.keywordOnly;
            this.isPositionalOnly = parameterState.positionalOnly;
            this.location = location;
        }

        @Override
        @CheckForNull
        public String name() {
            return this.name;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.hasDefaultValue;
        }

        @Override
        public boolean isKeywordOnly() {
            return this.isKeywordOnly;
        }

        @Override
        public boolean isPositionalOnly() {
            return this.isPositionalOnly;
        }

        @Override
        @CheckForNull
        public LocationInFile location() {
            return this.location;
        }
    }

    private static class ParameterState {
        boolean keywordOnly = false;
        boolean positionalOnly = false;

        private ParameterState() {
        }
    }
}

