/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.UsageImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.types.InferredTypes;

public class SymbolImpl
implements Symbol {
    private final String name;
    @Nullable
    String fullyQualifiedName;
    private final List<Usage> usages = new ArrayList<Usage>();
    private Map<String, Symbol> childrenSymbolByName = new HashMap<String, Symbol>();
    private Symbol.Kind kind;
    private InferredType inferredType = InferredTypes.anyType();

    public SymbolImpl(String name, @Nullable String fullyQualifiedName) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.kind = Symbol.Kind.OTHER;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Usage> usages() {
        return Collections.unmodifiableList(this.usages);
    }

    @Override
    @CheckForNull
    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public boolean is(Symbol.Kind ... kinds) {
        Symbol.Kind symbolKind = this.kind();
        for (Symbol.Kind kindIter : kinds) {
            if (symbolKind != kindIter) continue;
            return true;
        }
        return false;
    }

    @Override
    public Symbol.Kind kind() {
        return this.kind;
    }

    public void setKind(Symbol.Kind kind) {
        this.kind = kind;
    }

    void addUsage(Tree tree, Usage.Kind kind) {
        UsageImpl usage = new UsageImpl(tree, kind);
        this.usages.add(usage);
        if (tree.is(Tree.Kind.NAME)) {
            ((NameImpl)tree).setSymbol(this);
            ((NameImpl)tree).setUsage(usage);
        }
    }

    void addOrCreateChildUsage(Name name, Usage.Kind kind) {
        String childSymbolName = name.name();
        if (!this.childrenSymbolByName.containsKey(childSymbolName)) {
            String childFullyQualifiedName = this.fullyQualifiedName != null ? this.fullyQualifiedName + "." + childSymbolName : null;
            SymbolImpl symbol = new SymbolImpl(childSymbolName, childFullyQualifiedName);
            this.childrenSymbolByName.put(childSymbolName, symbol);
        }
        Symbol symbol = this.childrenSymbolByName.get(childSymbolName);
        ((SymbolImpl)symbol).addUsage(name, kind);
    }

    void addChildSymbol(Symbol symbol) {
        this.childrenSymbolByName.put(symbol.name(), symbol);
    }

    public InferredType inferredType() {
        return this.inferredType;
    }

    public void setInferredType(InferredType inferredType) {
        this.inferredType = inferredType;
    }

    SymbolImpl copyWithoutUsages() {
        return new SymbolImpl(this.name(), this.fullyQualifiedName);
    }

    public void removeUsages() {
        this.usages.clear();
        this.childrenSymbolByName.values().forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
    }
}

