/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import com.sonar.sslr.api.AstNode;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShedPythonFile;

public class TypeShed {
    private static final String TYPING = "typing";
    private static Map<String, Symbol> builtins;
    private static Map<String, Set<Symbol>> standardLibrarySymbols;
    private static Map<String, Set<Symbol>> builtinGlobalSymbols;

    private TypeShed() {
    }

    public static Map<String, Symbol> builtinSymbols() {
        if (builtins == null) {
            HashMap<String, Symbol> builtins = new HashMap<String, Symbol>();
            builtins.put("NoneType", new ClassSymbolImpl("NoneType", "NoneType"));
            InputStream resource = TypeShed.class.getResourceAsStream("builtins.pyi");
            TypeShedPythonFile file = new TypeShedPythonFile(resource, "");
            AstNode astNode = PythonParser.create().parse(file.content());
            FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
            Map<String, Set<Symbol>> globalSymbols = Collections.singletonMap(TYPING, TypeShed.typingModuleSymbols());
            new SymbolTableBuilder("", file, globalSymbols).visitFileInput(fileInput);
            for (Symbol globalVariable : fileInput.globalVariables()) {
                ((SymbolImpl)globalVariable).removeUsages();
                builtins.put(globalVariable.fullyQualifiedName(), globalVariable);
            }
            TypeShed.builtins = Collections.unmodifiableMap(builtins);
            InferredTypes.setBuiltinSymbols(builtins);
            fileInput.accept(new ReturnTypeVisitor());
            builtinGlobalSymbols.put("", new HashSet(builtins.values()));
        }
        return builtins;
    }

    private static void setDeclaredReturnType(Symbol symbol, FunctionDef functionDef) {
        TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
        if (returnTypeAnnotation == null) {
            return;
        }
        if (symbol.is(Symbol.Kind.FUNCTION)) {
            FunctionSymbolImpl functionSymbol2 = (FunctionSymbolImpl)symbol;
            functionSymbol2.setDeclaredReturnType(InferredTypes.declaredType(returnTypeAnnotation));
        } else if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
            Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> TypeShed.setDeclaredReturnType(functionSymbol, functionDef));
        }
    }

    static Set<Symbol> typingModuleSymbols() {
        Map<String, Symbol> typingPython3 = TypeShed.getModuleSymbols("3/typing.pyi", TYPING);
        Map<String, Symbol> typingPython2 = TypeShed.getModuleSymbols("2/typing.pyi", TYPING);
        HashSet<Symbol> typingModuleSymbols = new HashSet<Symbol>();
        typingPython3.forEach((fqn, python3Symbol) -> {
            Symbol python2Symbol = (Symbol)typingPython2.get(fqn);
            if (python2Symbol == null) {
                typingModuleSymbols.add((Symbol)python3Symbol);
            } else {
                HashSet<Symbol> symbols = new HashSet<Symbol>();
                symbols.add(python2Symbol);
                symbols.add((Symbol)python3Symbol);
                typingModuleSymbols.add(AmbiguousSymbolImpl.create(symbols));
            }
        });
        typingPython2.forEach((fqn, python2Symbol) -> {
            if (typingPython3.get(fqn) == null) {
                typingModuleSymbols.add((Symbol)python2Symbol);
            }
        });
        return typingModuleSymbols;
    }

    private static Map<String, Symbol> getModuleSymbols(String resourcePath, String moduleName) {
        InputStream resource = TypeShed.class.getResourceAsStream(resourcePath);
        TypeShedPythonFile file = new TypeShedPythonFile(resource, moduleName);
        AstNode astNode = PythonParser.create().parse(file.content());
        FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
        new SymbolTableBuilder("", file, Collections.emptyMap()).visitFileInput(fileInput);
        return fileInput.globalVariables().stream().map(symbol -> {
            ((SymbolImpl)symbol).removeUsages();
            return symbol;
        }).filter(s -> s.fullyQualifiedName() != null).collect(Collectors.toMap(Symbol::fullyQualifiedName, Function.identity()));
    }

    public static Set<Symbol> standardLibrarySymbols(String stdlibModuleName) {
        if (!standardLibrarySymbols.containsKey(stdlibModuleName)) {
            Map<String, Symbol> result = TypeShed.readTypeShedSymbols("stdlib/2and3/" + stdlibModuleName + ".pyi", stdlibModuleName);
            if (result != null) {
                standardLibrarySymbols.put(stdlibModuleName, result.values().stream().filter(s -> s.fullyQualifiedName() != null).collect(Collectors.toSet()));
                return standardLibrarySymbols.get(stdlibModuleName);
            }
            return Collections.emptySet();
        }
        return standardLibrarySymbols.get(stdlibModuleName);
    }

    public static Symbol standardLibrarySymbol(String stdLibModuleName, String fullyQualifiedName) {
        Set<Symbol> librarySymbols = TypeShed.standardLibrarySymbols(stdLibModuleName);
        return librarySymbols.stream().filter(s -> fullyQualifiedName.equals(s.fullyQualifiedName())).findFirst().orElse(null);
    }

    public static Map<String, Symbol> readTypeShedSymbols(String fileName, String moduleName) {
        HashMap<String, Symbol> typeShedSymbols = new HashMap<String, Symbol>();
        InputStream resource = TypeShed.class.getResourceAsStream(fileName);
        if (resource == null) {
            return null;
        }
        TypeShedPythonFile file = new TypeShedPythonFile(resource, moduleName);
        AstNode astNode = PythonParser.create().parse(file.content());
        FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
        new SymbolTableBuilder("", file, builtinGlobalSymbols).visitFileInput(fileInput);
        for (Symbol globalVariable : fileInput.globalVariables()) {
            ((SymbolImpl)globalVariable).removeUsages();
            typeShedSymbols.put(globalVariable.fullyQualifiedName(), globalVariable);
        }
        fileInput.accept(new ReturnTypeVisitor());
        return Collections.unmodifiableMap(typeShedSymbols);
    }

    public static ClassSymbol typeShedClass(String fullyQualifiedName) {
        Symbol symbol = TypeShed.builtinSymbols().get(fullyQualifiedName);
        if (symbol == null) {
            throw new IllegalArgumentException("No TypeShed symbol found for name: " + fullyQualifiedName);
        }
        if (symbol.kind() != Symbol.Kind.CLASS) {
            throw new IllegalArgumentException("TypeShed symbol " + fullyQualifiedName + " is not a class");
        }
        return (ClassSymbol)symbol;
    }

    static {
        standardLibrarySymbols = new HashMap<String, Set<Symbol>>();
        builtinGlobalSymbols = new HashMap<String, Set<Symbol>>();
    }

    static class ReturnTypeVisitor
    extends BaseTreeVisitor {
        ReturnTypeVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> {
                TypeShed.setDeclaredReturnType(symbol, functionDef);
                ReturnTypeVisitor.setParameterTypes(symbol, functionDef);
            });
            super.visitFunctionDef(functionDef);
        }

        private static void setParameterTypes(Symbol symbol, FunctionDef functionDef) {
            FunctionSymbol funcDefSymbol;
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
                ParameterList parameters = functionDef.parameters();
                if (parameters != null) {
                    functionSymbol.setParametersWithType(parameters);
                }
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS) && (funcDefSymbol = ((FunctionDefImpl)functionDef).functionSymbol()) != null) {
                ReturnTypeVisitor.setParameterTypes(funcDefSymbol, functionDef);
            }
        }
    }
}

