import os
import sys
import types
from typing import IO, Any, List, Optional, Tuple, TypeVar, Union

from _imp import (
    acquire_lock as acquire_lock,
    create_dynamic as create_dynamic,
    get_frozen_object as get_frozen_object,
    init_frozen as init_frozen,
    is_builtin as is_builtin,
    is_frozen as is_frozen,
    is_frozen_package as is_frozen_package,
    lock_held as lock_held,
    release_lock as release_lock,
)
from _typeshed import StrPath

_T = TypeVar("_T")

SEARCH_ERROR: int
PY_SOURCE: int
PY_COMPILED: int
C_EXTENSION: int
PY_RESOURCE: int
PKG_DIRECTORY: int
C_BUILTIN: int
PY_FROZEN: int
PY_CODERESOURCE: int
IMP_HOOK: int

def new_module(name: str) -> types.ModuleType: ...
def get_magic() -> bytes: ...
def get_tag() -> str: ...
def cache_from_source(path: StrPath, debug_override: Optional[bool] = ...) -> str: ...
def source_from_cache(path: StrPath) -> str: ...
def get_suffixes() -> List[Tuple[str, str, int]]: ...

class NullImporter:
    def __init__(self, path: StrPath) -> None: ...
    def find_module(self, fullname: Any) -> None: ...

# PathLike doesn't work for the pathname argument here
def load_source(name: str, pathname: str, file: Optional[IO[Any]] = ...) -> types.ModuleType: ...
def load_compiled(name: str, pathname: str, file: Optional[IO[Any]] = ...) -> types.ModuleType: ...
def load_package(name: str, path: StrPath) -> types.ModuleType: ...
def load_module(name: str, file: IO[Any], filename: str, details: Tuple[str, str, int]) -> types.ModuleType: ...

if sys.version_info >= (3, 6):
    def find_module(
        name: str, path: Union[None, List[str], List[os.PathLike[str]], List[StrPath]] = ...
    ) -> Tuple[IO[Any], str, Tuple[str, str, int]]: ...

else:
    def find_module(name: str, path: Optional[List[str]] = ...) -> Tuple[IO[Any], str, Tuple[str, str, int]]: ...

def reload(module: types.ModuleType) -> types.ModuleType: ...
def init_builtin(name: str) -> Optional[types.ModuleType]: ...
def load_dynamic(name: str, path: str, file: Optional[IO[Any]] = ...) -> types.ModuleType: ...
