/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.regex;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.python.regex.PythonAnalyzerRegexSource;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class PythonStringCharacterParser
implements CharacterParser {
    private static final Pattern UNICODE_16_BIT_PATTERN = Pattern.compile("\\Au([0-9A-Fa-f]{4})");
    private static final Pattern UNICODE_32_BIT_PATTERN = Pattern.compile("\\AU([0-9A-Fa-f]{8})");
    private static final Pattern HEX_PATTERN = Pattern.compile("\\Ax([0-9A-Fa-f]{2})");
    private static final Pattern OCTAL_PATTERN = Pattern.compile("\\A([0-7]{1,3})");
    final String sourceText;
    final int textLength;
    protected final PythonAnalyzerRegexSource source;
    protected int index;
    @Nullable
    private SourceCharacter current;

    public PythonStringCharacterParser(PythonAnalyzerRegexSource source) {
        this.source = source;
        this.sourceText = source.getSourceText();
        this.textLength = source.length();
        this.index = 0;
        this.moveNext();
    }

    public void moveNext() {
        this.current = this.index >= this.textLength ? null : this.parsePythonCharacter();
    }

    private SourceCharacter parsePythonCharacter() {
        char ch = this.sourceText.charAt(this.index);
        if (!this.source.isRawString() && ch == '\\') {
            if (this.index + 1 >= this.textLength) {
                return this.createCharAndUpdateIndex('\\', 1);
            }
            return this.parsePythonEscapeSequence();
        }
        return this.createCharAndUpdateIndex(ch, 1);
    }

    SourceCharacter createCharAndUpdateIndex(char ch, int length) {
        int startIndex = this.index;
        this.index += length;
        return new SourceCharacter((RegexSource)this.source, new IndexRange(startIndex, this.index), ch, length > 1);
    }

    public SourceCharacter getCurrent() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    public boolean isAtEnd() {
        return this.current == null;
    }

    public void resetTo(int index) {
        this.index = index;
        this.moveNext();
    }

    private SourceCharacter parsePythonEscapeSequence() {
        char charAfterBackslash = this.sourceText.charAt(this.index + 1);
        switch (charAfterBackslash) {
            case '\n': {
                if (this.index + 2 >= this.textLength) {
                    return null;
                }
                this.index += 2;
                this.moveNext();
                return this.getCurrent();
            }
            case '\\': {
                return this.createCharAndUpdateIndex('\\', 2);
            }
            case '\'': {
                return this.createCharAndUpdateIndex('\'', 2);
            }
            case '\"': {
                return this.createCharAndUpdateIndex('\"', 2);
            }
            case 'a': {
                return this.createCharAndUpdateIndex('\u0007', 2);
            }
            case 'b': {
                return this.createCharAndUpdateIndex('\b', 2);
            }
            case 'f': {
                return this.createCharAndUpdateIndex('\f', 2);
            }
            case 'n': {
                return this.createCharAndUpdateIndex('\n', 2);
            }
            case 'r': {
                return this.createCharAndUpdateIndex('\r', 2);
            }
            case 't': {
                return this.createCharAndUpdateIndex('\t', 2);
            }
            case 'v': {
                return this.createCharAndUpdateIndex('\u000b', 2);
            }
            case 'u': {
                return this.createCharacterFromPattern(UNICODE_16_BIT_PATTERN, 16, 2);
            }
            case 'U': {
                return this.createCharacterFromPattern(UNICODE_32_BIT_PATTERN, 16, 2);
            }
            case 'x': {
                return this.createCharacterFromPattern(HEX_PATTERN, 16, 2);
            }
        }
        return this.createCharacterFromPattern(OCTAL_PATTERN, 8, 1);
    }

    private SourceCharacter createCharacterFromPattern(Pattern pattern, int radix, int initialLength) {
        Matcher matcher = pattern.matcher(this.sourceText.substring(this.index + 1));
        if (matcher.find()) {
            String value = matcher.group(1);
            return this.createCharAndUpdateIndex((char)Integer.parseInt(value, radix), value.length() + initialLength);
        }
        return this.createCharAndUpdateIndex('\\', 1);
    }
}

