/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class FunctionSymbolImpl
extends SymbolImpl
implements FunctionSymbol {
    private final List<FunctionSymbol.Parameter> parameters = new ArrayList<FunctionSymbol.Parameter>();
    private final List<String> decorators;
    private final LocationInFile functionDefinitionLocation;
    private boolean hasVariadicParameter = false;
    private final boolean isInstanceMethod;
    private final boolean isAsynchronous;
    private final boolean hasDecorators;
    private String annotatedReturnTypeName = null;
    private SymbolsProtos.Type protobufReturnType = null;
    private InferredType declaredReturnType = InferredTypes.anyType();
    private final boolean isStub;
    private Symbol owner;
    private static final String CLASS_METHOD_DECORATOR = "classmethod";
    private static final String STATIC_METHOD_DECORATOR = "staticmethod";
    private boolean isDjangoView = false;
    private boolean hasReadDeclaredReturnType = false;

    FunctionSymbolImpl(FunctionDef functionDef, @Nullable String fullyQualifiedName, PythonFile pythonFile) {
        super(functionDef.name().name(), fullyQualifiedName);
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = FunctionSymbolImpl.isInstanceMethod(functionDef);
        this.isAsynchronous = functionDef.asyncKeyword() != null;
        this.hasDecorators = !functionDef.decorators().isEmpty();
        this.decorators = FunctionSymbolImpl.decorators(functionDef);
        this.isStub = false;
        String fileId = Optional.ofNullable(SymbolUtils.pathOf(pythonFile)).map(Path::toString).orElse(pythonFile.toString());
        this.functionDefinitionLocation = TreeUtils.locationInFile(functionDef.name(), fileId);
    }

    public FunctionSymbolImpl(SymbolsProtos.FunctionSymbol functionSymbolProto, String moduleName) {
        this(functionSymbolProto, null, (List<String>)functionSymbolProto.getValidForList(), moduleName);
    }

    public FunctionSymbolImpl(SymbolsProtos.FunctionSymbol functionSymbolProto, @Nullable String containerClassFqn, String moduleName) {
        this(functionSymbolProto, containerClassFqn, (List<String>)functionSymbolProto.getValidForList(), moduleName);
    }

    public FunctionSymbolImpl(SymbolsProtos.FunctionSymbol functionSymbolProto, @Nullable String containerClassFqn, List<String> validFor, String moduleName) {
        super(functionSymbolProto.getName(), TypeShed.normalizedFqn(functionSymbolProto.getFullyQualifiedName(), moduleName, functionSymbolProto.getName(), containerClassFqn));
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = containerClassFqn != null && !functionSymbolProto.getIsStatic() && !functionSymbolProto.getIsClassMethod();
        this.isAsynchronous = functionSymbolProto.getIsAsynchronous();
        this.hasDecorators = functionSymbolProto.getHasDecorators();
        this.decorators = functionSymbolProto.getResolvedDecoratorNamesList();
        SymbolsProtos.Type returnAnnotation = functionSymbolProto.getReturnAnnotation();
        String returnTypeName = returnAnnotation.getFullyQualifiedName();
        this.annotatedReturnTypeName = returnTypeName.isEmpty() ? null : TypeShed.normalizedFqn(returnTypeName);
        this.protobufReturnType = returnAnnotation;
        for (SymbolsProtos.ParameterSymbol parameterSymbol : functionSymbolProto.getParametersList()) {
            ParameterState parameterState = new ParameterState();
            parameterState.positionalOnly = parameterSymbol.getKind() == SymbolsProtos.ParameterKind.POSITIONAL_ONLY;
            parameterState.keywordOnly = parameterSymbol.getKind() == SymbolsProtos.ParameterKind.KEYWORD_ONLY;
            boolean isKeywordVariadic = parameterSymbol.getKind() == SymbolsProtos.ParameterKind.VAR_KEYWORD;
            boolean isPositionalVariadic = parameterSymbol.getKind() == SymbolsProtos.ParameterKind.VAR_POSITIONAL;
            this.hasVariadicParameter |= isKeywordVariadic || isPositionalVariadic;
            InferredType declaredType = isPositionalVariadic ? InferredTypes.TUPLE : (isKeywordVariadic ? InferredTypes.DICT : InferredTypes.anyType());
            ParameterImpl parameter = new ParameterImpl(parameterSymbol.getName(), declaredType, null, parameterSymbol.getHasDefault(), parameterState, isKeywordVariadic, isPositionalVariadic, parameterSymbol.getTypeAnnotation(), null);
            this.parameters.add(parameter);
        }
        this.functionDefinitionLocation = null;
        this.declaredReturnType = InferredTypes.anyType();
        this.isStub = true;
        this.isDjangoView = false;
        this.validForPythonVersions = new HashSet<String>(validFor);
    }

    public FunctionSymbolImpl(FunctionDescriptor functionDescriptor, String symbolName) {
        super(symbolName, functionDescriptor.fullyQualifiedName());
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = functionDescriptor.isInstanceMethod();
        this.isAsynchronous = functionDescriptor.isAsynchronous();
        this.hasDecorators = functionDescriptor.hasDecorators();
        this.decorators = functionDescriptor.decorators();
        this.annotatedReturnTypeName = functionDescriptor.annotatedReturnTypeName();
        this.functionDefinitionLocation = functionDescriptor.definitionLocation();
        this.isStub = false;
    }

    public void setParametersWithType(ParameterList parametersList) {
        this.parameters.clear();
        this.createParameterNames(parametersList.all(), this.functionDefinitionLocation == null ? null : this.functionDefinitionLocation.fileId());
    }

    public void addParameter(ParameterImpl parameter) {
        this.parameters.add(parameter);
        if (parameter.isVariadic()) {
            this.hasVariadicParameter = true;
        }
    }

    FunctionSymbolImpl(String name, FunctionSymbol functionSymbol) {
        super(name, functionSymbol.fullyQualifiedName());
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = functionSymbol.isInstanceMethod();
        this.isAsynchronous = functionSymbol.isAsynchronous();
        this.hasDecorators = functionSymbol.hasDecorators();
        this.decorators = functionSymbol.decorators();
        this.annotatedReturnTypeName = functionSymbol.annotatedReturnTypeName();
        this.hasVariadicParameter = functionSymbol.hasVariadicParameter();
        this.parameters.addAll(functionSymbol.parameters());
        this.functionDefinitionLocation = functionSymbol.definitionLocation();
        FunctionSymbolImpl functionSymbolImpl = (FunctionSymbolImpl)functionSymbol;
        this.protobufReturnType = functionSymbolImpl.protobufReturnType;
        if (functionSymbolImpl.protobufReturnType == null || functionSymbolImpl.hasReadDeclaredReturnType) {
            this.declaredReturnType = functionSymbolImpl.declaredReturnType();
        }
        this.isStub = functionSymbol.isStub();
        this.isDjangoView = functionSymbolImpl.isDjangoView();
        this.validForPythonVersions = functionSymbolImpl.validForPythonVersions;
    }

    @Override
    public FunctionSymbolImpl copyWithoutUsages() {
        FunctionSymbolImpl copy = new FunctionSymbolImpl(this.name(), this);
        copy.setKind(this.kind());
        return copy;
    }

    private static boolean isInstanceMethod(FunctionDef functionDef) {
        return !functionDef.name().name().equals("__new__") && functionDef.isMethodDefinition() && functionDef.decorators().stream().map(decorator -> TreeUtils.decoratorNameFromExpression(decorator.expression())).filter(Objects::nonNull).noneMatch(decorator -> decorator.equals(STATIC_METHOD_DECORATOR) || decorator.equals(CLASS_METHOD_DECORATOR));
    }

    private static List<String> decorators(FunctionDef functionDef) {
        ArrayList<String> decoratorNames = new ArrayList<String>();
        for (Decorator decorator : functionDef.decorators()) {
            String decoratorName = TreeUtils.decoratorNameFromExpression(decorator.expression());
            if (decoratorName == null) continue;
            decoratorNames.add(decoratorName);
        }
        return decoratorNames;
    }

    private void createParameterNames(List<AnyParameter> parameterTrees, @Nullable String fileId) {
        ParameterState parameterState = new ParameterState();
        parameterState.positionalOnly = parameterTrees.stream().anyMatch(param -> Optional.of(param).filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).starToken()).map(Token::value).filter("/"::equals).isPresent());
        for (AnyParameter anyParameter : parameterTrees) {
            if (anyParameter.is(Tree.Kind.PARAMETER)) {
                this.addParameter((Parameter)anyParameter, fileId, parameterState);
                continue;
            }
            this.parameters.add(new ParameterImpl(null, InferredTypes.anyType(), null, false, parameterState, false, false, null, TreeUtils.locationInFile(anyParameter, fileId)));
        }
    }

    private void addParameter(Parameter parameter, @Nullable String fileId, ParameterState parameterState) {
        Name parameterName = parameter.name();
        Token starToken = parameter.starToken();
        if (parameterName != null) {
            ParameterType parameterType = this.getParameterType(parameter);
            this.parameters.add(new ParameterImpl(parameterName.name(), parameterType.inferredType, this.annotatedTypeName(parameter.typeAnnotation()), parameter.defaultValue() != null, parameterState, parameterType.isKeywordVariadic, parameterType.isPositionalVariadic, null, TreeUtils.locationInFile(parameter, fileId)));
            if (starToken != null) {
                this.hasVariadicParameter = true;
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
        } else if (starToken != null) {
            if ("*".equals(starToken.value())) {
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
            if ("/".equals(starToken.value())) {
                parameterState.positionalOnly = false;
            }
        }
    }

    private ParameterType getParameterType(Parameter parameter) {
        InferredType inferredType = InferredTypes.anyType();
        boolean isPositionalVariadic = false;
        boolean isKeywordVariadic = false;
        Token starToken = parameter.starToken();
        if (starToken != null) {
            this.hasVariadicParameter = true;
            if ("*".equals(starToken.value())) {
                isPositionalVariadic = true;
                inferredType = InferredTypes.TUPLE;
            }
            if ("**".equals(starToken.value())) {
                isKeywordVariadic = true;
                inferredType = InferredTypes.DICT;
            }
        } else {
            TypeAnnotation typeAnnotation = parameter.typeAnnotation();
            if (typeAnnotation != null) {
                inferredType = this.isStub ? InferredTypes.fromTypeshedTypeAnnotation(typeAnnotation) : InferredTypes.fromTypeAnnotation(typeAnnotation);
            }
        }
        return new ParameterType(inferredType, isKeywordVariadic, isPositionalVariadic);
    }

    @Override
    public List<String> decorators() {
        return this.decorators;
    }

    @Override
    public List<FunctionSymbol.Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    @Override
    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    @Override
    public boolean hasVariadicParameter() {
        return this.hasVariadicParameter;
    }

    @Override
    public boolean isInstanceMethod() {
        return this.isInstanceMethod;
    }

    @Override
    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    @Override
    public LocationInFile definitionLocation() {
        return this.functionDefinitionLocation;
    }

    public InferredType declaredReturnType() {
        if (!this.hasReadDeclaredReturnType && this.protobufReturnType != null) {
            this.declaredReturnType = InferredTypes.fromTypeshedProtobuf(this.protobufReturnType);
            this.hasReadDeclaredReturnType = true;
        }
        return this.declaredReturnType;
    }

    private String annotatedTypeName(@Nullable TypeAnnotation typeAnnotation) {
        return Optional.ofNullable(typeAnnotation).map(TypeAnnotation::expression).map(SymbolImpl::getTypeSymbolFromExpression).map(Symbol::fullyQualifiedName).orElse(null);
    }

    @Override
    public String annotatedReturnTypeName() {
        return this.annotatedReturnTypeName;
    }

    public void setDeclaredReturnType(InferredType declaredReturnType) {
        this.declaredReturnType = declaredReturnType;
    }

    public Symbol owner() {
        return this.owner;
    }

    public void setOwner(Symbol owner) {
        this.owner = owner;
    }

    public boolean isDjangoView() {
        return this.isDjangoView;
    }

    public void setIsDjangoView(boolean isDjangoView) {
        this.isDjangoView = isDjangoView;
    }

    public static class ParameterImpl
    implements FunctionSymbol.Parameter {
        private final String name;
        private InferredType declaredType;
        private SymbolsProtos.Type protobufType;
        private final String annotatedTypeName;
        private final boolean hasDefaultValue;
        private final boolean isKeywordVariadic;
        private final boolean isPositionalVariadic;
        private final boolean isKeywordOnly;
        private final boolean isPositionalOnly;
        private final LocationInFile location;
        private boolean hasReadDeclaredType = false;

        ParameterImpl(@Nullable String name, InferredType declaredType, @Nullable String annotatedTypeName, boolean hasDefaultValue, ParameterState parameterState, boolean isKeywordVariadic, boolean isPositionalVariadic, @Nullable SymbolsProtos.Type protobufType, @Nullable LocationInFile location) {
            this.name = name;
            this.declaredType = declaredType;
            this.hasDefaultValue = hasDefaultValue;
            this.isKeywordVariadic = isKeywordVariadic;
            this.isPositionalVariadic = isPositionalVariadic;
            this.isKeywordOnly = parameterState.keywordOnly;
            this.isPositionalOnly = parameterState.positionalOnly;
            this.location = location;
            this.protobufType = protobufType;
            this.annotatedTypeName = annotatedTypeName;
        }

        public ParameterImpl(FunctionDescriptor.Parameter parameterDescriptor) {
            this.name = parameterDescriptor.name();
            this.hasDefaultValue = parameterDescriptor.hasDefaultValue();
            this.isPositionalVariadic = parameterDescriptor.isPositionalVariadic();
            this.isKeywordVariadic = parameterDescriptor.isKeywordVariadic();
            this.isKeywordOnly = parameterDescriptor.isKeywordOnly();
            this.isPositionalOnly = parameterDescriptor.isPositionalOnly();
            this.location = parameterDescriptor.location();
            this.annotatedTypeName = parameterDescriptor.annotatedType();
        }

        @Override
        @CheckForNull
        public String name() {
            return this.name;
        }

        @Override
        public InferredType declaredType() {
            if (!this.hasReadDeclaredType && this.protobufType != null) {
                this.declaredType = InferredTypes.fromTypeshedProtobuf(this.protobufType);
                this.hasReadDeclaredType = true;
            }
            return this.declaredType;
        }

        public void setDeclaredType(InferredType type) {
            this.declaredType = type;
        }

        @CheckForNull
        public String annotatedTypeName() {
            return this.annotatedTypeName;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.hasDefaultValue;
        }

        @Override
        public boolean isVariadic() {
            return this.isKeywordVariadic || this.isPositionalVariadic;
        }

        @Override
        public boolean isKeywordOnly() {
            return this.isKeywordOnly;
        }

        @Override
        public boolean isPositionalOnly() {
            return this.isPositionalOnly;
        }

        @Override
        public boolean isKeywordVariadic() {
            return this.isKeywordVariadic;
        }

        @Override
        public boolean isPositionalVariadic() {
            return this.isPositionalVariadic;
        }

        @Override
        @CheckForNull
        public LocationInFile location() {
            return this.location;
        }
    }

    static class ParameterType {
        InferredType inferredType;
        boolean isPositionalVariadic;
        boolean isKeywordVariadic;

        public ParameterType(InferredType inferredType, boolean isKeywordVariadic, boolean isPositionalVariadic) {
            this.inferredType = inferredType;
            this.isKeywordVariadic = isKeywordVariadic;
            this.isPositionalVariadic = isPositionalVariadic;
        }
    }

    private static class ParameterState {
        boolean keywordOnly = false;
        boolean positionalOnly = false;

        private ParameterState() {
        }
    }
}

