/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.RuntimeType;
import org.sonar.python.types.TypeShed;

public class DeclaredType
implements InferredType {
    private Symbol typeClass;
    private final List<DeclaredType> typeArgs;
    private Set<Symbol> alternativeTypeSymbols;
    private String builtinFullyQualifiedName;

    public DeclaredType(Symbol typeClass, List<DeclaredType> typeArgs) {
        this.typeClass = typeClass;
        this.typeArgs = typeArgs;
        this.alternativeTypeSymbols = DeclaredType.resolveAlternativeSymbols(typeClass, typeArgs);
    }

    private static Set<Symbol> resolveAlternativeSymbols(Symbol typeClass, List<DeclaredType> typeArgs) {
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        if ("typing.Optional".equals(typeClass.fullyQualifiedName()) && typeArgs.size() == 1) {
            ClassSymbol noneType = TypeShed.typeShedClass("NoneType");
            symbols.add(noneType);
            DeclaredType argType = typeArgs.get(0);
            symbols.addAll(DeclaredType.resolveAlternativeSymbols(argType.getTypeClass(), argType.typeArgs));
        } else if ("typing.Union".equals(typeClass.fullyQualifiedName())) {
            symbols.addAll(typeArgs.stream().flatMap(arg -> DeclaredType.resolveAlternativeSymbols(arg.getTypeClass(), arg.typeArgs).stream()).collect(Collectors.toSet()));
        } else if ("typing.Text".equals(typeClass.fullyQualifiedName())) {
            symbols.add(TypeShed.typeShedClass("str"));
        } else {
            symbols.add(typeClass);
        }
        return symbols;
    }

    DeclaredType(Symbol typeClass) {
        this(typeClass, Collections.emptyList());
    }

    DeclaredType(String builtinFullyQualifiedName) {
        this.builtinFullyQualifiedName = builtinFullyQualifiedName;
        this.typeArgs = Collections.emptyList();
    }

    @Override
    public boolean canHaveMember(String memberName) {
        return true;
    }

    @Override
    public boolean declaresMember(String memberName) {
        if (this.hasUnresolvedHierarchy()) {
            return true;
        }
        return this.alternativeTypeSymbols().stream().anyMatch(symbol -> !symbol.is(Symbol.Kind.CLASS) || ((ClassSymbol)symbol).canHaveMember(memberName));
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        return true;
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        return Optional.empty();
    }

    @Override
    public Optional<Symbol> resolveDeclaredMember(String memberName) {
        if (this.hasUnresolvedHierarchy()) {
            return Optional.empty();
        }
        Set resolvedMembers = this.alternativeTypeSymbols().stream().filter(s -> s.is(Symbol.Kind.CLASS)).map(ClassSymbol.class::cast).map(t -> t.resolveMember(memberName)).filter(Optional::isPresent).collect(Collectors.toSet());
        return resolvedMembers.size() == 1 ? (Optional)resolvedMembers.iterator().next() : Optional.empty();
    }

    @Override
    public boolean canBeOrExtend(String typeName) {
        return true;
    }

    @Override
    public boolean canOnlyBe(String typeName) {
        return false;
    }

    @Override
    public boolean isCompatibleWith(InferredType other) {
        if (this.alternativeTypeSymbols().isEmpty()) {
            return true;
        }
        return this.alternativeTypeSymbols().stream().anyMatch(typeSymbol -> InferredTypes.isTypeClassCompatibleWith(typeSymbol, other));
    }

    @Override
    public boolean mustBeOrExtend(String typeName) {
        List classSymbols = this.alternativeTypeSymbols().stream().flatMap(a -> {
            if (a.is(Symbol.Kind.AMBIGUOUS)) {
                return ((AmbiguousSymbol)a).alternatives().stream().filter(alternative -> alternative.is(Symbol.Kind.CLASS));
            }
            return Stream.of(a);
        }).filter(a -> a.is(Symbol.Kind.CLASS)).collect(Collectors.toList());
        return !classSymbols.isEmpty() && classSymbols.stream().allMatch(a -> ((ClassSymbol)a).isOrExtends(typeName));
    }

    public String toString() {
        return "DeclaredType(" + this.typeName() + ')';
    }

    public String typeName() {
        StringBuilder str = new StringBuilder(this.getTypeClass().name());
        if (!this.typeArgs.isEmpty()) {
            str.append("[");
            str.append(this.typeArgs.stream().map(DeclaredType::typeName).collect(Collectors.joining(", ")));
            str.append("]");
        }
        return str.toString();
    }

    public Symbol getTypeClass() {
        if (this.typeClass == null) {
            return TypeShed.typeShedClass(this.builtinFullyQualifiedName);
        }
        return this.typeClass;
    }

    public Set<Symbol> alternativeTypeSymbols() {
        if (this.alternativeTypeSymbols == null) {
            return DeclaredType.resolveAlternativeSymbols(this.getTypeClass(), this.typeArgs);
        }
        return this.alternativeTypeSymbols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeclaredType that = (DeclaredType)o;
        return Objects.equals(this.getTypeClass().name(), that.getTypeClass().name()) && Objects.equals(this.getTypeClass().fullyQualifiedName(), that.getTypeClass().fullyQualifiedName()) && Objects.equals(this.typeArgs, that.typeArgs);
    }

    public int hashCode() {
        return Objects.hash(this.getTypeClass().name(), this.getTypeClass().fullyQualifiedName(), this.typeArgs);
    }

    public static InferredType fromInferredType(InferredType inferredType) {
        if (inferredType instanceof RuntimeType) {
            ClassSymbol typeClass = ((RuntimeType)inferredType).getTypeClass();
            return new DeclaredType(typeClass);
        }
        if (inferredType instanceof DeclaredType) {
            return inferredType;
        }
        return InferredTypes.anyType();
    }

    boolean hasUnresolvedHierarchy() {
        if (this.alternativeTypeSymbols().isEmpty()) {
            return true;
        }
        for (Symbol alternativeTypeSymbol : this.alternativeTypeSymbols()) {
            if (alternativeTypeSymbol.is(Symbol.Kind.CLASS) && !((ClassSymbol)alternativeTypeSymbol).hasUnresolvedTypeHierarchy()) continue;
            return true;
        }
        return false;
    }
}

