/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.CaseBlock;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FinallyClause;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Guard;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.MatchStatement;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Pattern;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.cfg.PythonCfgBlock;
import org.sonar.python.cfg.PythonCfgBranchingBlock;
import org.sonar.python.cfg.PythonCfgEndBlock;
import org.sonar.python.cfg.PythonCfgSimpleBlock;
import org.sonar.python.tree.TreeUtils;

public class ControlFlowGraphBuilder {
    private PythonCfgBlock start;
    private final PythonCfgBlock end = new PythonCfgEndBlock();
    private final Set<PythonCfgBlock> blocks = new LinkedHashSet<PythonCfgBlock>();
    private final Deque<Loop> loops = new ArrayDeque<Loop>();
    private final Deque<PythonCfgBlock> exceptionTargets = new ArrayDeque<PythonCfgBlock>();
    private final Deque<PythonCfgBlock> exitTargets = new ArrayDeque<PythonCfgBlock>();

    public ControlFlowGraphBuilder(@Nullable StatementList statementList) {
        this.blocks.add(this.end);
        this.exceptionTargets.push(this.end);
        this.exitTargets.push(this.end);
        if (statementList != null) {
            this.start = this.build(statementList.statements(), (PythonCfgBlock)this.createSimpleBlock(this.end));
            this.addParametersToStartBlock(statementList);
        } else {
            this.start = this.end;
        }
        this.removeEmptyBlocks();
        this.computePredecessors();
    }

    private void addParametersToStartBlock(StatementList statementList) {
        ParameterList parameterList;
        if (statementList.parent().is(Tree.Kind.FUNCDEF) && (parameterList = ((FunctionDef)statementList.parent()).parameters()) != null) {
            PythonCfgSimpleBlock parametersBlock = this.createSimpleBlock(this.start);
            ControlFlowGraphBuilder.addParameters(parameterList.all(), parametersBlock);
            this.start = parametersBlock;
        }
    }

    private static void addParameters(List<AnyParameter> parameters, PythonCfgSimpleBlock parametersBlock) {
        for (AnyParameter parameter : parameters) {
            if (parameter.is(Tree.Kind.TUPLE_PARAMETER)) {
                ControlFlowGraphBuilder.addParameters(((TupleParameter)parameter).parameters(), parametersBlock);
                continue;
            }
            parametersBlock.addElement(parameter);
        }
    }

    private void computePredecessors() {
        for (PythonCfgBlock block : this.blocks) {
            for (CfgBlock successor : block.successors()) {
                ((PythonCfgBlock)successor).addPredecessor(block);
            }
        }
    }

    private void removeEmptyBlocks() {
        HashMap<PythonCfgBlock, PythonCfgBlock> emptyBlockReplacements = new HashMap<PythonCfgBlock, PythonCfgBlock>();
        for (PythonCfgBlock block : this.blocks) {
            if (!block.isEmptyBlock()) continue;
            PythonCfgBlock firstNonEmptySuccessor = block.firstNonEmptySuccessor();
            emptyBlockReplacements.put(block, firstNonEmptySuccessor);
        }
        this.blocks.removeAll(emptyBlockReplacements.keySet());
        for (PythonCfgBlock block : this.blocks) {
            block.replaceSuccessors(emptyBlockReplacements);
        }
        this.start = emptyBlockReplacements.getOrDefault(this.start, this.start);
    }

    public ControlFlowGraph getCfg() {
        return new ControlFlowGraph(Collections.unmodifiableSet(this.blocks), this.start, this.end);
    }

    private PythonCfgSimpleBlock createSimpleBlock(CfgBlock successor) {
        PythonCfgSimpleBlock block = new PythonCfgSimpleBlock(successor);
        this.blocks.add(block);
        return block;
    }

    private PythonCfgBranchingBlock createBranchingBlock(Tree branchingTree, CfgBlock trueSuccessor, CfgBlock falseSuccessor) {
        PythonCfgBranchingBlock block = new PythonCfgBranchingBlock(branchingTree, trueSuccessor, falseSuccessor);
        this.blocks.add(block);
        return block;
    }

    private PythonCfgBranchingBlock createBranchingBlock(Tree branchingTree, CfgBlock falseSuccessor) {
        PythonCfgBranchingBlock block = new PythonCfgBranchingBlock(branchingTree, null, falseSuccessor);
        this.blocks.add(block);
        return block;
    }

    private PythonCfgBlock build(List<Statement> statements, PythonCfgBlock successor) {
        PythonCfgBlock currentBlock = successor;
        for (int i = statements.size() - 1; i >= 0; --i) {
            Statement statement = statements.get(i);
            currentBlock = this.build(statement, currentBlock);
        }
        return currentBlock;
    }

    private PythonCfgBlock build(Statement statement, PythonCfgBlock currentBlock) {
        switch (statement.getKind()) {
            case WITH_STMT: {
                return this.buildWithStatement((WithStatement)statement, currentBlock);
            }
            case CLASSDEF: {
                ClassDef classDef = (ClassDef)statement;
                PythonCfgBlock block = this.build(classDef.body().statements(), currentBlock);
                block.addElement(classDef.name());
                return block;
            }
            case RETURN_STMT: {
                return this.buildReturnStatement((ReturnStatement)statement, currentBlock);
            }
            case RAISE_STMT: {
                return this.buildRaiseStatement((RaiseStatement)statement, currentBlock);
            }
            case IF_STMT: {
                return this.buildIfStatement((IfStatement)statement, currentBlock);
            }
            case WHILE_STMT: {
                return this.buildWhileStatement((WhileStatement)statement, currentBlock);
            }
            case FOR_STMT: {
                return this.buildForStatement((ForStatement)statement, currentBlock);
            }
            case CONTINUE_STMT: {
                return this.buildContinueStatement((ContinueStatement)statement, currentBlock);
            }
            case TRY_STMT: {
                return this.tryStatement((TryStatement)statement, currentBlock);
            }
            case BREAK_STMT: {
                return this.buildBreakStatement((BreakStatement)statement, currentBlock);
            }
            case MATCH_STMT: {
                return this.buildMatchStatement((MatchStatement)statement, currentBlock);
            }
        }
        currentBlock.addElement(statement);
        return currentBlock;
    }

    private PythonCfgBlock buildMatchStatement(MatchStatement statement, PythonCfgBlock successor) {
        List<CaseBlock> caseBlocks = statement.caseBlocks();
        PythonCfgBranchingBlock matchingBlock = null;
        PythonCfgBlock falseSuccessor = successor;
        for (int i = caseBlocks.size() - 1; i >= 0; --i) {
            PythonCfgBlock caseBodyBlock = this.createSimpleBlock(successor);
            CaseBlock caseBlock = caseBlocks.get(i);
            Pattern pattern = caseBlock.pattern();
            Guard guard = caseBlock.guard();
            caseBodyBlock = this.build(caseBlock.body().statements(), caseBodyBlock);
            matchingBlock = this.createBranchingBlock(pattern, caseBodyBlock, falseSuccessor);
            if (guard != null) {
                matchingBlock.addElement(guard.condition());
            }
            matchingBlock.addElement(pattern);
            matchingBlock.addElement(statement.subjectExpression());
            this.blocks.add(matchingBlock);
            falseSuccessor = matchingBlock;
        }
        return matchingBlock;
    }

    private PythonCfgBlock buildWithStatement(WithStatement withStatement, PythonCfgBlock successor) {
        PythonCfgBlock withBodyBlock = this.build(withStatement.statements().statements(), (PythonCfgBlock)this.createSimpleBlock(successor));
        PythonCfgBranchingBlock branchingBlock = this.createBranchingBlock(withStatement, withBodyBlock, successor);
        for (int i = withStatement.withItems().size() - 1; i >= 0; --i) {
            branchingBlock.addElement(withStatement.withItems().get(i));
        }
        return branchingBlock;
    }

    private PythonCfgBlock tryStatement(TryStatement tryStatement, PythonCfgBlock successor) {
        PythonCfgBlock finallyOrAfterTryBlock = successor;
        FinallyClause finallyClause = tryStatement.finallyClause();
        PythonCfgBlock finallyBlock = null;
        if (finallyClause != null) {
            finallyBlock = finallyOrAfterTryBlock = this.build(finallyClause.body().statements(), (PythonCfgBlock)this.createBranchingBlock(finallyClause, successor, this.exitTargets.peek()));
            this.exitTargets.push(finallyBlock);
            this.loops.push(new Loop(finallyBlock, finallyBlock));
        }
        PythonCfgBlock firstExceptClauseBlock = this.exceptClauses(tryStatement, finallyOrAfterTryBlock, finallyBlock);
        ElseClause elseClause = tryStatement.elseClause();
        PythonCfgBlock tryBlockSuccessor = finallyOrAfterTryBlock;
        if (elseClause != null) {
            tryBlockSuccessor = this.build(elseClause.body().statements(), (PythonCfgBlock)this.createSimpleBlock(finallyOrAfterTryBlock));
        }
        if (finallyClause != null) {
            this.exitTargets.pop();
            this.loops.pop();
        }
        this.exceptionTargets.push(firstExceptClauseBlock);
        this.exitTargets.push(firstExceptClauseBlock);
        this.loops.push(new Loop(firstExceptClauseBlock, firstExceptClauseBlock));
        PythonCfgBlock firstTryBlock = this.build(tryStatement.body().statements(), (PythonCfgBlock)this.createBranchingBlock(tryStatement, tryBlockSuccessor, firstExceptClauseBlock));
        this.exceptionTargets.pop();
        this.exitTargets.pop();
        this.loops.pop();
        return this.createSimpleBlock(firstTryBlock);
    }

    private PythonCfgBlock exceptClauses(TryStatement tryStatement, PythonCfgBlock finallyOrAfterTryBlock, @Nullable PythonCfgBlock finallyBlock) {
        PythonCfgBlock falseSuccessor = finallyBlock == null ? this.exceptionTargets.peek() : finallyBlock;
        List<ExceptClause> exceptClauses = tryStatement.exceptClauses();
        for (int i = exceptClauses.size() - 1; i >= 0; --i) {
            Expression exception;
            ExceptClause exceptClause = exceptClauses.get(i);
            PythonCfgBlock exceptBlock = this.build(exceptClause.body().statements(), (PythonCfgBlock)this.createSimpleBlock(finallyOrAfterTryBlock));
            PythonCfgBranchingBlock exceptCondition = this.createBranchingBlock(exceptClause, exceptBlock, falseSuccessor);
            Expression exceptionInstance = exceptClause.exceptionInstance();
            if (exceptionInstance != null) {
                exceptCondition.addElement(exceptionInstance);
            }
            if ((exception = exceptClause.exception()) != null) {
                exceptCondition.addElement(exception);
            }
            falseSuccessor = exceptCondition;
        }
        return falseSuccessor;
    }

    private Loop currentLoop(Tree tree) {
        Loop loop = this.loops.peek();
        if (loop == null) {
            Token token = tree.firstToken();
            throw new IllegalStateException("Invalid \"" + token.value() + "\" outside loop at line " + token.line());
        }
        return loop;
    }

    private PythonCfgBlock buildBreakStatement(BreakStatement breakStatement, PythonCfgBlock syntacticSuccessor) {
        PythonCfgSimpleBlock block = this.createSimpleBlock(this.currentLoop((Tree)breakStatement).breakTarget);
        block.setSyntacticSuccessor(syntacticSuccessor);
        block.addElement(breakStatement);
        return block;
    }

    private PythonCfgBlock buildContinueStatement(ContinueStatement continueStatement, PythonCfgBlock syntacticSuccessor) {
        PythonCfgSimpleBlock block = this.createSimpleBlock(this.currentLoop((Tree)continueStatement).continueTarget);
        block.setSyntacticSuccessor(syntacticSuccessor);
        block.addElement(continueStatement);
        return block;
    }

    private PythonCfgBlock buildLoop(Tree branchingTree, List<Expression> conditionElements, StatementList body, @Nullable ElseClause elseClause, PythonCfgBlock successor) {
        PythonCfgBlock afterLoopBlock = successor;
        if (elseClause != null) {
            afterLoopBlock = this.build(elseClause.body().statements(), (PythonCfgBlock)this.createSimpleBlock(successor));
        }
        PythonCfgBranchingBlock conditionBlock = this.createBranchingBlock(branchingTree, afterLoopBlock);
        conditionElements.forEach(conditionBlock::addElement);
        this.loops.push(new Loop(successor, conditionBlock));
        PythonCfgBlock loopBodyBlock = this.build(body.statements(), (PythonCfgBlock)this.createSimpleBlock(conditionBlock));
        this.loops.pop();
        conditionBlock.setTrueSuccessor(loopBodyBlock);
        return this.createSimpleBlock(conditionBlock);
    }

    private PythonCfgBlock buildForStatement(ForStatement forStatement, PythonCfgBlock successor) {
        PythonCfgBlock beforeForStmt = this.buildLoop(forStatement, forStatement.expressions(), forStatement.body(), forStatement.elseClause(), successor);
        forStatement.testExpressions().forEach(beforeForStmt::addElement);
        return beforeForStmt;
    }

    private PythonCfgBlock buildWhileStatement(WhileStatement whileStatement, PythonCfgBlock currentBlock) {
        return this.buildLoop(whileStatement, Collections.singletonList(whileStatement.condition()), whileStatement.body(), whileStatement.elseClause(), currentBlock);
    }

    private PythonCfgBlock buildIfStatement(IfStatement ifStatement, PythonCfgBlock afterBlock) {
        PythonCfgBlock ifBodyBlock = this.createSimpleBlock(afterBlock);
        ifBodyBlock = this.build(ifStatement.body().statements(), ifBodyBlock);
        ElseClause elseClause = ifStatement.elseBranch();
        PythonCfgBlock falseSuccessor = afterBlock;
        if (elseClause != null) {
            PythonCfgBlock elseBodyBlock = this.createSimpleBlock(afterBlock);
            elseBodyBlock = this.build(elseClause.body().statements(), elseBodyBlock);
            falseSuccessor = elseBodyBlock;
        }
        falseSuccessor = this.buildElifClauses(afterBlock, falseSuccessor, ifStatement.elifBranches());
        PythonCfgBranchingBlock beforeIfBlock = this.createBranchingBlock(ifStatement, ifBodyBlock, falseSuccessor);
        beforeIfBlock.addElement(ifStatement.condition());
        return beforeIfBlock;
    }

    private PythonCfgBlock buildElifClauses(PythonCfgBlock currentBlock, PythonCfgBlock falseSuccessor, List<IfStatement> elifBranches) {
        for (int i = elifBranches.size() - 1; i >= 0; --i) {
            IfStatement elifStatement = elifBranches.get(i);
            PythonCfgBlock elifBodyBlock = this.createSimpleBlock(currentBlock);
            elifBodyBlock = this.build(elifStatement.body().statements(), elifBodyBlock);
            PythonCfgBranchingBlock beforeElifBlock = this.createBranchingBlock(elifStatement, elifBodyBlock, falseSuccessor);
            beforeElifBlock.addElement(elifStatement.condition());
            falseSuccessor = beforeElifBlock;
        }
        return falseSuccessor;
    }

    private PythonCfgBlock buildReturnStatement(ReturnStatement statement, PythonCfgBlock syntacticSuccessor) {
        if (TreeUtils.firstAncestorOfKind(statement, Tree.Kind.FUNCDEF) == null || ControlFlowGraphBuilder.isStatementAtClassLevel(statement)) {
            throw new IllegalStateException("Invalid return outside of a function");
        }
        PythonCfgSimpleBlock block = this.createSimpleBlock(this.exitTargets.peek());
        block.setSyntacticSuccessor(syntacticSuccessor);
        block.addElement(statement);
        return block;
    }

    private static boolean isStatementAtClassLevel(ReturnStatement statement) {
        return statement.parent().parent().is(Tree.Kind.CLASSDEF);
    }

    private PythonCfgBlock buildRaiseStatement(RaiseStatement statement, PythonCfgBlock syntacticSuccessor) {
        PythonCfgSimpleBlock block = this.createSimpleBlock(this.exceptionTargets.peek());
        block.setSyntacticSuccessor(syntacticSuccessor);
        block.addElement(statement);
        return block;
    }

    private static class Loop {
        final PythonCfgBlock breakTarget;
        final PythonCfgBlock continueTarget;

        private Loop(PythonCfgBlock breakTarget, PythonCfgBlock continueTarget) {
            this.breakTarget = breakTarget;
            this.continueTarget = continueTarget;
        }
    }
}

