/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.quickfix;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public class PythonTextEdit {
    private final String message;
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;

    public PythonTextEdit(String message, int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this.message = message;
        this.startLine = startLine;
        this.startLineOffset = startLineOffset;
        this.endLine = endLine;
        this.endLineOffset = endLineOffset;
    }

    public static PythonTextEdit insertLineBefore(Tree tree, String textToInsert) {
        String lineOffset = " ".repeat(tree.firstToken().column());
        String textWithOffset = textToInsert.replace("\n", "\n" + lineOffset);
        return PythonTextEdit.insertBefore(tree, textWithOffset);
    }

    public static PythonTextEdit insertBefore(Tree tree, String textToInsert) {
        Token token = tree.firstToken();
        return PythonTextEdit.insertAtPosition(token.line(), token.column(), textToInsert);
    }

    public static PythonTextEdit insertAfter(Tree tree, String textToInsert) {
        Token token = tree.firstToken();
        int lengthToken = token.value().length();
        return PythonTextEdit.insertAtPosition(token.line(), token.column() + lengthToken, textToInsert);
    }

    private static PythonTextEdit insertAtPosition(int line, int column, String textToInsert) {
        return new PythonTextEdit(textToInsert, line, column, line, column);
    }

    public static PythonTextEdit replace(Tree toReplace, String replacementText) {
        return PythonTextEdit.replaceRange(toReplace, toReplace, replacementText);
    }

    public static PythonTextEdit replaceRange(Tree start, Tree end, String replacementText) {
        Token first = start.firstToken();
        Token last = end.lastToken();
        return new PythonTextEdit(replacementText, first.line(), first.column(), last.line(), last.column() + last.value().length());
    }

    public static List<PythonTextEdit> shiftLeft(StatementList statementList) {
        int offset = statementList.firstToken().column() - statementList.parent().firstToken().column();
        return statementList.statements().stream().map(statement -> PythonTextEdit.shiftLeft(statement, offset)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private static List<PythonTextEdit> shiftLeft(Tree tree, int offset) {
        return TreeUtils.tokens(tree).stream().filter(token -> token.column() >= offset).map(Token::line).distinct().map(line -> PythonTextEdit.removeRange(line, 0, line, offset)).collect(Collectors.toList());
    }

    public static PythonTextEdit removeRange(int startLine, int startColumn, int endLine, int endColumn) {
        return new PythonTextEdit("", startLine, startColumn, endLine, endColumn);
    }

    public static PythonTextEdit removeUntil(Tree start, Tree until) {
        return PythonTextEdit.removeRange(start.firstToken().line(), start.firstToken().column(), until.firstToken().line(), until.firstToken().column());
    }

    public static PythonTextEdit remove(Tree toRemove) {
        return PythonTextEdit.replace(toRemove, "");
    }

    public String replacementText() {
        return this.message;
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonTextEdit that = (PythonTextEdit)o;
        return this.startLine == that.startLine && this.startLineOffset == that.startLineOffset && this.endLine == that.endLine && this.endLineOffset == that.endLineOffset && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.startLine, this.startLineOffset, this.endLine, this.endLineOffset);
    }
}

