/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.FinallyClause;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.tree.PyTree;

public class TryStatementImpl
extends PyTree
implements TryStatement {
    private final Token tryKeyword;
    private final Token colon;
    private final Token newLine;
    private final Token indent;
    private final StatementList tryBody;
    private final Token dedent;
    private final List<ExceptClause> exceptClauses;
    private final FinallyClause finallyClause;
    private final ElseClause elseClause;

    public TryStatementImpl(Token tryKeyword, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList tryBody, @Nullable Token dedent, List<ExceptClause> exceptClauses, @Nullable FinallyClause finallyClause, @Nullable ElseClause elseClause) {
        this.tryKeyword = tryKeyword;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.tryBody = tryBody;
        this.dedent = dedent;
        this.exceptClauses = exceptClauses;
        this.finallyClause = finallyClause;
        this.elseClause = elseClause;
    }

    @Override
    public Token tryKeyword() {
        return this.tryKeyword;
    }

    @Override
    public List<ExceptClause> exceptClauses() {
        return this.exceptClauses;
    }

    @Override
    @CheckForNull
    public FinallyClause finallyClause() {
        return this.finallyClause;
    }

    @Override
    @CheckForNull
    public ElseClause elseClause() {
        return this.elseClause;
    }

    @Override
    public StatementList body() {
        return this.tryBody;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.tryKeyword, this.colon, this.newLine, this.indent, this.tryBody, this.dedent), this.exceptClauses, Arrays.asList(this.elseClause, this.finallyClause)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

