/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class TypeShed {
    private static Map<String, Symbol> builtins;
    private static final Map<String, Map<String, Symbol>> typeShedSymbols;
    private static final Map<String, Set<Symbol>> builtinGlobalSymbols;
    private static final Set<String> modulesInProgress;
    private static final String PROTOBUF_CUSTOM_STUBS = "custom_protobuf/";
    private static final String PROTOBUF = "stdlib_protobuf/";
    private static final String PROTOBUF_THIRD_PARTY = "third_party_protobuf/";
    private static final String BUILTINS_FQN = "builtins";
    private static final String BUILTINS_PREFIX = "builtins.";
    private static final Set<String> BUILTINS_TO_DISAMBIGUATE;
    private static final Map<String, String> MODULES_TO_DISAMBIGUATE;
    private static final Logger LOG;
    private static Set<String> supportedPythonVersions;

    private TypeShed() {
    }

    public static Map<String, Symbol> builtinSymbols() {
        if (builtins == null) {
            supportedPythonVersions = ProjectPythonVersion.currentVersions().stream().map(PythonVersionUtils.Version::serializedValue).collect(Collectors.toSet());
            Map<String, Symbol> builtins = TypeShed.getSymbolsFromProtobufModule(BUILTINS_FQN, PROTOBUF);
            builtins.put("NoneType", new ClassSymbolImpl("NoneType", "NoneType"));
            TypeShed.builtins = Collections.unmodifiableMap(builtins);
            builtinGlobalSymbols.put("", new HashSet<Symbol>(builtins.values()));
        }
        return builtins;
    }

    public static ClassSymbol typeShedClass(String fullyQualifiedName) {
        Symbol symbol = TypeShed.builtinSymbols().get(fullyQualifiedName);
        if (symbol == null) {
            throw new IllegalArgumentException("No TypeShed symbol found for name: " + fullyQualifiedName);
        }
        if (symbol.kind() != Symbol.Kind.CLASS) {
            throw new IllegalArgumentException("TypeShed symbol " + fullyQualifiedName + " is not a class");
        }
        return (ClassSymbol)symbol;
    }

    public static Map<String, Symbol> symbolsForModule(String moduleName) {
        if (!typeShedSymbols.containsKey(moduleName)) {
            Map<String, Symbol> symbols = TypeShed.searchTypeShedForModule(moduleName);
            typeShedSymbols.put(moduleName, symbols);
            return symbols;
        }
        return typeShedSymbols.get(moduleName);
    }

    @CheckForNull
    public static Symbol symbolWithFQN(String stdLibModuleName, String fullyQualifiedName) {
        Map<String, Symbol> symbols = TypeShed.symbolsForModule(stdLibModuleName);
        Symbol symbolByFqn = symbols.values().stream().filter(s -> fullyQualifiedName.equals(s.fullyQualifiedName())).findFirst().orElse(null);
        if (symbolByFqn != null || !fullyQualifiedName.contains(".")) {
            return symbolByFqn;
        }
        String[] fqnSplittedByDot = fullyQualifiedName.split("\\.");
        String symbolLocalNameFromFqn = fqnSplittedByDot[fqnSplittedByDot.length - 1];
        return symbols.get(symbolLocalNameFromFqn);
    }

    @CheckForNull
    public static Symbol symbolWithFQN(String fullyQualifiedName) {
        Map<String, Symbol> builtinSymbols = TypeShed.builtinSymbols();
        Symbol builtinSymbol = builtinSymbols.get(TypeShed.normalizedFqn(fullyQualifiedName));
        if (builtinSymbol != null) {
            return builtinSymbol;
        }
        String[] fqnSplittedByDot = fullyQualifiedName.split("\\.");
        String moduleName = Arrays.stream(fqnSplittedByDot, 0, fqnSplittedByDot.length - 1).collect(Collectors.joining("."));
        return TypeShed.symbolWithFQN(moduleName, fullyQualifiedName);
    }

    public static Collection<Symbol> stubFilesSymbols() {
        HashSet<Symbol> symbols = new HashSet<Symbol>(TypeShed.builtinSymbols().values());
        for (Map<String, Symbol> symbolsByFqn : typeShedSymbols.values()) {
            Iterator<Symbol> iterator = symbolsByFqn.values().iterator();
            while (iterator.hasNext()) {
                Symbol disambiguatedSymbol;
                Symbol symbol;
                Symbol stubSymbol = symbol = iterator.next();
                if (TypeShed.isAmbiguousSymbolOfClasses(symbol) && (disambiguatedSymbol = TypeShed.disambiguateWithLatestPythonSymbol(((AmbiguousSymbol)symbol).alternatives())) != null) {
                    stubSymbol = disambiguatedSymbol;
                }
                symbols.add(stubSymbol);
            }
        }
        return symbols;
    }

    public static String normalizedFqn(String fqn) {
        if (fqn.startsWith(BUILTINS_PREFIX)) {
            return fqn.substring(BUILTINS_PREFIX.length());
        }
        return fqn;
    }

    public static String normalizedFqn(String fqn, String moduleName, String localName) {
        return TypeShed.normalizedFqn(fqn, moduleName, localName, null);
    }

    public static String normalizedFqn(String fqn, String moduleName, String localName, @Nullable String containerClassFqn) {
        if (containerClassFqn != null) {
            return containerClassFqn + "." + localName;
        }
        if (fqn.startsWith(moduleName)) {
            return TypeShed.normalizedFqn(fqn);
        }
        return moduleName + "." + localName;
    }

    public static boolean isValidForProjectPythonVersion(List<String> validForPythonVersions) {
        if (validForPythonVersions.isEmpty()) {
            return true;
        }
        HashSet<String> intersection = new HashSet<String>(validForPythonVersions);
        intersection.retainAll(supportedPythonVersions);
        return !intersection.isEmpty();
    }

    public static Set<Symbol> symbolsFromProtobufDescriptors(Set<Object> protobufDescriptors, @Nullable String containerClassFqn, String moduleName, boolean isFromClass) {
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        for (Object descriptor : protobufDescriptors) {
            if (descriptor instanceof SymbolsProtos.ClassSymbol) {
                symbols.add(new ClassSymbolImpl((SymbolsProtos.ClassSymbol)descriptor, moduleName));
            }
            if (descriptor instanceof SymbolsProtos.FunctionSymbol) {
                symbols.add(new FunctionSymbolImpl((SymbolsProtos.FunctionSymbol)descriptor, containerClassFqn, moduleName));
            }
            if (descriptor instanceof SymbolsProtos.OverloadedFunctionSymbol) {
                if (((SymbolsProtos.OverloadedFunctionSymbol)descriptor).getDefinitionsList().size() < 2) {
                    throw new IllegalStateException("Overloaded function symbols should have at least two definitions.");
                }
                symbols.add(TypeShed.fromOverloadedFunction((SymbolsProtos.OverloadedFunctionSymbol)descriptor, containerClassFqn, moduleName));
            }
            if (!(descriptor instanceof SymbolsProtos.VarSymbol)) continue;
            SymbolsProtos.VarSymbol varSymbol = (SymbolsProtos.VarSymbol)descriptor;
            SymbolImpl symbol = new SymbolImpl(varSymbol, moduleName, isFromClass);
            if (varSymbol.getIsImportedModule()) {
                Map<String, Symbol> moduleExportedSymbols = TypeShed.symbolsForModule(varSymbol.getFullyQualifiedName());
                moduleExportedSymbols.values().forEach(symbol::addChildSymbol);
            }
            symbols.add(symbol);
        }
        return symbols;
    }

    @CheckForNull
    public static SymbolsProtos.ClassSymbol classDescriptorWithFQN(String fullyQualifiedName) {
        String[] fqnSplitByDot = fullyQualifiedName.split("\\.");
        String symbolLocalNameFromFqn = fqnSplitByDot[fqnSplitByDot.length - 1];
        String moduleName = Arrays.stream(fqnSplitByDot, 0, fqnSplitByDot.length - 1).collect(Collectors.joining("."));
        InputStream resource = TypeShed.class.getResourceAsStream(PROTOBUF + moduleName + ".protobuf");
        if (resource == null) {
            return null;
        }
        SymbolsProtos.ModuleSymbol moduleSymbol = TypeShed.deserializedModule(moduleName, resource);
        if (moduleSymbol == null) {
            return null;
        }
        for (SymbolsProtos.ClassSymbol classSymbol : moduleSymbol.getClassesList()) {
            if (!classSymbol.getName().equals(symbolLocalNameFromFqn)) continue;
            return classSymbol;
        }
        return null;
    }

    static void resetBuiltinSymbols() {
        builtins = null;
        typeShedSymbols.clear();
        TypeShed.builtinSymbols();
    }

    private static Map<String, Symbol> searchTypeShedForModule(String moduleName) {
        if (modulesInProgress.contains(moduleName)) {
            return new HashMap<String, Symbol>();
        }
        modulesInProgress.add(moduleName);
        Map<String, Symbol> customSymbols = TypeShed.getSymbolsFromProtobufModule(moduleName, PROTOBUF_CUSTOM_STUBS);
        if (!customSymbols.isEmpty()) {
            modulesInProgress.remove(moduleName);
            return customSymbols;
        }
        Map<String, Symbol> symbolsFromProtobuf = TypeShed.getSymbolsFromProtobufModule(moduleName, PROTOBUF);
        if (!symbolsFromProtobuf.isEmpty()) {
            modulesInProgress.remove(moduleName);
            return symbolsFromProtobuf;
        }
        Map<String, Symbol> thirdPartySymbols = TypeShed.getSymbolsFromProtobufModule(moduleName, PROTOBUF_THIRD_PARTY);
        modulesInProgress.remove(moduleName);
        return thirdPartySymbols;
    }

    @CheckForNull
    static Symbol disambiguateWithLatestPythonSymbol(Set<Symbol> alternatives) {
        int max = Integer.MIN_VALUE;
        Symbol latestPythonSymbol = null;
        for (Symbol alternative : alternatives) {
            int maxPythonVersionForSymbol = ((SymbolImpl)alternative).validForPythonVersions().stream().mapToInt(Integer::parseInt).max().orElse(max);
            if (maxPythonVersionForSymbol <= max) continue;
            max = maxPythonVersionForSymbol;
            latestPythonSymbol = alternative;
        }
        return latestPythonSymbol;
    }

    private static boolean isAmbiguousSymbolOfClasses(Symbol symbol) {
        if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
            return ((AmbiguousSymbol)symbol).alternatives().stream().allMatch(s -> s.is(Symbol.Kind.CLASS));
        }
        return false;
    }

    private static Map<String, Symbol> getSymbolsFromProtobufModule(String moduleName, String dirName) {
        String fileName = MODULES_TO_DISAMBIGUATE.getOrDefault(moduleName, moduleName);
        InputStream resource = TypeShed.class.getResourceAsStream(dirName + fileName + ".protobuf");
        if (resource == null) {
            return Collections.emptyMap();
        }
        return TypeShed.getSymbolsFromProtobufModule(TypeShed.deserializedModule(moduleName, resource));
    }

    @CheckForNull
    static SymbolsProtos.ModuleSymbol deserializedModule(String moduleName, InputStream resource) {
        try {
            return SymbolsProtos.ModuleSymbol.parseFrom(resource);
        }
        catch (IOException e) {
            LOG.debug("Error while deserializing protobuf for module " + moduleName, (Object)e);
            return null;
        }
    }

    static Map<String, Symbol> getSymbolsFromProtobufModule(@Nullable SymbolsProtos.ModuleSymbol moduleSymbol) {
        if (moduleSymbol == null) {
            return Collections.emptyMap();
        }
        HashMap descriptorsByName = new HashMap();
        moduleSymbol.getClassesList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion((List<String>)d.getValidForList())).forEach(proto -> descriptorsByName.computeIfAbsent(proto.getName(), d -> new HashSet()).add(proto));
        moduleSymbol.getFunctionsList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion((List<String>)d.getValidForList())).forEach(proto -> descriptorsByName.computeIfAbsent(proto.getName(), d -> new HashSet()).add(proto));
        moduleSymbol.getOverloadedFunctionsList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion((List<String>)d.getValidForList())).forEach(proto -> descriptorsByName.computeIfAbsent(proto.getName(), d -> new HashSet()).add(proto));
        moduleSymbol.getVarsList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion((List<String>)d.getValidForList())).forEach(proto -> descriptorsByName.computeIfAbsent(proto.getName(), d -> new HashSet()).add(proto));
        HashMap<String, Symbol> deserializedSymbols = new HashMap<String, Symbol>();
        for (Map.Entry entry : descriptorsByName.entrySet()) {
            String name = (String)entry.getKey();
            Set<Symbol> symbols = TypeShed.symbolsFromProtobufDescriptors((Set)entry.getValue(), null, moduleSymbol.getFullyQualifiedName(), false);
            Symbol disambiguatedSymbol = TypeShed.disambiguateSymbolsWithSameName(name, symbols, moduleSymbol.getFullyQualifiedName());
            deserializedSymbols.put(name, disambiguatedSymbol);
        }
        return deserializedSymbols;
    }

    private static Symbol disambiguateSymbolsWithSameName(String name, Set<Symbol> symbols, String moduleFqn) {
        if (symbols.size() > 1) {
            if (TypeShed.haveAllTheSameFqn(symbols) && !TypeShed.isBuiltinToDisambiguate(moduleFqn, name)) {
                return AmbiguousSymbolImpl.create(symbols);
            }
            if (!moduleFqn.equals(BUILTINS_FQN)) {
                String fqns = symbols.stream().map(Symbol::fullyQualifiedName).map(fqn -> fqn == null ? "N/A" : fqn).collect(Collectors.joining(","));
                LOG.debug("Symbol " + name + " has conflicting fully qualified names:" + fqns);
                LOG.debug("It has been disambiguated with its latest Python version available symbol.");
            }
            return TypeShed.disambiguateWithLatestPythonSymbol(symbols);
        }
        return symbols.iterator().next();
    }

    private static boolean isBuiltinToDisambiguate(String moduleFqn, String name) {
        return moduleFqn.equals(BUILTINS_FQN) && BUILTINS_TO_DISAMBIGUATE.contains(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean haveAllTheSameFqn(Set<Symbol> symbols) {
        String firstFqn = symbols.iterator().next().fullyQualifiedName();
        if (firstFqn == null) return false;
        if (!symbols.stream().map(Symbol::fullyQualifiedName).allMatch(firstFqn::equals)) return false;
        return true;
    }

    private static AmbiguousSymbol fromOverloadedFunction(SymbolsProtos.OverloadedFunctionSymbol overloadedFunctionSymbol, @Nullable String containerClassFqn, String moduleName) {
        Set<Symbol> overloadedSymbols = overloadedFunctionSymbol.getDefinitionsList().stream().map(def -> new FunctionSymbolImpl((SymbolsProtos.FunctionSymbol)def, containerClassFqn, (List<String>)overloadedFunctionSymbol.getValidForList(), moduleName)).collect(Collectors.toSet());
        return AmbiguousSymbolImpl.create(overloadedSymbols);
    }

    static {
        typeShedSymbols = new HashMap<String, Map<String, Symbol>>();
        builtinGlobalSymbols = new HashMap<String, Set<Symbol>>();
        modulesInProgress = new HashSet<String>();
        BUILTINS_TO_DISAMBIGUATE = new HashSet<String>(Arrays.asList("int", "float", "complex", "str", "set", "dict", "list", "tuple", "NoneType", "bool", "type", "super", "frozenset", "memoryview"));
        MODULES_TO_DISAMBIGUATE = new HashMap<String, String>();
        MODULES_TO_DISAMBIGUATE.put("ConfigParser", "2@ConfigParser");
        MODULES_TO_DISAMBIGUATE.put("Queue", "2@Queue");
        MODULES_TO_DISAMBIGUATE.put("SocketServer", "2@SocketServer");
        BUILTINS_TO_DISAMBIGUATE.addAll(BuiltinSymbols.EXCEPTIONS);
        LOG = Loggers.get(TypeShed.class);
    }
}

