/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.regex.PythonAnalyzerRegexSource;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonar.python.regex.RegexContext;
import org.sonar.python.types.TypeShed;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.RegexParser;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class SubscriptionVisitor {
    private final EnumMap<Tree.Kind, List<SubscriptionContextImpl>> consumers = new EnumMap(Tree.Kind.class);
    private final PythonVisitorContext pythonVisitorContext;
    private Tree currentElement;
    private final HashMap<String, RegexParseResult> regexCache = new HashMap();

    public static void analyze(Collection<PythonSubscriptionCheck> checks, PythonVisitorContext pythonVisitorContext) {
        SubscriptionVisitor subscriptionVisitor = new SubscriptionVisitor(checks, pythonVisitorContext);
        FileInput rootTree = pythonVisitorContext.rootTree();
        if (rootTree != null) {
            subscriptionVisitor.scan(rootTree);
            checks.forEach(PythonSubscriptionCheck::leaveFile);
        }
    }

    private SubscriptionVisitor(Collection<PythonSubscriptionCheck> checks, PythonVisitorContext pythonVisitorContext) {
        this.pythonVisitorContext = pythonVisitorContext;
        for (PythonSubscriptionCheck check : checks) {
            check.initialize((elementType, consumer) -> {
                List elementConsumers = this.consumers.computeIfAbsent(elementType, c -> new ArrayList());
                elementConsumers.add(new SubscriptionContextImpl(check, consumer));
            });
        }
    }

    private void scan(Tree element) {
        ArrayDeque<Tree> stack = new ArrayDeque<Tree>();
        stack.push(element);
        while (!stack.isEmpty()) {
            this.currentElement = (Tree)stack.pop();
            this.consumers.getOrDefault((Object)this.currentElement.getKind(), Collections.emptyList()).forEach(SubscriptionContextImpl::execute);
            for (int i = this.currentElement.children().size() - 1; i >= 0; --i) {
                if (this.currentElement.children().get(i) == null) continue;
                stack.push(this.currentElement.children().get(i));
            }
        }
    }

    private class SubscriptionContextImpl
    implements SubscriptionContext,
    RegexContext {
        private final PythonCheck check;
        private final Consumer<SubscriptionContext> consumer;

        SubscriptionContextImpl(PythonCheck check, Consumer<SubscriptionContext> consumer) {
            this.check = check;
            this.consumer = consumer;
        }

        public void execute() {
            this.consumer.accept(this);
        }

        @Override
        public Tree syntaxNode() {
            return SubscriptionVisitor.this.currentElement;
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(Tree element, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(element, message));
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(LocationInFile location, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(location, message));
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(Token token, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(token, message));
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(Token from, Token to, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(from, to, message));
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(RegexSyntaxElement element, @Nullable String message) {
            return this.addIssue(PythonRegexIssueLocation.preciseLocation(element, message));
        }

        @Override
        public PythonCheck.PreciseIssue addFileIssue(String message) {
            return this.addIssue(IssueLocation.atFileLevel(message));
        }

        @Override
        public PythonCheck.PreciseIssue addLineIssue(String message, int lineNumber) {
            return this.addIssue(IssueLocation.atLineLevel(message, lineNumber));
        }

        private PythonCheck.PreciseIssue addIssue(IssueLocation issueLocation) {
            IssueWithQuickFix newIssue = new IssueWithQuickFix(this.check, issueLocation);
            SubscriptionVisitor.this.pythonVisitorContext.addIssue(newIssue);
            return newIssue;
        }

        @Override
        public PythonFile pythonFile() {
            return SubscriptionVisitor.this.pythonVisitorContext.pythonFile();
        }

        @Override
        public Collection<Symbol> stubFilesSymbols() {
            return TypeShed.stubFilesSymbols();
        }

        @Override
        @CheckForNull
        public File workingDirectory() {
            return SubscriptionVisitor.this.pythonVisitorContext.workingDirectory();
        }

        @Override
        public CacheContext cacheContext() {
            return SubscriptionVisitor.this.pythonVisitorContext.cacheContext();
        }

        @Override
        public RegexParseResult regexForStringElement(StringElement stringElement, FlagSet flagSet) {
            return SubscriptionVisitor.this.regexCache.computeIfAbsent(stringElement.hashCode() + "-" + flagSet.getMask(), s -> new RegexParser((RegexSource)new PythonAnalyzerRegexSource(stringElement), flagSet).parse());
        }
    }
}

