/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.caching;

import org.sonar.api.SonarProduct;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.caching.PythonReadCache;
import org.sonar.plugins.python.api.caching.PythonWriteCache;
import org.sonar.python.caching.DummyCache;
import org.sonar.python.caching.PythonReadCacheImpl;
import org.sonar.python.caching.PythonWriteCacheImpl;

public class CacheContextImpl
implements CacheContext {
    private final boolean isCacheEnabled;
    private final PythonWriteCache writeCache;
    private final PythonReadCache readCache;

    public CacheContextImpl(boolean isCacheEnabled, PythonWriteCache writeCache, PythonReadCache readCache) {
        this.isCacheEnabled = isCacheEnabled;
        this.writeCache = writeCache;
        this.readCache = readCache;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    @Override
    public PythonReadCache getReadCache() {
        return this.readCache;
    }

    @Override
    public PythonWriteCache getWriteCache() {
        return this.writeCache;
    }

    public static CacheContextImpl of(SensorContext context) {
        if (!context.runtime().getProduct().equals((Object)SonarProduct.SONARLINT) && context.runtime().getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)7))) {
            return new CacheContextImpl(false, new PythonWriteCacheImpl(context.nextCache()), new PythonReadCacheImpl(context.previousCache()));
        }
        return new CacheContextImpl(false, new DummyCache(), new DummyCache());
    }

    public static CacheContextImpl dummyCache() {
        return new CacheContextImpl(false, new DummyCache(), new DummyCache());
    }
}

