/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.index;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.python.index.Descriptor;

public class AmbiguousDescriptor
implements Descriptor {
    private final Set<Descriptor> descriptors;
    private final String name;
    private final String fullyQualifiedName;

    public AmbiguousDescriptor(String name, @Nullable String fullyQualifiedName, Set<Descriptor> descriptors) {
        if (descriptors.stream().anyMatch(d -> d.kind().equals((Object)Descriptor.Kind.AMBIGUOUS))) {
            throw new IllegalArgumentException("Ambiguous descriptors should not be nested.");
        }
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.descriptors = descriptors;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public Descriptor.Kind kind() {
        return Descriptor.Kind.AMBIGUOUS;
    }

    public Set<Descriptor> alternatives() {
        return this.descriptors;
    }

    public static AmbiguousDescriptor create(Descriptor ... descriptors) {
        return AmbiguousDescriptor.create(new HashSet<Descriptor>(Arrays.asList(descriptors)));
    }

    public static AmbiguousDescriptor create(Set<Descriptor> descriptors) {
        if (descriptors.size() < 2) {
            throw new IllegalArgumentException("Ambiguous symbol should contain at least two descriptors");
        }
        Descriptor firstSymbol = descriptors.iterator().next();
        String resultingSymbolName = firstSymbol.name();
        if (!descriptors.stream().map(Descriptor::name).allMatch(symbolName -> symbolName.equals(firstSymbol.name()))) {
            throw new IllegalArgumentException("Ambiguous descriptor should contain descriptors with the same name.");
        }
        return new AmbiguousDescriptor(resultingSymbolName, firstSymbol.fullyQualifiedName(), AmbiguousDescriptor.flattenAmbiguousDescriptors(descriptors));
    }

    private static Set<Descriptor> flattenAmbiguousDescriptors(Set<Descriptor> descriptors) {
        HashSet<Descriptor> alternatives = new HashSet<Descriptor>();
        for (Descriptor descriptor : descriptors) {
            if (descriptor.kind() == Descriptor.Kind.AMBIGUOUS) {
                Set<Descriptor> flattenedAlternatives = AmbiguousDescriptor.flattenAmbiguousDescriptors(((AmbiguousDescriptor)descriptor).alternatives());
                alternatives.addAll(flattenedAlternatives);
                continue;
            }
            alternatives.add(descriptor);
        }
        return alternatives;
    }
}

