/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.python.regex.PythonStringCharacterParser;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.python.PythonRegexSource;

public class PythonAnalyzerRegexSource
extends PythonRegexSource {
    private static final IndexRange OPENER_RANGE = new IndexRange(-1, 0);
    private final int sourceLine;
    private final int sourceStartOffset;
    private final int[] lineStartOffsets;
    private final boolean isRawString;

    public PythonAnalyzerRegexSource(StringElement s) {
        super(s.trimmedQuotesValue());
        String prefix = s.prefix();
        Token firstToken = s.firstToken();
        this.sourceLine = firstToken.line();
        this.sourceStartOffset = firstToken.column() + (s.isTripleQuoted() ? 3 : 1) + prefix.length();
        this.lineStartOffsets = PythonAnalyzerRegexSource.lineStartOffsets(this.getSourceText());
        this.isRawString = prefix.toLowerCase(Locale.ROOT).contains("r");
    }

    public CharacterParser createCharacterParser() {
        return new PythonStringCharacterParser(this);
    }

    public LocationInFile locationInFileFor(IndexRange range) {
        if (OPENER_RANGE.equals((Object)range)) {
            return new LocationInFile(null, this.sourceLine, this.sourceStartOffset - 2, this.sourceLine, this.sourceStartOffset - 1);
        }
        int[] startLineAndOffset = this.lineAndOffset(range.getBeginningOffset());
        int[] endLineAndOffset = this.lineAndOffset(range.getEndingOffset());
        return new LocationInFile(null, startLineAndOffset[0], startLineAndOffset[1], endLineAndOffset[0], endLineAndOffset[1]);
    }

    public boolean isRawString() {
        return this.isRawString;
    }

    private int[] lineAndOffset(int index) {
        int offset;
        int line;
        int searchResult = Arrays.binarySearch(this.lineStartOffsets, index);
        if (searchResult >= 0) {
            line = this.sourceLine + searchResult;
            offset = 0;
        } else {
            line = this.sourceLine - searchResult - 2;
            offset = index - this.lineStartOffsets[-searchResult - 2];
        }
        if (line == this.sourceLine) {
            offset += this.sourceStartOffset;
        }
        return new int[]{line, offset};
    }

    private static int[] lineStartOffsets(String text) {
        ArrayList<Integer> lineStartOffsets = new ArrayList<Integer>();
        lineStartOffsets.add(0);
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) != '\n' && text.charAt(i) != '\r') continue;
            int nextLineStartOffset = i + 1;
            if (i < length - 1 && text.charAt(i) == '\r' && text.charAt(i + 1) == '\n') {
                nextLineStartOffset = i + 2;
                ++i;
            }
            lineStartOffsets.add(nextLineStartOffset);
        }
        return lineStartOffsets.stream().mapToInt(x -> x).toArray();
    }
}

