/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.UsageImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class SymbolImpl
implements Symbol {
    private final String name;
    @Nullable
    String fullyQualifiedName;
    private final List<Usage> usages = new ArrayList<Usage>();
    private Map<String, Symbol> childrenSymbolByName = new HashMap<String, Symbol>();
    private Symbol.Kind kind;
    private InferredType inferredType = InferredTypes.anyType();
    private String annotatedTypeName = null;
    private SymbolsProtos.Type deserializedType = null;
    private boolean hasReadDeserializedType = false;
    protected Set<String> validForPythonVersions = Collections.emptySet();

    public SymbolImpl(String name, @Nullable String fullyQualifiedName) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.kind = Symbol.Kind.OTHER;
    }

    public SymbolImpl(SymbolsProtos.VarSymbol varSymbol, String moduleName, boolean isFromClass) {
        this.name = varSymbol.getName();
        this.fullyQualifiedName = TypeShed.normalizedFqn(varSymbol.getFullyQualifiedName(), moduleName, this.name);
        String fqn = varSymbol.getTypeAnnotation().getFullyQualifiedName();
        if (!fqn.isEmpty()) {
            this.annotatedTypeName = TypeShed.normalizedFqn(fqn);
        }
        this.deserializedType = isFromClass ? varSymbol.getTypeAnnotation() : null;
        this.validForPythonVersions = new HashSet<String>((Collection<String>)varSymbol.getValidForList());
        this.kind = Symbol.Kind.OTHER;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Usage> usages() {
        return Collections.unmodifiableList(this.usages);
    }

    @Override
    @CheckForNull
    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public boolean is(Symbol.Kind ... kinds) {
        Symbol.Kind symbolKind = this.kind();
        for (Symbol.Kind kindIter : kinds) {
            if (symbolKind != kindIter) continue;
            return true;
        }
        return false;
    }

    @Override
    public Symbol.Kind kind() {
        return this.kind;
    }

    public void setKind(Symbol.Kind kind) {
        this.kind = kind;
    }

    void addUsage(Tree tree, Usage.Kind kind) {
        UsageImpl usage = new UsageImpl(tree, kind);
        this.usages.add(usage);
        if (tree.is(Tree.Kind.NAME)) {
            ((NameImpl)tree).setSymbol(this);
            ((NameImpl)tree).setUsage(usage);
        }
    }

    void addOrCreateChildUsage(Name name, Usage.Kind kind) {
        String childSymbolName = name.name();
        if (!this.childrenSymbolByName.containsKey(childSymbolName)) {
            String childFullyQualifiedName = this.fullyQualifiedName != null ? this.fullyQualifiedName + "." + childSymbolName : null;
            SymbolImpl symbol = new SymbolImpl(childSymbolName, childFullyQualifiedName);
            this.childrenSymbolByName.put(childSymbolName, symbol);
        }
        Symbol symbol = this.childrenSymbolByName.get(childSymbolName);
        ((SymbolImpl)symbol).addUsage(name, kind);
    }

    public void addChildSymbol(Symbol symbol) {
        this.childrenSymbolByName.put(symbol.name(), symbol);
    }

    public InferredType inferredType() {
        if (!this.hasReadDeserializedType && this.deserializedType != null) {
            this.inferredType = InferredTypes.fromTypeshedProtobuf(this.deserializedType);
            this.hasReadDeserializedType = true;
        }
        return this.inferredType;
    }

    public void setInferredType(InferredType inferredType) {
        this.inferredType = inferredType;
    }

    @Override
    public String annotatedTypeName() {
        return this.annotatedTypeName;
    }

    public void setAnnotatedTypeName(TypeAnnotation typeAnnotation) {
        this.annotatedTypeName = Optional.ofNullable(SymbolImpl.getTypeSymbolFromExpression(typeAnnotation.expression())).map(Symbol::fullyQualifiedName).orElse(null);
    }

    public SymbolImpl copyWithoutUsages() {
        return this.copyWithoutUsages(this.name());
    }

    public SymbolImpl copyWithoutUsages(String name) {
        SymbolImpl copiedSymbol = new SymbolImpl(name, this.fullyQualifiedName());
        copiedSymbol.annotatedTypeName = this.annotatedTypeName;
        copiedSymbol.deserializedType = this.deserializedType;
        return copiedSymbol;
    }

    public void removeUsages() {
        this.usages.clear();
        this.childrenSymbolByName.values().forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
    }

    public Map<String, Symbol> getChildrenSymbolByName() {
        return Collections.unmodifiableMap(this.childrenSymbolByName);
    }

    @Nullable
    static Symbol getTypeSymbolFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            SubscriptionExpression subscriptionExpression = (SubscriptionExpression)expression;
            return SymbolImpl.getTypeSymbolFromExpression(subscriptionExpression.object());
        }
        if (expression instanceof HasSymbol) {
            return ((HasSymbol)((Object)expression)).symbol();
        }
        return null;
    }

    public Set<String> validForPythonVersions() {
        return this.validForPythonVersions;
    }
}

