/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.python.api.tree.MappingPattern;
import org.sonar.plugins.python.api.tree.Pattern;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class MappingPatternImpl
extends PyTree
implements MappingPattern {
    private final Token lCurlyBrace;
    private final List<Token> commas;
    private final List<Pattern> elements;
    private final Token rCurlyBrace;

    public MappingPatternImpl(Token lCurlyBrace, List<Token> commas, List<Pattern> elements, Token rCurlyBrace) {
        this.lCurlyBrace = lCurlyBrace;
        this.commas = commas;
        this.elements = elements;
        this.rCurlyBrace = rCurlyBrace;
    }

    @Override
    public Token lCurlyBrace() {
        return this.lCurlyBrace;
    }

    @Override
    public List<Pattern> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public List<Token> commas() {
        return Collections.unmodifiableList(this.commas);
    }

    @Override
    public Token rCurlyBrace() {
        return this.rCurlyBrace;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMappingPattern(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.MAPPING_PATTERN;
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> child = new ArrayList<Tree>();
        child.add(this.lCurlyBrace);
        int i = 0;
        for (Pattern element : this.elements) {
            child.add(element);
            if (i < this.commas.size()) {
                child.add(this.commas.get(i));
            }
            ++i;
        }
        child.add(this.rCurlyBrace);
        return child;
    }
}

