/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.FlowSensitiveTypeInference;
import org.sonar.python.types.HasTypeDependencies;
import org.sonar.python.types.InferredTypes;

public class TypeInference
extends BaseTreeVisitor {
    private static final InferredType TYPE_OF_SUPER = InferredTypes.runtimeBuiltinType("super");
    private final Map<Symbol, Set<Assignment>> assignmentsByLhs = new HashMap<Symbol, Set<Assignment>>();
    private final Map<QualifiedExpression, MemberAccess> memberAccessesByQualifiedExpr = new HashMap<QualifiedExpression, MemberAccess>();
    private final Map<AssignmentStatement, Assignment> assignmentsByAssignmentStatement = new HashMap<AssignmentStatement, Assignment>();
    private Map<String, InferredType> parameterTypesByName = new HashMap<String, InferredType>();

    public static void inferTypes(FileInput fileInput, final PythonFile pythonFile) {
        fileInput.accept(new BaseTreeVisitor(){

            @Override
            public void visitFunctionDef(FunctionDef funcDef) {
                super.visitFunctionDef(funcDef);
                TypeInference.inferTypesAndMemberAccessSymbols(funcDef, pythonFile);
            }
        });
        fileInput.accept(new BaseTreeVisitor(){

            @Override
            public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
                super.visitQualifiedExpression(qualifiedExpression);
                Name name = qualifiedExpression.name();
                InferredType type = qualifiedExpression.qualifier().type();
                if (!type.equals(TYPE_OF_SUPER)) {
                    Optional<Symbol> resolvedMember = type.resolveMember(name.name());
                    resolvedMember.ifPresent(((NameImpl)name)::setSymbol);
                }
            }
        });
    }

    private static Set<Symbol> getTrackedVars(Set<Symbol> localVariables, Set<Name> assignedNames) {
        HashSet<Symbol> trackedVars = new HashSet<Symbol>();
        for (Symbol variable : localVariables) {
            boolean hasMissingBindingUsage = variable.usages().stream().filter(Usage::isBindingUsage).anyMatch(u -> !assignedNames.contains(u.tree()));
            if (hasMissingBindingUsage) continue;
            trackedVars.add(variable);
        }
        return trackedVars;
    }

    private static void inferTypesAndMemberAccessSymbols(FunctionDef functionDef, PythonFile pythonFile) {
        TypeInference visitor = new TypeInference();
        functionDef.accept(visitor);
        Set<Name> assignedNames = visitor.assignmentsByLhs.values().stream().flatMap(Collection::stream).map(a -> a.lhsName).collect(Collectors.toSet());
        TryStatementVisitor tryStatementVisitor = new TryStatementVisitor(functionDef);
        functionDef.body().accept(tryStatementVisitor);
        if (tryStatementVisitor.hasTryStatement) {
            visitor.processPropagations(TypeInference.getTrackedVars(functionDef.localVariables(), assignedNames));
            functionDef.body().accept(new BaseTreeVisitor(){

                @Override
                public void visitFunctionDef(FunctionDef visited) {
                }

                @Override
                public void visitName(Name name) {
                    Optional.ofNullable(name.symbol()).ifPresent(symbol -> ((NameImpl)name).setInferredType(((SymbolImpl)symbol).inferredType()));
                    super.visitName(name);
                }
            });
        } else {
            ControlFlowGraph cfg = ControlFlowGraph.build(functionDef, pythonFile);
            if (cfg == null) {
                return;
            }
            Set annotatedParamNames = TreeUtils.nonTupleParameters(functionDef).stream().filter(parameter -> parameter.typeAnnotation() != null).map(Parameter::name).collect(Collectors.toSet());
            assignedNames.addAll(annotatedParamNames);
            visitor.flowSensitiveTypeInference(cfg, TypeInference.getTrackedVars(functionDef.localVariables(), assignedNames), functionDef);
        }
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        super.visitAssignmentStatement(assignmentStatement);
        if (assignmentStatement.lhsExpressions().stream().anyMatch(expressionList -> !expressionList.commas().isEmpty())) {
            return;
        }
        List lhsExpressions = assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).collect(Collectors.toList());
        if (lhsExpressions.size() != 1) {
            return;
        }
        Expression lhsExpression = (Expression)lhsExpressions.get(0);
        if (!lhsExpression.is(Tree.Kind.NAME)) {
            return;
        }
        Name lhs = (Name)lhsExpression;
        SymbolImpl symbol = (SymbolImpl)lhs.symbol();
        if (symbol == null) {
            return;
        }
        Expression rhs = assignmentStatement.assignedValue();
        Assignment assignment = new Assignment(symbol, lhs, rhs);
        this.assignmentsByAssignmentStatement.put(assignmentStatement, assignment);
        this.assignmentsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(assignment);
    }

    @Override
    public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
        super.visitQualifiedExpression(qualifiedExpression);
        this.memberAccessesByQualifiedExpr.put(qualifiedExpression, new MemberAccess(qualifiedExpression));
    }

    private void flowSensitiveTypeInference(ControlFlowGraph cfg, Set<Symbol> trackedVars, FunctionDef functionDef) {
        Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> {
            this.parameterTypesByName = functionSymbol.parameters().stream().filter(parameter -> parameter.name() != null).collect(Collectors.toMap(FunctionSymbol.Parameter::name, FunctionSymbol.Parameter::declaredType));
        });
        FlowSensitiveTypeInference flowSensitiveTypeInference = new FlowSensitiveTypeInference(trackedVars, this.memberAccessesByQualifiedExpr, this.assignmentsByAssignmentStatement, this.parameterTypesByName);
        flowSensitiveTypeInference.compute(cfg);
        flowSensitiveTypeInference.compute(cfg);
    }

    private void processPropagations(Set<Symbol> trackedVars) {
        HashSet<Propagation> propagations = new HashSet<Propagation>();
        HashSet<Symbol> initializedVars = new HashSet<Symbol>();
        for (MemberAccess memberAccess : this.memberAccessesByQualifiedExpr.values()) {
            memberAccess.computeDependencies(memberAccess.qualifiedExpression.qualifier(), trackedVars);
            propagations.add(memberAccess);
        }
        this.assignmentsByLhs.forEach((lhs, as) -> {
            if (trackedVars.contains(lhs)) {
                as.forEach(a -> a.computeDependencies(a.rhs, trackedVars));
                propagations.addAll((Collection<Propagation>)as);
            }
        });
        this.applyPropagations(propagations, initializedVars, true);
        this.applyPropagations(propagations, initializedVars, false);
    }

    private void applyPropagations(Set<Propagation> propagations, Set<Symbol> initializedVars, boolean checkDependenciesReadiness) {
        HashSet<Propagation> workSet = new HashSet<Propagation>(propagations);
        while (!workSet.isEmpty()) {
            boolean learnt;
            Iterator iterator = workSet.iterator();
            Propagation propagation = (Propagation)iterator.next();
            iterator.remove();
            if (checkDependenciesReadiness && !propagation.areDependenciesReady(initializedVars) || !(learnt = propagation.propagate(initializedVars))) continue;
            workSet.addAll(propagation.dependents());
        }
    }

    class MemberAccess
    extends Propagation {
        private final QualifiedExpression qualifiedExpression;
        private final Symbol symbolWithoutTypeInference;

        private MemberAccess(QualifiedExpression qualifiedExpression) {
            this.qualifiedExpression = qualifiedExpression;
            this.symbolWithoutTypeInference = qualifiedExpression.symbol();
        }

        @Override
        public boolean propagate(Set<Symbol> initializedVars) {
            NameImpl name = (NameImpl)this.qualifiedExpression.name();
            InferredType type = this.qualifiedExpression.qualifier().type();
            if (!type.equals(TYPE_OF_SUPER)) {
                Optional<Symbol> resolvedMember = type.resolveMember(name.name());
                Symbol previous = name.symbol();
                if (resolvedMember.isPresent()) {
                    name.setSymbol(resolvedMember.get());
                    return previous != resolvedMember.get();
                }
                if (name.symbol() != this.symbolWithoutTypeInference) {
                    name.setSymbol(this.symbolWithoutTypeInference);
                    return true;
                }
            }
            return false;
        }
    }

    class Assignment
    extends Propagation {
        final SymbolImpl lhs;
        private final Name lhsName;
        final Expression rhs;

        private Assignment(SymbolImpl lhs, Name lhsName, Expression rhs) {
            this.lhs = lhs;
            this.lhsName = lhsName;
            this.rhs = rhs;
        }

        @Override
        public boolean propagate(Set<Symbol> initializedVars) {
            InferredType rhsType = this.rhs.type();
            if (initializedVars.add(this.lhs)) {
                this.lhs.setInferredType(rhsType);
                return true;
            }
            InferredType currentType = this.lhs.inferredType();
            InferredType newType = InferredTypes.or(rhsType, currentType);
            this.lhs.setInferredType(newType);
            return !newType.equals(currentType);
        }
    }

    private abstract class Propagation {
        private final Set<Symbol> variableDependencies = new HashSet<Symbol>();
        private final Set<QualifiedExpression> memberAccessDependencies = new HashSet<QualifiedExpression>();
        private final Set<Propagation> dependents = new HashSet<Propagation>();

        private Propagation() {
        }

        abstract boolean propagate(Set<Symbol> var1);

        void computeDependencies(Expression expression, Set<Symbol> trackedVars) {
            ArrayDeque<Expression> workList = new ArrayDeque<Expression>();
            workList.push(expression);
            while (!workList.isEmpty()) {
                Expression e = (Expression)workList.pop();
                if (e.is(Tree.Kind.NAME)) {
                    Name name = (Name)e;
                    Symbol symbol = name.symbol();
                    if (symbol == null || !trackedVars.contains(symbol)) continue;
                    this.variableDependencies.add(symbol);
                    TypeInference.this.assignmentsByLhs.get(symbol).forEach(a -> a.dependents().add(this));
                    continue;
                }
                if (e.is(Tree.Kind.QUALIFIED_EXPR)) {
                    QualifiedExpression qualifiedExpression = (QualifiedExpression)e;
                    this.memberAccessDependencies.add(qualifiedExpression);
                    TypeInference.this.memberAccessesByQualifiedExpr.get(qualifiedExpression).dependents().add(this);
                    continue;
                }
                if (!(e instanceof HasTypeDependencies)) continue;
                workList.addAll(((HasTypeDependencies)((Object)e)).typeDependencies());
            }
        }

        private boolean areDependenciesReady(Set<Symbol> initializedVars) {
            return initializedVars.containsAll(this.variableDependencies) && this.memberAccessDependencies.stream().map(QualifiedExpression::symbol).allMatch(s -> s != null && s.kind() == Symbol.Kind.FUNCTION);
        }

        Set<Propagation> dependents() {
            return this.dependents;
        }
    }

    private static class TryStatementVisitor
    extends BaseTreeVisitor {
        FunctionDef functionDef;
        boolean hasTryStatement = false;

        TryStatementVisitor(FunctionDef functionDef) {
            this.functionDef = functionDef;
        }

        @Override
        public void visitClassDef(ClassDef classDef) {
        }

        @Override
        public void visitFunctionDef(FunctionDef visited) {
        }

        @Override
        public void visitTryStatement(TryStatement tryStatement) {
            this.hasTryStatement = true;
        }
    }
}

