/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.python.lexer.LexerState;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class FStringChannel
extends Channel<Lexer> {
    private static final char EOF = '\uffff';
    private final LexerState lexerState;
    private final StringBuilder sb = new StringBuilder();

    public FStringChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    public boolean consume(CodeReader code, Lexer output) {
        this.setInitialLineAndColumn(code);
        if (code.charAt(0) == '#') {
            FStringChannel.addUnknownCharToken("#", output, code.getLinePosition(), code.getColumnPosition());
            code.pop();
            return true;
        }
        if (this.lexerState.brackets == 0) {
            int line = code.getLinePosition();
            int column = code.getColumnPosition();
            while (code.charAt(0) != '\uffff') {
                char c = code.charAt(0);
                if (c != '{') {
                    this.sb.append((char)code.pop());
                    continue;
                }
                if (code.charAt(1) != '{') break;
                this.sb.append((char)code.pop());
                this.sb.append((char)code.pop());
            }
            if (this.sb.length() != 0) {
                FStringChannel.addUnknownCharToken(this.sb.toString(), output, line, column);
                this.sb.setLength(0);
                return true;
            }
        }
        return false;
    }

    private static void addUnknownCharToken(String value, Lexer output, int line, int column) {
        output.addToken(new Token[]{Token.builder().setType((TokenType)GenericTokenType.UNKNOWN_CHAR).setValueAndOriginalValue(value).setURI(output.getURI()).setLine(line).setColumn(column).build()});
    }

    private void setInitialLineAndColumn(CodeReader code) {
        if (code.getLinePosition() == 1 && code.getColumnPosition() == 0) {
            code.setLinePosition(this.lexerState.initialLine);
            code.setColumnPosition(this.lexerState.initialColumn);
        }
    }
}

