/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.sonar.sslr.api.TokenType;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.api.PythonKeyword;

public class ComplexityVisitor
extends BaseTreeVisitor {
    private int complexity = 0;

    public static int complexity(Tree pyTree) {
        ComplexityVisitor visitor = pyTree.is(Tree.Kind.FUNCDEF) ? new FunctionComplexityVisitor() : new ComplexityVisitor();
        pyTree.accept(visitor);
        return visitor.complexity;
    }

    @Override
    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        ++this.complexity;
        super.visitFunctionDef(pyFunctionDefTree);
    }

    @Override
    public void visitForStatement(ForStatement pyForStatementTree) {
        ++this.complexity;
        super.visitForStatement(pyForStatementTree);
    }

    @Override
    public void visitWhileStatement(WhileStatement pyWhileStatementTree) {
        ++this.complexity;
        super.visitWhileStatement(pyWhileStatementTree);
    }

    @Override
    public void visitIfStatement(IfStatement pyIfStatementTree) {
        if (!pyIfStatementTree.isElif()) {
            ++this.complexity;
        }
        super.visitIfStatement(pyIfStatementTree);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpression pyConditionalExpressionTree) {
        ++this.complexity;
        super.visitConditionalExpression(pyConditionalExpressionTree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
        TokenType type = pyBinaryExpressionTree.operator().type();
        if (type.equals((Object)PythonKeyword.AND) || type.equals((Object)PythonKeyword.OR)) {
            ++this.complexity;
        }
        super.visitBinaryExpression(pyBinaryExpressionTree);
    }

    @Override
    public void visitComprehensionIf(ComprehensionIf tree) {
        ++this.complexity;
        super.visitComprehensionIf(tree);
    }

    public int getComplexity() {
        return this.complexity;
    }

    private static class FunctionComplexityVisitor
    extends ComplexityVisitor {
        private int functionNestingLevel = 0;

        private FunctionComplexityVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            ++this.functionNestingLevel;
            if (this.functionNestingLevel == 1) {
                super.visitFunctionDef(pyFunctionDefTree);
            }
            --this.functionNestingLevel;
        }
    }
}

