/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonTokenType;

public class FileLinesVisitor
extends PythonSubscriptionCheck {
    private static final List<Tree.Kind> EXECUTABLE_LINES = Arrays.asList(Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.COMPOUND_ASSIGNMENT, Tree.Kind.EXPRESSION_STMT, Tree.Kind.IMPORT_STMT, Tree.Kind.IMPORT_NAME, Tree.Kind.IMPORT_FROM, Tree.Kind.CONTINUE_STMT, Tree.Kind.BREAK_STMT, Tree.Kind.YIELD_STMT, Tree.Kind.RETURN_STMT, Tree.Kind.PRINT_STMT, Tree.Kind.PASS_STMT, Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT, Tree.Kind.IF_STMT, Tree.Kind.RAISE_STMT, Tree.Kind.TRY_STMT, Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.EXEC_STMT, Tree.Kind.ASSERT_STMT, Tree.Kind.DEL_STMT, Tree.Kind.GLOBAL_STMT, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF, Tree.Kind.FILE_INPUT);
    private Set<Integer> noSonar = new HashSet<Integer>();
    private Set<Integer> linesOfCode = new HashSet<Integer>();
    private Set<Integer> linesOfComments = new HashSet<Integer>();
    private Set<Integer> linesOfDocstring = new HashSet<Integer>();
    private Set<Integer> executableLines = new HashSet<Integer>();
    private int statements = 0;
    private int classDefs = 0;

    @Override
    public void scanFile(PythonVisitorContext visitorContext) {
        SubscriptionVisitor.analyze(Collections.singleton(this), visitorContext);
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.visitFile());
        EXECUTABLE_LINES.forEach(kind -> context.registerSyntaxNodeConsumer((Tree.Kind)((Object)kind), this::visitNode));
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> this.visitToken((Token)ctx.syntaxNode()));
    }

    private void visitFile() {
        this.noSonar.clear();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
        this.linesOfDocstring.clear();
        this.executableLines.clear();
    }

    private void visitNode(SubscriptionContext ctx) {
        Tree tree = ctx.syntaxNode();
        if (tree.is(Tree.Kind.FILE_INPUT)) {
            this.handleDocString(((FileInput)tree).docstring());
        } else {
            ++this.statements;
            this.executableLines.add(tree.firstToken().line());
        }
        if (tree.is(Tree.Kind.CLASSDEF)) {
            ++this.classDefs;
            this.handleDocString(((ClassDef)tree).docstring());
        }
        if (tree.is(Tree.Kind.FUNCDEF)) {
            this.handleDocString(((FunctionDef)tree).docstring());
        }
    }

    private void handleDocString(@Nullable StringLiteral docstring) {
        if (docstring != null) {
            for (Tree stringElement : docstring.children()) {
                TokenLocation location = new TokenLocation(stringElement.firstToken());
                for (int line = location.startLine(); line <= location.endLine(); ++line) {
                    this.linesOfDocstring.add(line);
                }
            }
        }
    }

    private void visitToken(Token token) {
        if (token.type().equals(GenericTokenType.EOF)) {
            return;
        }
        if (!(token.type().equals((Object)PythonTokenType.DEDENT) || token.type().equals((Object)PythonTokenType.INDENT) || token.type().equals((Object)PythonTokenType.NEWLINE))) {
            int tokenLine;
            String[] tokenLines = token.value().split("\n", -1);
            for (int line = tokenLine = token.line(); line < tokenLine + tokenLines.length; ++line) {
                this.linesOfCode.add(line);
            }
        }
        for (Trivia trivia : token.trivia()) {
            this.visitComment(trivia);
        }
    }

    private void visitComment(Trivia trivia) {
        String commentLine = FileLinesVisitor.getContents(trivia.token().value());
        int line = trivia.token().line();
        if (commentLine.contains("NOSONAR")) {
            this.linesOfComments.remove(line);
            this.noSonar.add(line);
        } else if (!FileLinesVisitor.isBlank(commentLine)) {
            this.linesOfComments.add(line);
        }
    }

    @Override
    public void leaveFile() {
        for (Integer line : this.linesOfDocstring) {
            this.executableLines.remove(line);
            this.linesOfCode.remove(line);
            this.linesOfComments.add(line);
        }
    }

    public Set<Integer> getLinesWithNoSonar() {
        return Collections.unmodifiableSet(this.noSonar);
    }

    public Set<Integer> getLinesOfCode() {
        return Collections.unmodifiableSet(this.linesOfCode);
    }

    public int getCommentLineCount() {
        return this.linesOfComments.size();
    }

    public Set<Integer> getExecutableLines() {
        return Collections.unmodifiableSet(this.executableLines);
    }

    private static boolean isBlank(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (!Character.isLetterOrDigit(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getContents(String comment) {
        return comment.substring(comment.indexOf(35));
    }

    public int getStatements() {
        return this.statements;
    }

    public int getClassDefs() {
        return this.classDefs;
    }
}

