/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ReturnStatementImpl
extends SimpleStatement
implements ReturnStatement {
    private final Token returnKeyword;
    private final List<Expression> expressionTrees;
    private final List<Token> commas;
    private final Separators separators;

    public ReturnStatementImpl(Token returnKeyword, List<Expression> expressionTrees, List<Token> commas, Separators separators) {
        this.returnKeyword = returnKeyword;
        this.expressionTrees = expressionTrees;
        this.commas = commas;
        this.separators = separators;
    }

    @Override
    public Token returnKeyword() {
        return this.returnKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressionTrees;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitReturnStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.returnKeyword);
        int i = 0;
        for (Expression expression : this.expressionTrees) {
            children.add(expression);
            if (i < this.commas.size()) {
                children.add(this.commas.get(i));
            }
            ++i;
        }
        children.addAll(this.separators.elements());
        return children;
    }

    @Override
    public Token separator() {
        return this.separators.last();
    }
}

