/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import com.sonar.sslr.api.AstNode;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShedPythonFile;

public class TypeShed {
    private static final String TYPING = "typing";
    private static final String TYPING_EXTENSIONS = "typing_extensions";
    private static Map<String, Symbol> builtins;
    private static final Map<String, Set<Symbol>> typeShedSymbols;
    private static final Map<String, Set<Symbol>> builtinGlobalSymbols;
    private static final Set<String> modulesInProgress;
    private static final String STDLIB_2AND3 = "typeshed/stdlib/2and3/";
    private static final String STDLIB_2 = "typeshed/stdlib/2/";
    private static final String STDLIB_3 = "typeshed/stdlib/3/";
    private static final String THIRD_PARTY_2AND3 = "typeshed/third_party/2and3/";
    private static final String THIRD_PARTY_2 = "typeshed/third_party/2/";
    private static final String THIRD_PARTY_3 = "typeshed/third_party/3/";
    private static final String CUSTOM_THIRD_PARTY = "custom/";

    private TypeShed() {
    }

    public static Map<String, Symbol> builtinSymbols() {
        if (builtins == null && !InferredTypes.isInitialized()) {
            HashMap<String, Symbol> builtins = new HashMap<String, Symbol>();
            builtins.put("NoneType", new ClassSymbolImpl("NoneType", "NoneType"));
            InputStream resource = TypeShed.class.getResourceAsStream("builtins.pyi");
            TypeShedPythonFile file = new TypeShedPythonFile(resource, "");
            AstNode astNode = PythonParser.create().parse(file.content());
            FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
            HashMap<String, Set<Symbol>> globalSymbols = new HashMap<String, Set<Symbol>>();
            Set<Symbol> typingModuleSymbols = TypeShed.typingModuleSymbols();
            globalSymbols.put(TYPING, typingModuleSymbols);
            Set<Symbol> typingExtensionsSymbols = TypeShed.typingExtensionsSymbols(Collections.singletonMap(TYPING, typingModuleSymbols));
            globalSymbols.put(TYPING_EXTENSIONS, typingExtensionsSymbols);
            new SymbolTableBuilder("", file, ProjectLevelSymbolTable.from(globalSymbols)).visitFileInput(fileInput);
            for (Symbol globalVariable : fileInput.globalVariables()) {
                ((SymbolImpl)globalVariable).removeUsages();
                builtins.put(globalVariable.fullyQualifiedName(), globalVariable);
            }
            TypeShed.builtins = Collections.unmodifiableMap(builtins);
            InferredTypes.setBuiltinSymbols(builtins);
            fileInput.accept(new ReturnTypeVisitor());
            builtinGlobalSymbols.put("", new HashSet(builtins.values()));
        }
        return builtins;
    }

    private static void setDeclaredReturnType(Symbol symbol, FunctionDef functionDef) {
        TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
        if (returnTypeAnnotation == null) {
            return;
        }
        if (symbol.is(Symbol.Kind.FUNCTION)) {
            FunctionSymbolImpl functionSymbol2 = (FunctionSymbolImpl)symbol;
            functionSymbol2.setDeclaredReturnType(InferredTypes.fromTypeshedTypeAnnotation(returnTypeAnnotation));
        } else if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
            Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> TypeShed.setDeclaredReturnType(functionSymbol, functionDef));
        }
    }

    static Set<Symbol> typingModuleSymbols() {
        Map<String, Symbol> typingPython3 = TypeShed.getModuleSymbols(TYPING, STDLIB_3, Collections.emptyMap());
        Map<String, Symbol> typingPython2 = TypeShed.getModuleSymbols(TYPING, STDLIB_2, Collections.emptyMap());
        return TypeShed.commonSymbols(typingPython2, typingPython3, TYPING);
    }

    private static Set<Symbol> commonSymbols(Map<String, Symbol> symbolsPython2, Map<String, Symbol> symbolsPython3, String packageName) {
        HashSet<Symbol> commonSymbols = new HashSet<Symbol>();
        symbolsPython3.forEach((localName, python3Symbol) -> {
            Symbol python2Symbol = (Symbol)symbolsPython2.get(localName);
            if (python2Symbol == null) {
                commonSymbols.add((Symbol)python3Symbol);
            } else {
                HashSet<Symbol> symbols = new HashSet<Symbol>();
                symbols.add(python2Symbol);
                symbols.add((Symbol)python3Symbol);
                commonSymbols.add(new AmbiguousSymbolImpl((String)localName, packageName + "." + localName, (Set<Symbol>)symbols));
            }
        });
        symbolsPython2.forEach((localName, python2Symbol) -> {
            if (symbolsPython3.get(localName) == null) {
                commonSymbols.add((Symbol)python2Symbol);
            }
        });
        return commonSymbols;
    }

    static Set<Symbol> typingExtensionsSymbols(Map<String, Set<Symbol>> typingSymbols) {
        Map<String, Symbol> typingExtensionSymbols = TypeShed.getModuleSymbols(TYPING_EXTENSIONS, THIRD_PARTY_2AND3, typingSymbols);
        return new HashSet<Symbol>(typingExtensionSymbols.values());
    }

    public static Set<Symbol> symbolsForModule(String moduleName) {
        if (!typeShedSymbols.containsKey(moduleName)) {
            Set<Symbol> symbols = TypeShed.searchTypeShedForModule(moduleName);
            typeShedSymbols.put(moduleName, symbols);
            return symbols;
        }
        return typeShedSymbols.get(moduleName);
    }

    @CheckForNull
    public static Symbol symbolWithFQN(String stdLibModuleName, String fullyQualifiedName) {
        Set<Symbol> symbols = TypeShed.symbolsForModule(stdLibModuleName);
        Symbol symbolByFqn = symbols.stream().filter(s -> fullyQualifiedName.equals(s.fullyQualifiedName())).findFirst().orElse(null);
        if (symbolByFqn != null || !fullyQualifiedName.contains(".")) {
            return symbolByFqn;
        }
        String[] fqnSplittedByDot = fullyQualifiedName.split("\\.");
        String symbolLocalNameFromFqn = fqnSplittedByDot[fqnSplittedByDot.length - 1];
        Set matchByName = symbols.stream().filter(s -> symbolLocalNameFromFqn.equals(s.name())).collect(Collectors.toSet());
        if (matchByName.size() == 1) {
            return (Symbol)matchByName.iterator().next();
        }
        return null;
    }

    private static Set<Symbol> searchTypeShedForModule(String moduleName) {
        if (modulesInProgress.contains(moduleName)) {
            return new HashSet<Symbol>();
        }
        modulesInProgress.add(moduleName);
        HashSet<Symbol> customSymbols = new HashSet<Symbol>(TypeShed.getModuleSymbols(moduleName, CUSTOM_THIRD_PARTY, builtinGlobalSymbols).values());
        if (!customSymbols.isEmpty()) {
            modulesInProgress.remove(moduleName);
            return customSymbols;
        }
        Set<Symbol> standardLibrarySymbols = new HashSet<Symbol>(TypeShed.getModuleSymbols(moduleName, STDLIB_2AND3, builtinGlobalSymbols).values());
        if (standardLibrarySymbols.isEmpty()) {
            standardLibrarySymbols = TypeShed.commonSymbols(TypeShed.getModuleSymbols(moduleName, STDLIB_2, builtinGlobalSymbols), TypeShed.getModuleSymbols(moduleName, STDLIB_3, builtinGlobalSymbols), moduleName);
        }
        if (!standardLibrarySymbols.isEmpty()) {
            modulesInProgress.remove(moduleName);
            return standardLibrarySymbols;
        }
        Set<Symbol> thirdPartySymbols = new HashSet<Symbol>(TypeShed.getModuleSymbols(moduleName, THIRD_PARTY_2AND3, builtinGlobalSymbols).values());
        if (thirdPartySymbols.isEmpty()) {
            thirdPartySymbols = TypeShed.commonSymbols(TypeShed.getModuleSymbols(moduleName, THIRD_PARTY_2, builtinGlobalSymbols), TypeShed.getModuleSymbols(moduleName, THIRD_PARTY_3, builtinGlobalSymbols), moduleName);
        }
        modulesInProgress.remove(moduleName);
        return thirdPartySymbols;
    }

    @Nullable
    private static ModuleDescription getResourceForModule(String moduleName, String categoryPath) {
        CharSequence[] moduleNameHierarchy = moduleName.split("\\.");
        String pathToModule = String.join((CharSequence)"/", moduleNameHierarchy);
        CharSequence moduleFileName = moduleNameHierarchy[moduleNameHierarchy.length - 1];
        String packageName = String.join((CharSequence)".", Arrays.copyOfRange(moduleNameHierarchy, 0, moduleNameHierarchy.length - 1));
        InputStream resource = TypeShed.class.getResourceAsStream(categoryPath + pathToModule + ".pyi");
        if (resource == null) {
            resource = TypeShed.class.getResourceAsStream(categoryPath + pathToModule + "/__init__.pyi");
            if (resource == null) {
                return null;
            }
            moduleFileName = "__init__";
            packageName = moduleName;
        }
        return new ModuleDescription(resource, (String)moduleFileName, packageName);
    }

    private static Map<String, Symbol> getModuleSymbols(String moduleName, String categoryPath, Map<String, Set<Symbol>> initialSymbols) {
        ModuleDescription moduleDescription = TypeShed.getResourceForModule(moduleName, categoryPath);
        if (moduleDescription == null) {
            return Collections.emptyMap();
        }
        TypeShedPythonFile file = new TypeShedPythonFile(moduleDescription.resource, moduleDescription.fileName);
        AstNode astNode = PythonParser.create().parse(file.content());
        FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
        new SymbolTableBuilder(moduleDescription.packageName, file, ProjectLevelSymbolTable.from(initialSymbols)).visitFileInput(fileInput);
        fileInput.accept(new ReturnTypeVisitor());
        return fileInput.globalVariables().stream().map(symbol -> {
            ((SymbolImpl)symbol).removeUsages();
            return symbol;
        }).filter(s -> s.fullyQualifiedName() != null).collect(Collectors.toMap(Symbol::name, Function.identity(), (xva$0, xva$1) -> AmbiguousSymbolImpl.create(xva$0, xva$1)));
    }

    public static ClassSymbol typeShedClass(String fullyQualifiedName) {
        Symbol symbol = TypeShed.builtinSymbols().get(fullyQualifiedName);
        if (symbol == null) {
            throw new IllegalArgumentException("No TypeShed symbol found for name: " + fullyQualifiedName);
        }
        if (symbol.kind() != Symbol.Kind.CLASS) {
            throw new IllegalArgumentException("TypeShed symbol " + fullyQualifiedName + " is not a class");
        }
        return (ClassSymbol)symbol;
    }

    public static Collection<Symbol> stubFilesSymbols() {
        HashSet<Symbol> symbols = new HashSet<Symbol>(TypeShed.builtinSymbols().values());
        typeShedSymbols.values().forEach(symbols::addAll);
        return symbols;
    }

    static {
        typeShedSymbols = new HashMap<String, Set<Symbol>>();
        builtinGlobalSymbols = new HashMap<String, Set<Symbol>>();
        modulesInProgress = new HashSet<String>();
    }

    private static class ModuleDescription {
        InputStream resource;
        String fileName;
        String packageName;

        ModuleDescription(InputStream resource, String fileName, String packageName) {
            this.resource = resource;
            this.fileName = fileName;
            this.packageName = packageName;
        }
    }

    static class ReturnTypeVisitor
    extends BaseTreeVisitor {
        ReturnTypeVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> {
                TypeShed.setDeclaredReturnType(symbol, functionDef);
                ReturnTypeVisitor.setParameterTypes(symbol, functionDef);
                ReturnTypeVisitor.setAnnotatedReturnType(symbol, functionDef);
            });
            super.visitFunctionDef(functionDef);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                Name variable = (Name)annotatedAssignment.variable();
                Optional.ofNullable(variable.symbol()).ifPresent(symbol -> ReturnTypeVisitor.setAnnotatedType(symbol, annotatedAssignment));
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }

        private static void setAnnotatedType(Symbol symbol, AnnotatedAssignment annotatedAssignment) {
            TypeAnnotation typeAnnotation = annotatedAssignment.annotation();
            if (symbol.is(Symbol.Kind.OTHER)) {
                SymbolImpl other = (SymbolImpl)symbol;
                other.setAnnotatedTypeName(typeAnnotation);
            }
        }

        private static void setAnnotatedReturnType(Symbol symbol, FunctionDef functionDef) {
            TypeAnnotation typeAnnotation = functionDef.returnTypeAnnotation();
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                ((FunctionSymbolImpl)symbol).setAnnotatedReturnTypeName(typeAnnotation);
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
                Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> ReturnTypeVisitor.setAnnotatedReturnType(functionSymbol, functionDef));
            }
        }

        private static void setParameterTypes(Symbol symbol, FunctionDef functionDef) {
            FunctionSymbol funcDefSymbol;
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
                ParameterList parameters = functionDef.parameters();
                if (parameters != null) {
                    functionSymbol.setParametersWithType(parameters);
                }
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS) && (funcDefSymbol = ((FunctionDefImpl)functionDef).functionSymbol()) != null) {
                ReturnTypeVisitor.setParameterTypes(funcDefSymbol, functionDef);
            }
        }
    }
}

